/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.lang.reflect.Array;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.IterableUtil;

public class ShouldContainSubsequence
extends BasicErrorMessageFactory {
    public static ShouldContainSubsequence actualDoesNotHaveEnoughElementsToContainSubsequence(Object actual, Object subsequence) {
        return new ShouldContainSubsequence(actual, subsequence);
    }

    private ShouldContainSubsequence(Object actual, Object subsequence) {
        super("%nExpecting actual to contain the specified subsequence but actual does not have enough elements to contain it, actual size is %s when subsequence size is %s%nactual:%n  %s%nsubsequence:%n  %s", ShouldContainSubsequence.sizeOfArrayOrIterable(actual), Arrays.sizeOf(subsequence), actual, subsequence);
    }

    public static ShouldContainSubsequence actualDoesNotHaveEnoughElementsLeftToContainSubsequence(Object actual, Object subsequence, int actualIndex, int subsequenceIndex) {
        return new ShouldContainSubsequence(actual, subsequence, actualIndex, subsequenceIndex);
    }

    private ShouldContainSubsequence(Object actual, Object subsequence, int actualIndex, int subsequenceIndex) {
        super("%nExpecting actual to contain the specified subsequence but actual does not have enough elements left to compare after reaching element %s out of %s with %s subsequence element(s) still to find.%nactual:%n  %s%nsubsequence:%n  %s", actualIndex + 1, ShouldContainSubsequence.sizeOfArrayOrIterable(actual), Arrays.sizeOf(subsequence) - subsequenceIndex, actual, subsequence);
    }

    private static Object sizeOfArrayOrIterable(Object actual) {
        return Arrays.isArray(actual) ? Arrays.sizeOf(actual) : IterableUtil.sizeOf((Iterable)actual);
    }

    public static ShouldContainSubsequence shouldContainSubsequence(Object actual, Object subsequence, int subsequenceIndex, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainSubsequence(actual, subsequence, subsequenceIndex, comparisonStrategy);
    }

    private ShouldContainSubsequence(Object actual, Object subsequence, int subsequenceIndex, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting actual to contain the specified subsequence but failed to find the element at subsequence index %s in actual" + ShouldContainSubsequence.describeComparisonStrategy(comparisonStrategy) + ":%nsubsequence element not found in actual:%n  %s%nactual:%n  %s%nsubsequence:%n  %s", subsequenceIndex, Array.get(subsequence, subsequenceIndex), actual, subsequence);
    }

    private static String describeComparisonStrategy(ComparisonStrategy comparisonStrategy) {
        return comparisonStrategy == StandardComparisonStrategy.instance() ? "" : " when comparing elements using " + comparisonStrategy;
    }
}

