/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

public class HelpDialog
extends JDialog
implements HyperlinkListener {
    JEditorPane html;

    public HelpDialog(JFrame fr) {
        this(fr, null);
    }

    public HelpDialog(JFrame fr, String title, boolean modal) {
        super(fr, title, modal);
    }

    public HelpDialog(JFrame fr, URL url) {
        this(fr, GT.$("Jmol Help"), false);
        this.init(url, "Help.helpURL");
    }

    protected void init(URL url, String resource) {
        try {
            URL myURL = url;
            if (myURL == null) {
                myURL = (resource = JmolResourceHandler.getStringX(resource)).startsWith("http") ? new URL(resource) : this.getClass().getClassLoader().getResource(resource);
            }
            this.html = myURL == null ? new JEditorPane("text/plain", GT.o(GT.$("Unable to find url \"{0}\"."), resource)) : new JEditorPane(myURL);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
        }
        catch (MalformedURLException e) {
            Logger.errorEx("Malformed URL", e);
        }
        catch (IOException e) {
            Logger.errorEx("IOException", e);
        }
        JScrollPane scroller = new JScrollPane();
        scroller.setPreferredSize(new Dimension(500, 400));
        scroller.setAlignmentX(0.0f);
        scroller.getViewport().add(this.html);
        JPanel htmlWrapper = new JPanel(new BorderLayout());
        htmlWrapper.setAlignmentX(0.0f);
        htmlWrapper.add((Component)scroller, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton ok = new JButton(GT.$("OK"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog.this.OKPressed();
            }
        });
        buttonPanel.add(ok);
        this.getRootPane().setDefaultButton(ok);
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)htmlWrapper, "Center");
        container.add((Component)buttonPanel, "South");
        this.getContentPane().add(container);
        this.pack();
        this.centerDialog();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL u) {
        Cursor c = this.html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    public void OKPressed() {
        this.setVisible(false);
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        @Override
        public void run() {
            if (this.url == null) {
                HelpDialog.this.html.setCursor(this.cursor);
                Container parent = HelpDialog.this.html.getParent();
                parent.repaint();
            } else {
                Document doc = HelpDialog.this.html.getDocument();
                try {
                    HelpDialog.this.html.setPage(this.url);
                }
                catch (IOException ioe) {
                    HelpDialog.this.html.setDocument(doc);
                    HelpDialog.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

