// MIT License
//
// Copyright (c) 2022 Advanced Micro Devices, Inc. All Rights Reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#pragma once

// clang-format off
#define ROCPROFILER_REGISTER_VERSION_MAJOR   0
#define ROCPROFILER_REGISTER_VERSION_MINOR   6
#define ROCPROFILER_REGISTER_VERSION_PATCH   0
#define ROCPROFILER_REGISTER_VERSION_STRING "0.6.0"
#define ROCPROFILER_REGISTER_SOVERSION      "0"
#define ROCPROFILER_REGISTER_GIT_DESCRIBE   "v0.6.0"
#define ROCPROFILER_REGISTER_GIT_REVISION   ""

// system info during compilation
#define ROCPROFILER_REGISTER_LIBRARY_ARCH     ""
#define ROCPROFILER_REGISTER_SYSTEM_NAME      "Linux"
#define ROCPROFILER_REGISTER_SYSTEM_PROCESSOR "aarch64"
#define ROCPROFILER_REGISTER_SYSTEM_VERSION   "6.17.7-2-aarch64-ARCH"

// compiler information
#define ROCPROFILER_REGISTER_COMPILER_ID      "GNU"
#define ROCPROFILER_REGISTER_COMPILER_VERSION "15.2.1"
#define ROCPROFILER_REGISTER_COMPILER_STRING  ROCPROFILER_REGISTER_COMPILER_ID " v" ROCPROFILER_REGISTER_COMPILER_VERSION
// clang-format on

#define ROCPROFILER_REGISTER_VERSION                                                     \
    ((10000 * ROCPROFILER_REGISTER_VERSION_MAJOR) +                                      \
     (100 * ROCPROFILER_REGISTER_VERSION_MINOR) + ROCPROFILER_REGISTER_VERSION_PATCH)

#define ROCPROFILER_REGISTER_ATTRIBUTE(...)   __attribute__((__VA_ARGS__))
#define ROCPROFILER_REGISTER_PP_COMBINE(X, Y) X##Y

#if defined(rocprofiler_register_EXPORTS)
// only defined in build tree
#    define ROCPROFILER_REGISTER_VISIBILITY(MODE)                                        \
        ROCPROFILER_REGISTER_ATTRIBUTE(visibility(MODE))
#    define ROCPROFILER_REGISTER_PUBLIC_API   ROCPROFILER_REGISTER_VISIBILITY("default")
#    define ROCPROFILER_REGISTER_HIDDEN_API   ROCPROFILER_REGISTER_VISIBILITY("hidden")
#    define ROCPROFILER_REGISTER_INTERNAL_API ROCPROFILER_REGISTER_VISIBILITY("internal")
#    define ROCPROFILER_REGISTER_INLINE                                                  \
        ROCPROFILER_REGISTER_ATTRIBUTE(always_inline) inline
#    define ROCPROFILER_REGISTER_NOINLINE ROCPROFILER_REGISTER_ATTRIBUTE(noinline)
#    define ROCPROFILER_REGISTER_HOT      ROCPROFILER_REGISTER_ATTRIBUTE(hot)
#    define ROCPROFILER_REGISTER_COLD     ROCPROFILER_REGISTER_ATTRIBUTE(cold)
#    define ROCPROFILER_REGISTER_CONST    ROCPROFILER_REGISTER_ATTRIBUTE(const)
#    define ROCPROFILER_REGISTER_PURE     ROCPROFILER_REGISTER_ATTRIBUTE(pure)
#    define ROCPROFILER_REGISTER_WEAK     ROCPROFILER_REGISTER_ATTRIBUTE(weak)
#    define ROCPROFILER_REGISTER_PACKED   ROCPROFILER_REGISTER_ATTRIBUTE(__packed__)
#    define ROCPROFILER_REGISTER_PACKED_ALIGN(VAL)                                       \
        ROCPROFILER_REGISTER_PACKED ROCPROFILER_REGISTER_ATTRIBUTE(__aligned__(VAL))
#    define ROCPROFILER_REGISTER_LIKELY(...)   __builtin_expect((__VA_ARGS__), 1)
#    define ROCPROFILER_REGISTER_UNLIKELY(...) __builtin_expect((__VA_ARGS__), 0)

#    if defined(ROCPROFILER_REGISTER_CI) && ROCPROFILER_REGISTER_CI > 0
#        if defined(NDEBUG)
#            undef NDEBUG
#        endif
#        if !defined(DEBUG)
#            define DEBUG 1
#        endif
#        if defined(__cplusplus)
#            include <cassert>  // NOLINT
#        else
#            include <assert.h>
#        endif
#    endif

#    define ROCPROFILER_REGISTER_STRINGIZE(X)  ROCPROFILER_REGISTER_STRINGIZE2(X)
#    define ROCPROFILER_REGISTER_STRINGIZE2(X) #    X
#    define ROCPROFILER_REGISTER_LINESTR       ROCPROFILER_REGISTER_STRINGIZE(__LINE__)
#    define ROCPROFILER_REGISTER_ESC(...)      __VA_ARGS__

#    if defined(__cplusplus)
#        if !defined(ROCPROFILER_REGISTER_FOLD_EXPRESSION)
#            define ROCPROFILER_REGISTER_FOLD_EXPRESSION(...) ((__VA_ARGS__), ...)
#        endif
#    endif
#else
#    define ROCPROFILER_REGISTER_VISIBILITY(MODE)
#    define ROCPROFILER_REGISTER_PUBLIC_API
#    define ROCPROFILER_REGISTER_HIDDEN_API
#    define ROCPROFILER_REGISTER_INTERNAL_API
#endif
