/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.AttributeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetBuiltins;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotVarargs;
import com.oracle.graal.python.builtins.objects.types.GenericTypeNodes;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PythonClass})
public final class TypeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TypeBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TypeBuiltinsFactory.getFactories();
    }

    @Builtin(name="__text_signature__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class TextSignatureNode
    extends PythonUnaryBuiltinNode {
        private static final String SIGNATURE_END_MARKER = ")\n--\n\n";
        private static final int SIGNATURE_END_MARKER_LENGTH = 6;

        TextSignatureNode() {
        }

        @Specialization
        static Object signature(PythonBuiltinClass type) {
            return TextSignatureNode.signature(type.getType());
        }

        @Specialization
        static Object signature(PythonBuiltinClassType type) {
            if (type.getDoc() == null) {
                return PNone.NONE;
            }
            return TextSignatureNode.signature(type.getName(), type.getDoc());
        }

        @Fallback
        static Object noDocs(Object type) {
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        static Object signature(TruffleString name, TruffleString internalDoc) {
            String doc;
            String n = name.toJavaStringUncached();
            int start = TextSignatureNode.findSignature(n, doc = internalDoc.toJavaStringUncached());
            if (start < 0) {
                return PNone.NONE;
            }
            int end = -1;
            if (start > 0) {
                end = TextSignatureNode.skipSignature(doc, start);
            }
            if (end <= 0) {
                return PNone.NONE;
            }
            assert ((end -= 5) - start >= 2);
            assert (doc.charAt(end - 1) == ')');
            assert (doc.charAt(end) == '\n');
            return PythonUtils.toTruffleStringUncached(doc.substring(start, end));
        }

        @CompilerDirectives.TruffleBoundary
        static int findSignature(String n, String doc) {
            String name = n;
            int dot = n.indexOf(46);
            if (dot != -1) {
                name = name.substring(dot + 1);
            }
            int length = name.length();
            if (!doc.startsWith(name)) {
                return -1;
            }
            if (doc.charAt(length) != '(') {
                return -1;
            }
            return length;
        }

        @CompilerDirectives.TruffleBoundary
        static int skipSignature(String doc, int start) {
            int end = doc.indexOf(SIGNATURE_END_MARKER, start);
            return end == -1 ? end : end + 6;
        }
    }

    @Builtin(name="__type_params__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class TypeParamsNode
    extends PythonBinaryBuiltinNode {
        TypeParamsNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object get(Object self, Object value, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached ReadAttributeFromObjectNode read, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isBuiltinClassProfile) {
            if (isBuiltinClassProfile.profileClass(inliningTarget, self, PythonBuiltinClassType.PythonClass)) {
                return PFactory.createEmptyTuple(language);
            }
            Object typeParams = read.execute(self, SpecialAttributeNames.T___TYPE_PARAMS__);
            if (typeParams == PNone.NO_VALUE) {
                return PFactory.createEmptyTuple(language);
            }
            return typeParams;
        }

        @Fallback
        static Object set(Object self, Object value, @Bind Node inliningTarget, @Cached WriteAttributeToObjectNode write, @Cached PRaiseNode raiseNode) {
            try {
                write.execute(self, SpecialAttributeNames.T___TYPE_PARAMS__, value);
            }
            catch (PException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, SpecialAttributeNames.T___TYPE_PARAMS__, self);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__annotations__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    static abstract class AnnotationsNode
    extends PythonBinaryBuiltinNode {
        AnnotationsNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object get(Object self, Object value, @Bind Node inliningTarget, @Cached InlinedBranchProfile createDict, @Cached.Shared(value="read") @Cached ReadAttributeFromObjectNode read, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object annotations = read.execute(self, SpecialAttributeNames.T___ANNOTATIONS__);
            if (annotations == PNone.NO_VALUE) {
                createDict.enter(inliningTarget);
                annotations = PFactory.createDict(PythonLanguage.get(inliningTarget));
                try {
                    write.execute(self, SpecialAttributeNames.T___ANNOTATIONS__, annotations);
                }
                catch (PException e) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, self, SpecialAttributeNames.T___ANNOTATIONS__);
                }
            }
            return annotations;
        }

        @Specialization(guards={"isDeleteMarker(value)"})
        static Object delete(Object self, Object value, @Bind Node inliningTarget, @Cached.Shared(value="read") @Cached ReadAttributeFromObjectNode read, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write, @Cached.Shared @Cached PRaiseNode raiseNode) {
            Object annotations = read.execute(self, SpecialAttributeNames.T___ANNOTATIONS__);
            try {
                write.execute(self, SpecialAttributeNames.T___ANNOTATIONS__, PNone.NO_VALUE);
            }
            catch (PException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, SpecialAttributeNames.T___ANNOTATIONS__, self);
            }
            if (annotations == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, new Object[]{SpecialAttributeNames.T___ANNOTATIONS__});
            }
            return PNone.NONE;
        }

        @Fallback
        static Object set(Object self, Object value, @Bind Node inliningTarget, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                write.execute(self, SpecialAttributeNames.T___ANNOTATIONS__, value);
            }
            catch (PException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, SpecialAttributeNames.T___ANNOTATIONS__, self);
            }
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        Object union(Object self, Object other, @Cached GenericTypeNodes.UnionTypeOrNode orNode) {
            return orNode.execute(self, other);
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1, doc="__dir__ for type objects\n\n\tThis includes all attributes of klass and all of the base\n\tclasses recursively.")
    @GenerateNodeFactory
    public static abstract class DirNode
    extends PythonUnaryBuiltinNode {
        @Override
        public abstract PList execute(VirtualFrame var1, Object var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PList dir(VirtualFrame frame, Object klass, @Bind Node inliningTarget, @Cached ListNodes.ConstructListNode constructListNode, @Cached(value="createFor($node)") IndirectCallData indirectCallData) {
            PSet names = PFactory.createSet(PythonLanguage.get(inliningTarget));
            Object state = ExecutionContext.IndirectCallContext.enter(frame, inliningTarget, indirectCallData);
            try {
                DirNode.dir(names, klass);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, inliningTarget, indirectCallData, state);
            }
            return constructListNode.execute((Frame)frame, names);
        }

        @CompilerDirectives.TruffleBoundary
        public static void dir(PSet names, Object klass) {
            Object basesAttr;
            Object ns = PyObjectLookupAttr.executeUncached(klass, SpecialAttributeNames.T___DICT__);
            SetBuiltins.UpdateSingleNode updateSingleNode = SetBuiltins.UpdateSingleNode.getUncached();
            if (ns != PNone.NO_VALUE) {
                updateSingleNode.execute(null, names, ns);
            }
            if ((basesAttr = PyObjectLookupAttr.executeUncached(klass, SpecialAttributeNames.T___BASES__)) instanceof PTuple) {
                Object[] bases;
                for (Object cls : bases = SequenceStorageNodes.ToArrayNode.executeUncached(((PTuple)basesAttr).getSequenceStorage())) {
                    DirNode.dir(names, cls);
                }
            }
        }

        @NeverDefault
        protected GetAttributeNode.GetFixedAttributeNode createGetAttrNode() {
            return GetAttributeNode.GetFixedAttributeNode.create(SpecialAttributeNames.T___BASES__);
        }

        @NeverDefault
        public static DirNode create() {
            return TypeBuiltinsFactory.DirNodeFactory.create();
        }
    }

    @Builtin(name="__abstractmethods__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    static abstract class AbstractMethodsNode
    extends PythonBinaryBuiltinNode {
        AbstractMethodsNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object get(Object self, PNone none, @Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object result;
            if (!isSameTypeNode.execute(inliningTarget, self, (Object)PythonBuiltinClassType.PythonClass) && (result = readAttributeFromObjectNode.execute(self, SpecialAttributeNames.T___ABSTRACTMETHODS__)) != PNone.NO_VALUE) {
                return result;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.OBJ_N_HAS_NO_ATTR_S, self, SpecialAttributeNames.T___ABSTRACTMETHODS__);
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)"})
        static Object set(VirtualFrame frame, PythonClass self, Object value, @Bind Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached WriteAttributeToObjectNode writeAttributeToObjectNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (!isSameTypeNode.execute(inliningTarget, self, (Object)PythonBuiltinClassType.PythonClass)) {
                writeAttributeToObjectNode.execute(self, SpecialAttributeNames.T___ABSTRACTMETHODS__, value);
                self.setAbstractClass(isTrueNode.execute((Frame)frame, value));
                return PNone.NONE;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, "__abstractmethods__", self);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object delete(PythonClass self, DescriptorDeleteMarker value, @Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached.Exclusive @Cached WriteAttributeToObjectNode writeAttributeToObjectNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (!isSameTypeNode.execute(inliningTarget, self, (Object)PythonBuiltinClassType.PythonClass) && readAttributeFromObjectNode.execute(self, SpecialAttributeNames.T___ABSTRACTMETHODS__) != PNone.NO_VALUE) {
                writeAttributeToObjectNode.execute(self, SpecialAttributeNames.T___ABSTRACTMETHODS__, PNone.NO_VALUE);
                self.setAbstractClass(false);
                return PNone.NONE;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, "__abstractmethods__", self);
        }

        @Fallback
        static Object set(Object self, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, "__abstractmethods__", self);
        }
    }

    @Builtin(name="__flags__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class FlagsNode
    extends PythonUnaryBuiltinNode {
        FlagsNode() {
        }

        @Specialization
        static Object doGeneric(Object self, @Bind Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached TypeNodes.GetTypeFlagsNode getTypeFlagsNode, @Cached PRaiseNode raiseNode) {
            if (PGuards.isClass(inliningTarget, self, isTypeNode)) {
                return getTypeFlagsNode.execute(self);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESC_FLAG_FOR_TYPE_DOESNT_APPLY_TO_OBJ, self);
        }
    }

    @Builtin(name="__weakrefoffset__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class WeakrefOffsetNode
    extends PythonUnaryBuiltinNode {
        WeakrefOffsetNode() {
        }

        @Specialization
        Object get(Object cls, @Bind Node inliningTarget, @Cached TypeNodes.GetWeakListOffsetNode getWeakListOffsetNode) {
            return getWeakListOffsetNode.execute(inliningTarget, cls);
        }
    }

    @Builtin(name="__basicsize__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class BasicsizeNode
    extends PythonUnaryBuiltinNode {
        BasicsizeNode() {
        }

        @Specialization
        Object getBasicsizeType(Object cls, @Bind Node inliningTarget, @Cached TypeNodes.GetBasicSizeNode getBasicSizeNode) {
            return getBasicSizeNode.execute(inliningTarget, cls);
        }
    }

    @Builtin(name="__itemsize__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ItemsizeNode
    extends PythonUnaryBuiltinNode {
        ItemsizeNode() {
        }

        @Specialization
        static long getItemsizeType(Object cls, @Bind Node inliningTarget, @Cached TypeNodes.GetItemSizeNode getItemsizeNode) {
            return getItemsizeNode.execute(inliningTarget, cls);
        }
    }

    @Builtin(name="__dictoffset__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DictoffsetNode
    extends PythonUnaryBuiltinNode {
        DictoffsetNode() {
        }

        @Specialization
        Object getDictoffsetType(Object cls, @Bind Node inliningTarget, @Cached TypeNodes.GetDictOffsetNode getDictOffsetNode) {
            return getDictOffsetNode.execute(inliningTarget, cls);
        }
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    static abstract class QualNameNode
    extends AbstractSlotNode {
        QualNameNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getName(PythonBuiltinClassType cls, PNone value) {
            return cls.getName();
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getName(PythonManagedClass cls, PNone value) {
            return cls.getQualName();
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object getNative(PythonAbstractNativeObject cls, PNone value, @Bind Node inliningTarget, @Cached TypeNodes.GetTypeFlagsNode getTypeFlagsNode, @Cached CStructAccess.ReadObjectNode getHtName, @Cached TypeNodes.GetNameNode getNameNode) {
            if ((getTypeFlagsNode.execute(cls) & 0x200L) != 0L) {
                return getHtName.readFromObj(cls, CFields.PyHeapTypeObject__ht_qualname);
            }
            return getNameNode.execute(inliningTarget, cls);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setName(Object cls, Object value, @Bind Node inliningTarget, @Cached CheckSetSpecialTypeAttrNode check, @Cached CastToTruffleStringNode castToStringNode, @Cached SetQualNameInnerNode innerNode, @Cached PRaiseNode raiseNode) {
            TruffleString stringValue;
            check.execute(inliningTarget, cls, value, SpecialAttributeNames.T___QUALNAME__);
            try {
                stringValue = castToStringNode.execute(inliningTarget, value);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_ASSIGN_STR_TO_QUALNAME, cls, value);
            }
            innerNode.execute(inliningTarget, cls, stringValue);
            return PNone.NONE;
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class SetQualNameInnerNode
        extends Node {
            SetQualNameInnerNode() {
            }

            abstract void execute(Node var1, Object var2, TruffleString var3);

            @Specialization
            static void set(PythonClass type, TruffleString value) {
                type.setQualName(value);
            }

            @Specialization
            static void set(PythonAbstractNativeObject type, TruffleString value, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode writeObject) {
                writeObject.writeToObject(type, CFields.PyHeapTypeObject__ht_qualname, value);
            }
        }
    }

    @Builtin(name="__module__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    static abstract class ModuleNode
    extends AbstractSlotNode {
        ModuleNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getModuleType(PythonBuiltinClassType cls, PNone value) {
            TruffleString module = cls.getModuleName();
            return module == null ? BuiltinNames.T_BUILTINS : module;
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getModuleBuiltin(PythonBuiltinClass cls, PNone value) {
            return ModuleNode.getModuleType(cls.getType(), value);
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object getModule(PythonClass cls, PNone value, @Bind Node inliningTarget, @Cached ReadAttributeFromObjectNode readAttrNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            Object module = readAttrNode.execute(cls, SpecialAttributeNames.T___MODULE__);
            if (module == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError);
            }
            return module;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setModule(PythonClass cls, Object value, @Cached WriteAttributeToObjectNode writeAttrNode) {
            writeAttrNode.execute(cls, SpecialAttributeNames.T___MODULE__, value);
            return PNone.NONE;
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object getModule(PythonAbstractNativeObject cls, PNone value, @Bind Node inliningTarget, @Cached(value="createForceType()") ReadAttributeFromObjectNode readAttr, @Cached.Shared @Cached TypeNodes.GetTypeFlagsNode getFlags, @Cached CStructAccess.ReadCharPtrNode getTpNameNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.SubstringNode substringNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int len;
            if ((getFlags.execute(cls) & 0x200L) != 0L) {
                Object module = readAttr.execute(cls, SpecialAttributeNames.T___MODULE__);
                if (module == PNone.NO_VALUE) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError);
                }
                return module;
            }
            TruffleString tpName = getTpNameNode.readFromObj(cls, CFields.PyTypeObject__tp_name);
            int firstDot = indexOfCodePointNode.execute((AbstractTruffleString)tpName, 46, 0, len = codePointLengthNode.execute((AbstractTruffleString)tpName, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING);
            if (firstDot < 0) {
                return BuiltinNames.T_BUILTINS;
            }
            return substringNode.execute((AbstractTruffleString)tpName, 0, firstDot, PythonUtils.TS_ENCODING, true);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setNative(PythonAbstractNativeObject cls, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached TypeNodes.GetTypeFlagsNode getFlags, @Cached(value="createForceType()") WriteAttributeToObjectNode writeAttr, @Cached.Shared @Cached PRaiseNode raiseNode) {
            long flags = getFlags.execute(cls);
            if ((flags & 0x200L) == 0L) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_N_S, cls, SpecialAttributeNames.T___MODULE__);
            }
            writeAttr.execute(cls, SpecialAttributeNames.T___MODULE__, value);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setModuleType(PythonBuiltinClassType cls, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTES_OF_TYPE, "built-in/extension 'type'");
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setModuleBuiltin(PythonBuiltinClass cls, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTES_OF_TYPE, "built-in/extension 'type'");
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    static abstract class NameNode
    extends AbstractSlotNode {
        NameNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getNameType(Object cls, PNone value, @Bind Node inliningTarget, @Cached TypeNodes.GetNameNode getNameNode) {
            return getNameNode.execute(inliningTarget, cls);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setName(VirtualFrame frame, Object cls, Object value, @Bind Node inliningTarget, @Cached CheckSetSpecialTypeAttrNode check, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached TruffleString.IsValidNode isValidNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached SetNameInnerNode innerNode, @Cached PRaiseNode raiseNode) {
            TruffleString string;
            check.execute(inliningTarget, cls, value, SpecialAttributeNames.T___NAME__);
            try {
                string = castToTruffleStringNode.execute(inliningTarget, value);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_ASSIGN_S_TO_P_S_NOT_P, "string", cls, SpecialAttributeNames.T___NAME__, value);
            }
            if (indexOfCodePointNode.execute((AbstractTruffleString)string, 0, 0, codePointLengthNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.TYPE_NAME_NO_NULL_CHARS);
            }
            if (!isValidNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING)) {
                throw constructAndRaiseNode.get(inliningTarget).raiseUnicodeEncodeError((Frame)frame, "utf-8", string, 0, string.codePointLengthUncached(PythonUtils.TS_ENCODING), "can't encode classname");
            }
            innerNode.execute(inliningTarget, cls, string);
            return PNone.NONE;
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class SetNameInnerNode
        extends Node {
            SetNameInnerNode() {
            }

            abstract void execute(Node var1, Object var2, TruffleString var3);

            @Specialization
            static void set(PythonClass type, TruffleString value) {
                type.setName(value);
            }

            @Specialization
            static void set(PythonAbstractNativeObject type, TruffleString value, @Bind PythonLanguage language, @Cached(inline=false) CStructAccess.WritePointerNode writePointerNode, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode writeObject, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode, @Cached(inline=false) TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
                value = switchEncodingNode.execute((AbstractTruffleString)value, TruffleString.Encoding.UTF_8);
                byte[] bytes = copyToByteArrayNode.execute((AbstractTruffleString)value, TruffleString.Encoding.UTF_8);
                PBytes bytesObject = PFactory.createBytes(language, bytes);
                writePointerNode.writeToObj(type, CFields.PyTypeObject__tp_name, PySequenceArrayWrapper.ensureNativeSequence(bytesObject));
                PString pString = PFactory.createString(language, value);
                pString.setUtf8Bytes(bytesObject);
                writeObject.writeToObject(type, CFields.PyHeapTypeObject__ht_name, pString);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CheckSetSpecialTypeAttrNode
    extends Node {
        CheckSetSpecialTypeAttrNode() {
        }

        abstract void execute(Node var1, Object var2, Object var3, TruffleString var4);

        @Specialization
        static void check(Node inliningTarget, Object type, Object value, TruffleString name, @Cached PRaiseNode raiseNode, @Cached(inline=false) TypeNodes.GetTypeFlagsNode getTypeFlagsNode, @Cached SysModuleBuiltins.AuditNode auditNode) {
            if (PGuards.isKindOfBuiltinClass(type) || (getTypeFlagsNode.execute(type) & 0x100L) != 0L) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, name, type);
            }
            if (value == DescriptorDeleteMarker.INSTANCE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_DELETE_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, name, type);
            }
            auditNode.audit(inliningTarget, "object.__setattr__", type, name, value);
        }
    }

    @GenerateNodeFactory
    static abstract class AbstractSlotNode
    extends PythonBinaryBuiltinNode {
        AbstractSlotNode() {
        }
    }

    @Builtin(name="__subclasses__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SubclassesNode
    extends PythonUnaryBuiltinNode {
        SubclassesNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static PList getSubclasses(Object cls, @Bind Node inliningTarget) {
            PythonAbstractClass[] array = TypeNodes.GetSubclassesAsArrayNode.executeUncached(cls);
            Object[] classes = new Object[array.length];
            PythonUtils.arraycopy(array, 0, classes, 0, array.length);
            return PFactory.createList(PythonLanguage.get(inliningTarget), classes);
        }
    }

    @Builtin(name="__subclasshook__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    static abstract class SubclassHookNode
    extends PythonBinaryBuiltinNode {
        SubclassHookNode() {
        }

        @Specialization
        Object hook(VirtualFrame frame, Object cls, Object subclass) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__subclasscheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SubclassCheckNode
    extends PythonBinaryBuiltinNode {
        SubclassCheckNode() {
        }

        @Specialization
        static boolean check(VirtualFrame frame, Object cls, Object derived, @Bind Node inliningTarget, @Cached TypeNodes.GenericSubclassCheckNode genericSubclassCheckNode) {
            return genericSubclassCheckNode.execute(frame, inliningTarget, derived, cls);
        }
    }

    @Builtin(name="__instancecheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InstanceCheckNode
    extends PythonBinaryBuiltinNode {
        InstanceCheckNode() {
        }

        @Specialization
        static boolean isInstance(VirtualFrame frame, Object cls, Object instance, @Bind Node inliningTarget, @Cached TypeNodes.GenericInstanceCheckNode genericInstanceCheckNode) {
            return genericInstanceCheckNode.execute(frame, inliningTarget, instance, cls);
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DictNode
    extends PythonUnaryBuiltinNode {
        DictNode() {
        }

        @Specialization
        Object doType(PythonBuiltinClassType self, @Bind PythonLanguage language, @Cached.Shared @Cached GetDictIfExistsNode getDict) {
            return DictNode.doManaged(this.getContext().lookupType(self), language, getDict);
        }

        @Specialization
        static Object doManaged(PythonManagedClass self, @Bind PythonLanguage language, @Cached.Shared @Cached GetDictIfExistsNode getDict) {
            PDict dict = getDict.execute(self);
            if (dict == null) {
                dict = PFactory.createDictFixedStorage(language, self, self.getMethodResolutionOrder());
            }
            return PFactory.createMappingproxy(language, dict);
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject self, @Cached CStructAccess.ReadObjectNode getTpDictNode) {
            return getTpDictNode.readFromObj(self, CFields.PyTypeObject__tp_dict);
        }
    }

    @Builtin(name="__base__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class BaseNode
    extends PythonBuiltinNode {
        BaseNode() {
        }

        @Specialization
        static Object base(Object self, @Bind Node inliningTarget, @Cached TypeNodes.GetBaseClassNode getBaseClassNode) {
            Object baseClass = getBaseClassNode.execute(inliningTarget, self);
            return baseClass != null ? baseClass : PNone.NONE;
        }
    }

    @Builtin(name="__bases__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    static abstract class BasesNode
    extends PythonBinaryBuiltinNode {
        BasesNode() {
        }

        @Specialization
        static Object getBases(Object self, PNone value, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached TypeNodes.GetBaseClassesNode getBaseClassesNode) {
            return PFactory.createTuple(language, getBaseClassesNode.execute(inliningTarget, self));
        }

        @Specialization
        static Object setBases(VirtualFrame frame, PythonClass cls, PTuple value, @Bind Node inliningTarget, @Cached SequenceNodes.GetObjectArrayNode getArray, @Cached TypeNodes.GetBaseClassNode getBase, @Cached TypeNodes.GetBestBaseClassNode getBestBase, @Cached TypeNodes.CheckCompatibleForAssigmentNode checkCompatibleForAssigment, @Cached IsSubtypeNode isSubtypeNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached TypeNodes.GetMroNode getMroNode, @Cached PRaiseNode raiseNode) {
            Object[] a = getArray.execute(inliningTarget, value);
            if (a.length == 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_ASSIGN_NON_EMPTY_TUPLE_TO_P, cls);
            }
            PythonAbstractClass[] baseClasses = new PythonAbstractClass[a.length];
            for (int i = 0; i < a.length; ++i) {
                if (PGuards.isPythonClass(a[i])) {
                    if (isSubtypeNode.execute(a[i], cls) || BasesNode.hasMRO(inliningTarget, getMroNode, a[i]) && BasesNode.typeIsSubtypeBaseChain(inliningTarget, a[i], cls, getBase, isSameTypeNode)) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BASES_ITEM_CAUSES_INHERITANCE_CYCLE);
                    }
                    if (a[i] instanceof PythonBuiltinClassType) {
                        baseClasses[i] = PythonContext.get(inliningTarget).lookupType((PythonBuiltinClassType)((Object)a[i]));
                        continue;
                    }
                    baseClasses[i] = (PythonAbstractClass)a[i];
                    continue;
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MUST_BE_TUPLE_OF_CLASSES_NOT_P, cls, "__bases__", a[i]);
            }
            PythonAbstractClass newBestBase = getBestBase.execute(inliningTarget, baseClasses);
            if (newBestBase == null) {
                return null;
            }
            Object oldBase = getBase.execute(inliningTarget, cls);
            checkCompatibleForAssigment.execute(frame, oldBase, newBestBase);
            cls.setBases(inliningTarget, newBestBase, baseClasses);
            TpSlots.updateAllSlots(cls);
            return PNone.NONE;
        }

        private static boolean hasMRO(Node inliningTarget, TypeNodes.GetMroNode getMroNode, Object i) {
            PythonAbstractClass[] mro = getMroNode.execute(inliningTarget, i);
            return mro != null && mro.length > 0;
        }

        private static boolean typeIsSubtypeBaseChain(Node inliningTarget, Object a, Object b, TypeNodes.GetBaseClassNode getBaseNode, TypeNodes.IsSameTypeNode isSameTypeNode) {
            Object base = a;
            do {
                if (!isSameTypeNode.execute(inliningTarget, base, b)) continue;
                return true;
            } while ((base = getBaseNode.execute(inliningTarget, base)) != null);
            return isSameTypeNode.execute(inliningTarget, b, (Object)PythonBuiltinClassType.PythonObject);
        }

        @Specialization(guards={"!isPTuple(value)"})
        static Object setObject(PythonClass cls, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_ASSIGN_S_TO_S_S_NOT_P, "tuple", TypeNodes.GetNameNode.executeUncached(cls), "__bases__", value);
        }

        @Specialization
        static Object setBuiltin(PythonBuiltinClass cls, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, "__bases__", cls);
        }
    }

    @Builtin(name="__prepare__", takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class PrepareNode
    extends PythonBuiltinNode {
        @Specialization
        Object doIt(Object args, Object kwargs, @Bind PythonLanguage language) {
            return PFactory.createDict(language, new DynamicObjectStorage(language));
        }
    }

    @Slot(value=Slot.SlotKind.tp_setattro, isComplex=true)
    @GenerateNodeFactory
    public static abstract class SetattrNode
    extends TpSlotSetAttr.SetAttrBuiltinNode {
        @Specialization(guards={"!isImmutable(object)"})
        void setString(VirtualFrame frame, Object object, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached ObjectNodes.GenericSetAttrNode genericSetAttrNode, @Cached.Shared @Cached(value="createForceType()") WriteAttributeToObjectNode write) {
            genericSetAttrNode.execute(inliningTarget, frame, object, key, value, write);
        }

        @Specialization(guards={"!isImmutable(object)"})
        @HostCompilerDirectives.InliningCutoff
        static void set(VirtualFrame frame, Object object, Object key, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached ObjectNodes.GenericSetAttrNode genericSetAttrNode, @Cached.Shared @Cached(value="createForceType()") WriteAttributeToObjectNode write) {
            genericSetAttrNode.execute(inliningTarget, frame, object, key, value, write);
        }

        @Specialization(guards={"isImmutable(object)"})
        @CompilerDirectives.TruffleBoundary
        void setBuiltin(Object object, Object key, Object value) {
            if (PythonContext.get(this).isInitialized()) {
                throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_R_OF_IMMUTABLE_TYPE_N, PyObjectReprAsTruffleStringNode.executeUncached(key), object);
            }
            SetattrNode.set(null, object, key, value, null, ObjectNodes.GenericSetAttrNode.getUncached(), WriteAttributeToObjectNode.getUncached(true));
        }

        protected static boolean isImmutable(Object type) {
            return type instanceof PythonBuiltinClass || type instanceof PythonBuiltinClassType;
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class GetattributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        @Node.Child
        private TpSlotDescrGet.CallSlotDescrGet callSlotDescrGet;
        @Node.Child
        private TpSlotDescrGet.CallSlotDescrGet callSlotValueGet;
        @Node.Child
        private LookupAttributeInMRONode.Dynamic lookupAsClass;

        @Specialization
        protected Object doIt(VirtualFrame frame, Object object, Object keyObj, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached TpSlots.GetObjectSlotsNode getDescrSlotsNode, @Cached TpSlots.GetObjectSlotsNode getValueSlotsNode, @Cached LookupAttributeInMRONode.Dynamic lookup, @Cached CastToTruffleStringNode castToString, @Cached InlinedBranchProfile hasDescProfile, @Cached InlinedConditionProfile hasDescrGetProfile, @Cached InlinedBranchProfile hasValueProfile, @Cached InlinedBranchProfile hasNonDescriptorValueProfile, @Cached InlinedBranchProfile errorProfile, @Cached PRaiseNode raiseNode) {
            TpSlots descrSlots;
            TruffleString key;
            try {
                key = castToString.execute(inliningTarget, keyObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObj);
            }
            Object metatype = getClassNode.execute(inliningTarget, object);
            Object descr = lookup.execute(metatype, key);
            TpSlot get = null;
            boolean hasDescrGet = false;
            if (descr != PNone.NO_VALUE && (hasDescrGet = hasDescrGetProfile.profile(inliningTarget, (get = (descrSlots = getDescrSlotsNode.execute(inliningTarget, descr)).tp_descr_get()) != null)) && TpSlotDescrSet.PyDescr_IsData(descrSlots)) {
                return this.dispatchDescrGet(frame, object, metatype, descr, get);
            }
            Object value = this.readAttribute(object, key);
            if (value != PNone.NO_VALUE) {
                hasValueProfile.enter(inliningTarget);
                TpSlots valueSlots = getValueSlotsNode.execute(inliningTarget, value);
                TpSlot valueGet = valueSlots.tp_descr_get();
                if (valueGet == null) {
                    hasNonDescriptorValueProfile.enter(inliningTarget);
                    return value;
                }
                return this.dispatchValueGet(frame, object, value, valueGet);
            }
            if (descr != PNone.NO_VALUE) {
                hasDescProfile.enter(inliningTarget);
                if (!hasDescrGet) {
                    return descr;
                }
                return this.dispatchDescrGet(frame, object, metatype, descr, get);
            }
            errorProfile.enter(inliningTarget);
            throw raiseNode.raiseWithData(inliningTarget, PythonErrorType.AttributeError, AttributeErrorBuiltins.dataForObjKey(object, key), ErrorMessages.OBJ_N_HAS_NO_ATTR_S, new Object[]{object, key});
        }

        private Object readAttribute(Object object, TruffleString key) {
            if (this.lookupAsClass == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupAsClass = (LookupAttributeInMRONode.Dynamic)this.insert(LookupAttributeInMRONode.Dynamic.create());
            }
            return this.lookupAsClass.execute(object, key);
        }

        private Object dispatchDescrGet(VirtualFrame frame, Object object, Object type, Object descr, TpSlot getSlot) {
            if (this.callSlotDescrGet == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callSlotDescrGet = (TpSlotDescrGet.CallSlotDescrGet)this.insert(TpSlotDescrGet.CallSlotDescrGet.create());
            }
            return this.callSlotDescrGet.executeCached(frame, getSlot, descr, object, type);
        }

        private Object dispatchValueGet(VirtualFrame frame, Object type, Object descr, TpSlot getSlot) {
            if (this.callSlotValueGet == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callSlotValueGet = (TpSlotDescrGet.CallSlotDescrGet)this.insert(TpSlotDescrGet.CallSlotDescrGet.create());
            }
            return this.callSlotValueGet.executeCached(frame, getSlot, descr, PNone.NO_VALUE, type);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class CreateInstanceNode
    extends PNodeWithContext {
        protected CreateInstanceNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object[] var4, PKeyword[] var5);

        @Specialization
        static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object type, Object[] arguments, PKeyword[] keywords, @Cached InlinedConditionProfile builtinProfile, @Cached TpSlots.GetCachedTpSlotsNode getTypeSlots, @Cached TpSlots.GetCachedTpSlotsNode getInstanceSlots, @Cached GetClassNode getInstanceClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached TpSlotVarargs.CallSlotTpNewNode callNew, @Cached TpSlotVarargs.CallSlotTpInitNode callInit, @Cached PRaiseNode raiseNode) {
            TpSlots instanceSlots;
            TpSlots typeSlots;
            if (builtinProfile.profile(inliningTarget, type instanceof PythonBuiltinClass)) {
                type = ((PythonBuiltinClass)type).getType();
            }
            if ((typeSlots = getTypeSlots.execute(inliningTarget, type)).tp_new() == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_N_INSTANCES, type);
            }
            Object newInstance = callNew.execute(frame, inliningTarget, typeSlots.tp_new(), type, arguments, keywords);
            Object newInstanceKlass = getInstanceClassNode.execute(inliningTarget, newInstance);
            if (isSubtypeNode.execute(newInstanceKlass, type) && (instanceSlots = getInstanceSlots.execute(inliningTarget, newInstanceKlass)).tp_init() != null) {
                callInit.execute(frame, inliningTarget, instanceSlots.tp_init(), newInstance, arguments, keywords);
            }
            return newInstance;
        }
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CallNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        Object call(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached GetClassNode getClassNode, @Cached PRaiseNode raiseNode, @Cached CreateInstanceNode createInstanceNode) {
            if (isSameTypeNode.execute(inliningTarget, (Object)PythonBuiltinClassType.PythonClass, self)) {
                if (arguments.length == 1 && keywords.length == 0) {
                    return getClassNode.execute(inliningTarget, arguments[0]);
                }
                if (arguments.length != 3) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TAKES_D_OR_D_ARGS, "type()", 1, 3);
                }
            }
            return createInstanceNode.execute(frame, inliningTarget, self, arguments, keywords);
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(takesVarArgs=true, minNumOfPositionalArgs=1, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        static Object init(Object self, Object[] arguments, PKeyword[] kwds, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            if (arguments.length != 1 && arguments.length != 3) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TAKES_D_OR_D_ARGS, "type.__init__()", 1, 3);
            }
            if (arguments.length == 1 && kwds.length != 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "type.__init__()");
            }
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, needsFrame=true)
    @GenerateNodeFactory
    public static abstract class TypeNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private IsSubtypeNode isSubtypeNode;
        @Node.Child
        private TypeNodes.IsAcceptableBaseNode isAcceptableBaseNode;
        private final BranchProfile errorProfile = BranchProfile.create();

        public abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5, PKeyword[] var6);

        @Override
        public final Object execute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) {
            if (arguments.length == 3) {
                return this.execute(frame, self, arguments[0], arguments[1], arguments[2], keywords);
            }
            this.errorProfile.enter();
            throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.TAKES_EXACTLY_D_ARGUMENTS_D_GIVEN, "type.__new__", 3, arguments.length);
        }

        @Specialization(guards={"isString(wName)"})
        Object typeNew(VirtualFrame frame, Object cls, Object wName, PTuple bases, PDict namespaceOrig, PKeyword[] kwds, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotVarargs.CallSlotTpNewNode callNew, @Cached @Cached.Exclusive TypeNodes.IsTypeNode isTypeNode, @Cached PyObjectLookupAttr lookupMroEntriesNode, @Cached CastToTruffleStringNode castStr, @Cached TypeNodes.CreateTypeNode createType, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            TruffleString name = castStr.execute(inliningTarget, wName);
            Object metaclass = cls;
            Object winner = this.calculateMetaclass(frame, inliningTarget, metaclass, bases, getClassNode, isTypeNode, lookupMroEntriesNode, getObjectArrayNode);
            if (winner != metaclass) {
                TpSlot winnerNew = getSlots.execute(inliningTarget, winner).tp_new();
                if (winnerNew != SLOTS.tp_new()) {
                    return callNew.execute(frame, inliningTarget, winnerNew, winner, new Object[]{name, bases, namespaceOrig}, kwds);
                }
                metaclass = winner;
            }
            return createType.execute(frame, namespaceOrig, name, bases, metaclass, kwds);
        }

        @Fallback
        Object generic(Object cls, Object name, Object bases, Object namespace, PKeyword[] kwds) {
            if (!(bases instanceof PTuple)) {
                throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, "type.__new__()", 2, "tuple", bases);
            }
            if (!(namespace instanceof PDict)) {
                throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, "type.__new__()", 3, "dict", bases);
            }
            throw CompilerDirectives.shouldNotReachHere((String)"type fallback reached incorrectly");
        }

        private Object calculateMetaclass(VirtualFrame frame, Node inliningTarget, Object cls, PTuple bases, GetClassNode getClassNode, TypeNodes.IsTypeNode isTypeNode, PyObjectLookupAttr lookupMroEntries, SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            Object winner = cls;
            for (Object base : getObjectArrayNode.execute(inliningTarget, bases)) {
                if (!isTypeNode.execute(inliningTarget, base) && lookupMroEntries.execute((Frame)frame, inliningTarget, base, SpecialMethodNames.T___MRO_ENTRIES__) != PNone.NO_VALUE) {
                    throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_SUPPORT_MRO_ENTRY_RESOLUTION);
                }
                if (!this.ensureIsAcceptableBaseNode().execute(base)) {
                    throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TYPE_IS_NOT_ACCEPTABLE_BASE_TYPE, base);
                }
                Object typ = getClassNode.execute(inliningTarget, base);
                if (this.isSubType(winner, typ)) continue;
                if (this.isSubType(typ, winner)) {
                    winner = typ;
                    continue;
                }
                throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.METACLASS_CONFLICT);
            }
            return winner;
        }

        protected boolean isSubType(Object subclass, Object superclass) {
            if (this.isSubtypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isSubtypeNode = (IsSubtypeNode)this.insert(IsSubtypeNode.create());
            }
            return this.isSubtypeNode.execute(subclass, superclass);
        }

        @NeverDefault
        public static TypeNode create() {
            return TypeBuiltinsFactory.TypeNodeFactory.create();
        }

        @Specialization(guards={"!isNoValue(bases)", "!isNoValue(dict)"})
        Object typeGeneric(VirtualFrame frame, Object cls, Object name, Object bases, Object dict, PKeyword[] kwds, @Bind Node inliningTarget, @Cached TypeNode nextTypeNode, @Cached PRaiseNode raiseNode, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode) {
            if (!(name instanceof TruffleString) && !(name instanceof PString)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MUST_BE_STRINGS_NOT_P, "type() argument 1", name);
            }
            if (!(bases instanceof PTuple)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MUST_BE_STRINGS_NOT_P, "type() argument 2", bases);
            }
            if (!(dict instanceof PDict)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MUST_BE_STRINGS_NOT_P, "type() argument 3", dict);
            }
            if (!isTypeNode.execute(inliningTarget, cls)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.NotImplementedError, ErrorMessages.CREATING_CLASS_NON_CLS_META_CLS);
            }
            return nextTypeNode.execute(frame, cls, name, bases, dict, kwds);
        }

        private TypeNodes.IsAcceptableBaseNode ensureIsAcceptableBaseNode() {
            if (this.isAcceptableBaseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isAcceptableBaseNode = (TypeNodes.IsAcceptableBaseNode)this.insert(TypeNodes.IsAcceptableBaseNode.create());
            }
            return this.isAcceptableBaseNode;
        }
    }

    @Builtin(name="mro", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class MroNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isTypeNode.execute(inliningTarget, klass)"}, limit="1")
        static Object doit(Object klass, @Bind Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached TypeNodes.GetMroNode getMroNode) {
            PythonAbstractClass[] mro = getMroNode.execute(inliningTarget, klass);
            return PFactory.createList(PythonLanguage.get(inliningTarget), Arrays.copyOf(mro, mro.length, Object[].class));
        }

        @Fallback
        static Object doit(Object object, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T_MRO, "type", object);
        }
    }

    @Builtin(name="__mro__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class MroAttrNode
    extends PythonUnaryBuiltinNode {
        MroAttrNode() {
        }

        @Specialization
        static Object doit(Object klass, @Bind Node inliningTarget, @Cached TypeNodes.GetMroNode getMroNode, @Cached InlinedConditionProfile notInitialized) {
            if (notInitialized.profile(inliningTarget, klass instanceof PythonManagedClass && !((PythonManagedClass)klass).isMROInitialized())) {
                return PNone.NONE;
            }
            Object[] mro = getMroNode.execute(inliningTarget, klass);
            return PFactory.createTuple(PythonLanguage.get(inliningTarget), mro);
        }
    }

    @Builtin(name="__doc__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    public static abstract class DocNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(value)"})
        static Object getDoc(PythonBuiltinClassType self, PNone value) {
            return self.getDoc() != null ? self.getDoc() : PNone.NONE;
        }

        @Specialization(guards={"isNoValue(value)"})
        @CompilerDirectives.TruffleBoundary
        static Object getDoc(PythonBuiltinClass self, PNone value) {
            return DocNode.getDoc(self.getType(), value);
        }

        @Specialization(guards={"isNoValue(value)", "!isPythonBuiltinClass(self)"})
        static Object getDoc(VirtualFrame frame, PythonClass self, PNone value, @Bind Node inliningTarget, @Cached ReadAttributeFromObjectNode read, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotDescrGet.CallSlotDescrGet callGet) {
            Object res = read.execute(self, SpecialAttributeNames.T___DOC__);
            if (res == PNone.NO_VALUE) {
                return PNone.NONE;
            }
            Object resClass = getClassNode.execute(inliningTarget, res);
            TpSlots resSlots = getSlots.execute(inliningTarget, resClass);
            if (resSlots.tp_descr_get() != null) {
                return callGet.execute(frame, inliningTarget, resSlots.tp_descr_get(), res, PNone.NO_VALUE, self);
            }
            return res;
        }

        @Specialization
        static Object getDoc(PythonAbstractNativeObject self, PNone value) {
            return ReadAttributeFromObjectNode.getUncachedForceType().execute(self, SpecialAttributeNames.T___DOC__);
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)", "!isPythonBuiltinClass(self)"})
        static Object setDoc(PythonClass self, Object value) {
            self.setAttribute(SpecialAttributeNames.T___DOC__, value);
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)", "isKindOfBuiltinClass(self)"})
        static Object doc(Object self, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, SpecialAttributeNames.T___DOC__, self);
        }

        @Specialization
        static Object doc(Object self, DescriptorDeleteMarker marker, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_DELETE_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, SpecialAttributeNames.T___DOC__, self);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    @ImportStatic(value={SpecialAttributeNames.class})
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached(value="create(T___MODULE__)") GetAttributeNode.GetFixedAttributeNode readModuleNode, @Cached(value="create(T___QUALNAME__)") GetAttributeNode.GetFixedAttributeNode readQualNameNode, @Cached CastToTruffleStringNode castToStringNode, @Cached TruffleString.EqualNode equalNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object moduleNameObj = readModuleNode.executeObject(frame, self);
            Object qualNameObj = readQualNameNode.executeObject(frame, self);
            TruffleString moduleName = null;
            if (moduleNameObj != PNone.NO_VALUE) {
                try {
                    moduleName = castToStringNode.execute(inliningTarget, moduleNameObj);
                }
                catch (CannotCastException cannotCastException) {
                    // empty catch block
                }
            }
            if (moduleName == null || equalNode.execute((AbstractTruffleString)moduleName, (AbstractTruffleString)BuiltinNames.T_BUILTINS, PythonUtils.TS_ENCODING)) {
                return simpleTruffleStringFormatNode.format("<class '%s'>", castToStringNode.execute(inliningTarget, qualNameObj));
            }
            return simpleTruffleStringFormatNode.format("<class '%s.%s'>", moduleName, castToStringNode.execute(inliningTarget, qualNameObj));
        }
    }
}

