/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.interop;

import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.interop.InteropArray;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.HashMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
public final class InteropMap
implements TruffleObject {
    private final Map<String, Object> data;

    public InteropMap(Map<String, Object> data) {
        this.data = data;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage(name="readMember")
    @CompilerDirectives.TruffleBoundary
    Object getKey(String name, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            assert (this.hasKey(name, gil));
            Object object = this.data.get(name);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage(name="isMemberReadable")
    @CompilerDirectives.TruffleBoundary
    boolean hasKey(String name, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = this.data.containsKey(name);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage(name="getMembers")
    @CompilerDirectives.TruffleBoundary
    Object getKeys(boolean includeInternal, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropArray interopArray = new InteropArray(this.data.keySet().toArray());
            return interopArray;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static InteropMap fromPDict(PDict dict) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashingStorage storage = dict.getDictStorage();
        HashingStorageNodes.HashingStorageIterator it = HashingStorageNodes.HashingStorageGetIterator.executeUncached(storage);
        while (HashingStorageNodes.HashingStorageIteratorNext.executeUncached(storage, it)) {
            Object key = HashingStorageNodes.HashingStorageIteratorKey.executeUncached(storage, it);
            Object value = HashingStorageNodes.HashingStorageIteratorValue.executeUncached(storage, it);
            map.put(key.toString(), value);
        }
        return new InteropMap(map);
    }

    @CompilerDirectives.TruffleBoundary
    public static InteropMap fromPythonObject(PythonObject globals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (TruffleString name : globals.getAttributeNames()) {
            map.put(name.toJavaStringUncached(), globals.getAttribute(name));
        }
        return new InteropMap(map);
    }
}

