/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.TruffleLogger;
import java.util.logging.Level;

public abstract class NativeSequenceStorage
extends SequenceStorage {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(NativeSequenceStorage.class);
    private Object ptr;
    private CApiTransitions.NativeStorageReference reference;
    private Object[] replicatedNativeReferences;

    NativeSequenceStorage(Object ptr, int length, int capacity) {
        super(length, capacity);
        this.ptr = ptr;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(PythonUtils.formatJString("new %s", this));
        }
    }

    public final Object getPtr() {
        return this.ptr;
    }

    public final void setPtr(Object ptr) {
        if (this.reference != null) {
            this.reference.setPtr(ptr);
        }
        this.ptr = ptr;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public final void setReference(CApiTransitions.NativeStorageReference reference) {
        assert (this.reference == null) : "attempting to set another NativeStorageReference";
        this.reference = reference;
    }

    public final boolean hasReference() {
        return this.reference != null;
    }

    @Override
    public final void setNewLength(int length) {
        assert (length <= this.capacity);
        this.length = length;
        if (this.reference != null) {
            this.reference.setSize(length);
        }
    }

    @Override
    public final Object getIndicativeValue() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(ptr=" + String.valueOf(CApiContext.asHex(this.ptr)) + ", length=" + this.length + ", capacity=" + this.capacity + ", ownsMemory=" + this.hasReference() + ")";
    }

    public void setReplicatedNativeReferences(Object[] replicatedNativeReferences) {
        this.replicatedNativeReferences = replicatedNativeReferences;
    }

    public Object[] getReplicatedNativeReferences() {
        return this.replicatedNativeReferences;
    }
}

