/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CResultSetAccessor
extends ResultSetAccessor {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    T2CResultSetAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(stmt, max_len * 2, form, external_type, forBind);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$1, null, stmt, max_len, form, external_type, forBind);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    T2CResultSetAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, max_len * 2, nullable, flags, precision, scale, contflag, total_elems, form);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$2, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$2, null);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getBytes(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$0, this, n2);
            }
            byte[] result = null;
            if (this.isNull((int)currentRow)) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$0, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$0, this, null);
                }
                return null;
            }
            int len = this.getLength((int)currentRow);
            byte align = ((T2CConnection)this.statement.connection).byteAlign;
            long adjusted_Offset = this.getOffset((int)currentRow) + (long)(align - 1) & (long)(~(align - 1));
            this.rowData.setPosition(adjusted_Offset);
            byte[] byArray = result = this.rowData.getBytes(len);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$0, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$0, this, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CResultSetAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$2 = T2CResultSetAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T2CResultSetAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CResultSetAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

