/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.replay.driver.FailoverManager;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
class FailoverManagerImpl
implements FailoverManager,
Monitor {
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle;
    private boolean replayInCurrentMode;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries;
    private OracleDataSource replayDataSource;
    private NonTxnReplayableBase connectionProxy;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private static final ExecutorService executor;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;

    private FailoverManagerImpl(NonTxnReplayableBase connProxy, OracleDataSource rds) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$36, null, connProxy, rds);
            }
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            this.replayInCurrentMode = false;
            this.replayInitiationTimeout = 900L;
            this.replayRetries = 0;
            this.replayDataSource = null;
            this.monitorLock = this.newDefaultLock();
            this.connectionProxy = connProxy;
            this.replayDataSource = rds;
            this.enableTxnMonitoring((OracleConnection)this.connectionProxy.getDelegate());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$36, null);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$36, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$36, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static FailoverManager getFailoverManager(NonTxnReplayableBase nonTxnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rds;
            NonTxnReplayableBase connProxy;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$0, null, nonTxnReplayableBase, oracleDataSource);
            }
            FailoverManagerImpl failoverManagerImpl = new FailoverManagerImpl(connProxy, (OracleDataSource)rds);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$0, null, failoverManagerImpl);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$0, null, null);
            }
            return failoverManagerImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void append(CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$1, this, callHistoryEntry);
            }
            entry.prevEntry = this.tail;
            entry.nextEntry = null;
            if (this.tail != null) {
                this.tail.nextEntry = entry;
            }
            this.tail = entry;
            if (this.head == null) {
                this.head = entry;
            }
            Replayable jdbcProxy = (Replayable)entry.jdbcProxy;
            jdbcProxy.addToSameProxyList((CallHistoryEntry)entry);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void remove(CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$2, this, callHistoryEntry);
            }
            if (entry.nextEntry != null) {
                entry.nextEntry.prevEntry = entry.prevEntry;
            }
            if (entry.prevEntry != null) {
                entry.prevEntry.nextEntry = entry.nextEntry;
            }
            if (this.head == entry) {
                this.head = entry.nextEntry;
            }
            if (this.tail == entry) {
                this.tail = entry.prevEntry;
            }
            Replayable jdbcProxy = (Replayable)entry.jdbcProxy;
            jdbcProxy.removeFromSameProxyList((CallHistoryEntry)entry);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CallHistoryEntry record(Object object, Method method, Object[] objectArray, String string) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            CallHistoryEntry callHistoryEntry;
            block22: {
                Monitor.CloseableLock lock;
                block23: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$3, this, object, method, objectArray, string);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void callStatus;
                        void jdbcProxy;
                        void args;
                        void m2;
                        String methodName = m2 == null ? "NULL METHOD" : m2.getName();
                        StringBuilder argStr = new StringBuilder();
                        if (args != null && ((void)args).length > 0) {
                            for (int i2 = 0; i2 < ((void)args).length - 1; ++i2) {
                                argStr.append(args[i2]);
                                argStr.append(",");
                            }
                            argStr.append(args[((void)args).length - 1]);
                        }
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "On connection {0}, recording method {1}({2})", new Object[]{this.connectionProxy, methodName, argStr.toString()});
                        }
                        CallHistoryEntry entry = new CallHistoryEntry(jdbcProxy, (Method)m2, (Object[])args, (String)callStatus);
                        this.append(entry);
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "On connection {0}, recorded method {1}", new Object[]{this.connectionProxy, methodName});
                        }
                        callHistoryEntry = entry;
                        if (lock == null) break block22;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$3, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$3, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block22;
                }
                lock.close();
            }
            CallHistoryEntry callHistoryEntry2 = callHistoryEntry;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$3, this, callHistoryEntry2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$3, this, null);
            }
            return callHistoryEntry2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$3, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void update(Object object, CallHistoryEntry callHistoryEntry, Object object2, String string, long l2, long l3, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block20: {
                Monitor.CloseableLock lock;
                block21: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$4, this, object, callHistoryEntry, object2, string, l2, l3, sQLException);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void callStatus;
                        void sqlexc;
                        void SCN;
                        void checksum;
                        void result;
                        String methodName;
                        void e2;
                        CallHistoryEntry entry = e2 == null ? this.tail : e2;
                        String string2 = methodName = entry == null || entry.method == null ? "NULL METHOD" : entry.method.getName();
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "On connection {0}, updating entry for method {1}", new Object[]{this.connectionProxy, methodName});
                        }
                        entry.result = result;
                        entry.checksum = checksum;
                        entry.scn = SCN;
                        entry.callException = sqlexc;
                        entry.callStatus = callStatus;
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "On connection {0}, updated entry for method {1} - result: {2}, checksum: {3}, SCN: {4}, SQLException: {5}", new Object[]{this.connectionProxy, methodName, result, (long)checksum, (long)SCN, sqlexc});
                        }
                        if (lock == null) break block20;
                        if (throwable == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$4, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$4, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$4, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void purge() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block21: {
                Monitor.CloseableLock lock;
                block22: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$5, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$5, Level.FINER, this.getClass(), $$$methodRef$$$5, "On connection {0}, calling explicit purge", this.connectionProxy);
                        }
                        CallHistoryEntry entry = this.head;
                        while (entry != null) {
                            this.remove(entry);
                            entry = entry.nextEntry;
                        }
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$5, Level.FINER, this.getClass(), $$$methodRef$$$5, "On connection {0}, calling explicit purge succeeds", this.connectionProxy);
                        }
                        if (lock == null) break block21;
                        if (throwable == null) break block22;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$5, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$5, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$5, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void purgeForSameProxy(Set<Object> set, CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block23: {
                Monitor.CloseableLock lock;
                block24: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$6, this, set, callHistoryEntry);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void headForProxy;
                        Object jproxy;
                        Object object = jproxy = headForProxy == null ? null : headForProxy.jdbcProxy;
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$6, Level.FINER, this.getClass(), $$$methodRef$$$6, "On connection {0}, calling implicit purge for {1}", new Object[]{this.connectionProxy, jproxy});
                        }
                        CallHistoryEntry entry = headForProxy;
                        while (entry != null) {
                            void visitedProxies;
                            Object callResult = entry.result;
                            if (callResult != null && callResult instanceof Replayable && !visitedProxies.contains(callResult)) {
                                Replayable resultProxy = (Replayable)callResult;
                                resultProxy.purgeSameProxyList();
                                visitedProxies.add(resultProxy);
                            }
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$6, Level.FINEST, this.getClass(), $$$methodRef$$$6, "On connection {0}, implicit purge {1}", new Object[]{this.connectionProxy, entry.method});
                            }
                            this.remove(entry);
                            entry = entry.nextEntrySameProxy;
                        }
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$6, Level.FINER, this.getClass(), $$$methodRef$$$6, "On connection {0}, calling implicit purge for {1} succeeds", new Object[]{this.connectionProxy, jproxy});
                        }
                        if (lock == null) break block23;
                        if (throwable == null) break block24;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$6, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$6, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block23;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$6, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isEmpty() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$7, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        boolean bl3 = bl2 = this.head == null;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$7, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$7, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            boolean bl4 = bl2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$7, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$7, this, null);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$7, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void fillInAllChecksums() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block21: {
                Monitor.CloseableLock lock;
                block22: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$8, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        HashSet<Object> visitedProxies = new HashSet<Object>();
                        CallHistoryEntry entry = this.tail.prevEntry;
                        while (entry != null) {
                            if (!visitedProxies.contains(entry.jdbcProxy)) {
                                NonTxnReplayableBase jproxy = (NonTxnReplayableBase)entry.jdbcProxy;
                                jproxy.fillInChecksum(entry);
                                visitedProxies.add(entry.jdbcProxy);
                                if (entry.jdbcProxy instanceof ResultSet) {
                                    visitedProxies.add(jproxy.getCreator());
                                }
                            }
                            entry = entry.prevEntry;
                        }
                        if (lock == null) break block21;
                        if (throwable == null) break block22;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$8, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$8, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$8, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    Object replayAll(SQLRecoverableException var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 24[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object replayAllInternal(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Object object;
            block40: {
                Monitor.CloseableLock lock;
                block41: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$10, this, sQLRecoverableException, n2);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void currentRetries;
                        OracleConnection newConn;
                        void origError;
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "Entering replayAllInternal(connection proxy={0}, original error={1})", new Object[]{this.connectionProxy, origError});
                        }
                        ReplayLifecycle curLifecycle = this.lifecycle;
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "current lifecycle:{0}", (Object)curLifecycle);
                        }
                        if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                            this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, (SQLRecoverableException)origError);
                        }
                        if ((newConn = (OracleConnection)this.replayDataSource.getConnectionNoProxy(((NonTxnReplayableConnection)this.connectionProxy).originalConnectionBuilder)) == null) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$10, Level.FINE, this.getClass(), $$$methodRef$$$10, "FAILOVER_RETRIES exceeded");
                            }
                            this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", (SQLRecoverableException)origError);
                        }
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "Reconnect succeeded, new connection={0}", newConn);
                        }
                        long currentTimestamp = System.currentTimeMillis();
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "timestamp at replay start: {0}", currentTimestamp);
                        }
                        if (this.requestStartTime + this.replayInitiationTimeout * 1000L < currentTimestamp) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$10, Level.WARNING, this.getClass(), $$$methodRef$$$10, "ReplayInitiationTimeout exceeded");
                            }
                            this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", (SQLRecoverableException)origError);
                        }
                        this.connectionProxy.setDelegate(newConn);
                        newConn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
                        this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
                        ConnectionInitializationCallback initCbk = this.replayDataSource.getConnectionInitializationCallback();
                        if (initCbk != null) {
                            try {
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "Invoking Replay Driver initialization callback with {0}", this.connectionProxy);
                                }
                                initCbk.initialize((Connection)((Object)this.connectionProxy));
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "Invoking initialization callback with {0} succeeded", this.connectionProxy);
                                }
                            }
                            catch (SQLException sqlexc) {
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "Invoking initialization callback with {0} failed", this.connectionProxy);
                                }
                                this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", (SQLRecoverableException)origError);
                            }
                            EnumSet<OracleConnection.TransactionState> eocs = newConn.getTransactionState();
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "On connection {0}, after init-callback, transaction state={1}", new Object[]{this.connectionProxy, eocs});
                            }
                            if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                                this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", (SQLRecoverableException)origError);
                            }
                        }
                        this.lifecycle = ReplayLifecycle.REPLAYING;
                        if (currentRetries == false) {
                            this.fillInAllChecksums();
                        }
                        this.beginReplay(newConn, (SQLRecoverableException)origError);
                        this.replayResult = this.replayAllBeforeLastCall((SQLRecoverableException)origError);
                        this.endReplay(newConn, (SQLRecoverableException)origError);
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "On connection {0}, replaying last call", this.connectionProxy);
                        }
                        if (this.tail != null) {
                            this.replayResult = ((Replayable)this.tail.jdbcProxy).replayOneCall(this.tail, (SQLRecoverableException)origError);
                        }
                        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "On connection {0}, replay succeeds", this.connectionProxy);
                        }
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "Exiting replayAll(connection proxy={0}, original error={1}), result={2}", new Object[]{this.connectionProxy, origError, this.replayResult});
                        }
                        object = this.replayResult;
                        if (lock == null) break block40;
                        if (throwable == null) break block41;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$10, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$10, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block40;
                }
                lock.close();
            }
            Object object2 = object;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$10, this, object2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$10, this, null);
            }
            return object2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$10, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object replayAllBeforeLastCall(SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Object object;
            block21: {
                Monitor.CloseableLock lock;
                block22: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$11, this, sQLRecoverableException);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        Object replayResult = null;
                        CallHistoryEntry entry = this.head;
                        while (entry != this.tail) {
                            void origError;
                            Replayable jproxy = (Replayable)entry.jdbcProxy;
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$11, Level.FINEST, this.getClass(), $$$methodRef$$$11, "On proxy {0}, replaying {1}", new Object[]{jproxy, entry.method});
                            }
                            replayResult = jproxy.replayOneCall(entry, (SQLRecoverableException)origError);
                            if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                                this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, (SQLRecoverableException)origError);
                            }
                            entry = entry.nextEntry;
                        }
                        object = replayResult;
                        if (lock == null) break block21;
                        if (throwable == null) break block22;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$11, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$11, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                lock.close();
            }
            Object object2 = object;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$11, this, object2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$11, this, null);
            }
            return object2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$11, this, throwable8);
            }
            throw throwable;
        }
    }

    boolean isReplayInCurrentMode() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$12, this, new Object[0]);
            }
            boolean bl2 = this.replayInCurrentMode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$12, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$12, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    void setReplayInCurrentMode() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$13, this, new Object[0]);
            }
            this.replayInCurrentMode = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    ReplayLifecycle getReplayLifecycle() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$14, this, new Object[0]);
            }
            ReplayLifecycle replayLifecycle = this.lifecycle;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$14, this, (Object)replayLifecycle);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$14, this, null);
            }
            return replayLifecycle;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setDataSource(OracleDataSource oracleDataSource) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rds;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$15, this, oracleDataSource);
            }
            this.replayDataSource = rds;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setReplayInitiationTimeout(int n2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timeout;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$16, this, n2);
            }
            this.replayInitiationTimeout = (long)timeout;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    void beginRequest() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$17, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$17, Level.FINER, this.getClass(), $$$methodRef$$$17, "On connection {0}, Entering beginRequest()", this.connectionProxy);
            }
            if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$17, Level.FINER, this.getClass(), $$$methodRef$$$17, "Exiting beginRequest(), MONITOR_TXN failed, no-op");
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$17, this);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$17, this, null);
                }
                return;
            }
            if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
                SQLException sQLException = DatabaseError.createSqlException(391);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$17, this, sQLException);
                }
                throw sQLException;
            }
            this.requestStartTime = System.currentTimeMillis();
            if (bl) {
                OracleLog.log($$$loggerRef$$$17, Level.FINEST, this.getClass(), $$$methodRef$$$17, "Request start timestamp: {0}", this.requestStartTime);
            }
            OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
            EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
            if (bl) {
                OracleLog.log($$$loggerRef$$$17, Level.FINER, this.getClass(), $$$methodRef$$$17, "transaction state: {0}", eocs);
            }
            if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                SQLException sqlexc = DatabaseError.createSqlException(392);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$17, Level.FINER, this.getClass(), $$$methodRef$$$17, "beginRequest", sqlexc);
                }
                SQLException sQLException = sqlexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$17, this, sQLException);
                }
                throw sQLException;
            }
            this.replayErrorCode = 0;
            this.replayErrorMessage = "";
            this.callCausingReplayError = null;
            oconn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
            if (bl) {
                OracleLog.log($$$loggerRef$$$17, Level.FINER, this.getClass(), $$$methodRef$$$17, "Recording begins on connection {0}", this.connectionProxy);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$17, Level.FINER, this.getClass(), $$$methodRef$$$17, "Exiting beginRequest()");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    void endRequest() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$18, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$18, Level.FINER, this.getClass(), $$$methodRef$$$18, "Entering endRequest()");
            }
            OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
            EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
            if (bl) {
                OracleLog.log($$$loggerRef$$$18, Level.FINER, this.getClass(), $$$methodRef$$$18, "transaction state: {0}", eocs);
            }
            if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                block19: {
                    try {
                        oconn.rollback();
                    }
                    catch (SQLException sqlexc) {
                        if (!bl) break block19;
                        OracleLog.log($$$loggerRef$$$18, Level.FINEST, this.getClass(), $$$methodRef$$$18, "Rollback open transaction failed before throwing exception");
                    }
                }
                SQLException sqlexc = DatabaseError.createSqlException(393);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$18, Level.FINER, this.getClass(), $$$methodRef$$$18, "endRequest", sqlexc);
                }
                SQLException sQLException = sqlexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$18, Level.FINER, this.getClass(), $$$methodRef$$$18, "Exiting endRequest() -- MONITOR_TXN failed");
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$18, this);
                    ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$18, this, null);
                }
                return;
            }
            if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED || this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$18, Level.FINER, this.getClass(), $$$methodRef$$$18, "Exiting endRequest() -- replay already disabled");
                }
                this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$18, this);
                    ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$18, this, null);
                }
                return;
            }
            this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
            if (bl) {
                OracleLog.log($$$loggerRef$$$18, Level.FINER, this.getClass(), $$$methodRef$$$18, "Exiting endRequest()");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    void disableReplay() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$19, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$19, Level.FINER, this.getClass(), $$$methodRef$$$19, "Entering disableReplay");
            }
            if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$19, Level.FINER, this.getClass(), $$$methodRef$$$19, "Exiting disableReplay(), MONITOR_TXN failed, no-op");
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$19, this);
                    ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$19, this, null);
                }
                return;
            }
            this.disableReplayInternal(null, 370, "Replay disabled", null);
            this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
            if (bl) {
                OracleLog.log($$$loggerRef$$$19, Level.FINER, this.getClass(), $$$methodRef$$$19, "On connection {0}, replay is externally disabled", this.connectionProxy);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$19, Level.FINER, this.getClass(), $$$methodRef$$$19, "Exiting disableReplay");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void disableReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            void errMesg;
            void errCode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$20, this, method, n2, string, sQLRecoverableException);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$20, Level.FINER, this.getClass(), $$$methodRef$$$20, "Entering disableReplayInternal");
            }
            ReplayLifecycle curLifecycle = this.lifecycle;
            OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
            if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
                this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            }
            this.purge();
            this.replayErrorCode = errCode;
            this.replayErrorMessage = errMesg;
            this.callCausingReplayError = m2;
            if (bl) {
                OracleLog.log($$$loggerRef$$$20, Level.FINER, this.getClass(), $$$methodRef$$$20, "On connection {0}, replay is internally disabled", this.connectionProxy);
            }
            try {
                oconn.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$20, Level.FINER, this.getClass(), $$$methodRef$$$20, "Exiting disableReplayInternal");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void failReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            void errMesg;
            void errCode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$21, this, method, n2, string, sQLRecoverableException);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$21, Level.FINER, this.getClass(), $$$methodRef$$$21, "Entering failReplayInternal");
            }
            ReplayLifecycle curLifecycle = this.lifecycle;
            if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
            }
            this.replayErrorCode = errCode;
            this.replayErrorMessage = errMesg;
            this.callCausingReplayError = m2;
            if (bl) {
                OracleLog.log($$$loggerRef$$$21, Level.FINER, this.getClass(), $$$methodRef$$$21, "On connection {0}, replay failed", this.connectionProxy);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$21, Level.FINER, this.getClass(), $$$methodRef$$$21, "Exiting failReplayInternal");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void throwReplayExceptionInternal(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            SQLException replayErr;
            void errCode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$22, this, n2, string, sQLRecoverableException);
            }
            if (errCode == false) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$22, this);
                    ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$22, this, null);
                }
                return;
            }
            String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
            SQLException sQLException = replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$22, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void disableReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void errMesg;
            void errCode;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$23, this, method, n2, string, sQLRecoverableException);
            }
            this.disableReplayInternal((Method)m2, (int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            this.throwReplayExceptionInternal((int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void disableReplayAndThrowOriginalError(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void errMesg;
            void errCode;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$24, this, method, n2, string, sQLRecoverableException);
            }
            this.disableReplayInternal((Method)m2, (int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            this.throwOriginalExceptionWithReplayError((int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void failReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void errMesg;
            void errCode;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$25, this, method, n2, string, sQLRecoverableException);
            }
            this.failReplayInternal((Method)m2, (int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            this.throwReplayExceptionInternal((int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void throwOriginalExceptionWithReplayError(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLRecoverableException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$26, this, n2, string, sQLRecoverableException);
            }
            this.killConnectionBeforeReplayDisabledException();
            String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
            SQLException replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
            origError.setNextException(replayErr);
            void var7_7 = origError;
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$26, this, (Throwable)var7_7);
            }
            throw var7_7;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    void killConnectionBeforeReplayDisabledException() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block10: {
                OracleConnection oconn;
                block9: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$27, this, new Object[0]);
                    }
                    oconn = (OracleConnection)this.connectionProxy.getDelegate();
                    try {
                        oconn.abort();
                    }
                    catch (SQLException sqlexc) {
                        if (!bl) break block9;
                        OracleLog.log($$$loggerRef$$$27, Level.FINE, this.getClass(), $$$methodRef$$$27, "Aborting connection failed before throwing replay-disabled exception");
                    }
                }
                try {
                    executor.submit(new Runnable(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;

                        @Override
                        public void run() {
                            FailoverManagerImpl.access$000(FailoverManagerImpl.this, oconn);
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 2.class.getDeclaredConstructor(FailoverManagerImpl.class, OracleConnection.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            try {
                                $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        }
                    });
                }
                catch (Exception exc) {
                    if (!bl) break block10;
                    OracleLog.log($$$loggerRef$$$27, Level.FINER, this.getClass(), $$$methodRef$$$27, "On connection {0}, ASYNC close() submission during replay failed", this.connectionProxy);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void enableTxnMonitoring(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$28, this, oracleConnection);
            }
            try {
                void oconn;
                Statement stmt = oconn.createStatement();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$28, Level.FINER, this.getClass(), $$$methodRef$$$28, "Calling MONITOR_TXN");
                }
                stmt.execute(MONITOR_TXN);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$28, Level.FINER, this.getClass(), $$$methodRef$$$28, "Calling MONITOR_TXN succeeded");
                }
                stmt.close();
            }
            catch (SQLException sqlexc) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$28, Level.FINER, this.getClass(), $$$methodRef$$$28, "Calling MONITOR_TXN failed");
                }
                this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
                this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
                SQLException sQLException = DatabaseError.createSqlException(395);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$28, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void beginReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$29, this, oracleConnection, sQLRecoverableException);
            }
            try {
                void oconn;
                Statement stmt = oconn.createStatement();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$29, Level.FINER, this.getClass(), $$$methodRef$$$29, "Calling BEGIN_REPLAY");
                }
                stmt.execute(BEGIN_REPLAY);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$29, Level.FINER, this.getClass(), $$$methodRef$$$29, "Calling BEGIN_REPLAY succeeded");
                }
                stmt.close();
                this.lifecycle = ReplayLifecycle.REPLAYING;
            }
            catch (SQLException sqlexc) {
                void origError;
                if (bl) {
                    OracleLog.log($$$loggerRef$$$29, Level.FINER, this.getClass(), $$$methodRef$$$29, "Calling BEGIN_REPLAY failed");
                }
                this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", (SQLRecoverableException)origError);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void endReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$30, this, oracleConnection, sQLRecoverableException);
            }
            try {
                void oconn;
                Statement stmt = oconn.createStatement();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$30, Level.FINER, this.getClass(), $$$methodRef$$$30, "Calling END_REPLAY");
                }
                stmt.execute(END_REPLAY);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$30, Level.FINER, this.getClass(), $$$methodRef$$$30, "Calling END_REPLAY succeeded");
                }
                stmt.close();
                this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
            }
            catch (SQLException sqlexc) {
                void origError;
                if (bl) {
                    OracleLog.log($$$loggerRef$$$30, Level.FINER, this.getClass(), $$$methodRef$$$30, "Calling END_REPLAY failed");
                }
                this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", (SQLRecoverableException)origError);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    Replayable getConnectionProxy() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$31, this, new Object[0]);
            }
            NonTxnReplayableBase nonTxnReplayableBase = this.connectionProxy;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$31, this, nonTxnReplayableBase);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$31, this, null);
            }
            return nonTxnReplayableBase;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isReplayFailure(SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            int errCode;
            void t2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$32, this, sQLException);
            }
            boolean result = false;
            if (t2 != null && (errCode = t2.getErrorCode()) >= 370 && errCode < 400) {
                result = true;
            }
            boolean bl2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$32, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$32, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closePhysicalConnection(Connection connection) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$33, this, connection);
                }
                try {
                    void conn;
                    conn.close();
                }
                catch (SQLException sqlexc) {
                    if (!bl) break block7;
                    OracleLog.log($$$loggerRef$$$33, Level.FINER, this.getClass(), $$$methodRef$$$33, "On connection {0}, connection close() during replay failed", this.connectionProxy);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$34, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$34, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$34, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(FailoverManagerImpl failoverManagerImpl, Connection connection) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void x1;
            FailoverManagerImpl x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$35, null, failoverManagerImpl, connection);
            }
            x0.closePhysicalConnection((Connection)x1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$35, null);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$35, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, FailoverManagerImpl.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$36 = FailoverManagerImpl.class.getDeclaredConstructor(NonTxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$35 = FailoverManagerImpl.class.getDeclaredMethod("access$000", FailoverManagerImpl.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$34 = FailoverManagerImpl.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$33 = FailoverManagerImpl.class.getDeclaredMethod("closePhysicalConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$32 = FailoverManagerImpl.class.getDeclaredMethod("isReplayFailure", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = FailoverManagerImpl.class.getDeclaredMethod("getConnectionProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = FailoverManagerImpl.class.getDeclaredMethod("endReplay", OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = FailoverManagerImpl.class.getDeclaredMethod("beginReplay", OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = FailoverManagerImpl.class.getDeclaredMethod("enableTxnMonitoring", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = FailoverManagerImpl.class.getDeclaredMethod("killConnectionBeforeReplayDisabledException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = FailoverManagerImpl.class.getDeclaredMethod("throwOriginalExceptionWithReplayError", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = FailoverManagerImpl.class.getDeclaredMethod("failReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = FailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowOriginalError", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = FailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = FailoverManagerImpl.class.getDeclaredMethod("throwReplayExceptionInternal", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = FailoverManagerImpl.class.getDeclaredMethod("failReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = FailoverManagerImpl.class.getDeclaredMethod("disableReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = FailoverManagerImpl.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = FailoverManagerImpl.class.getDeclaredMethod("endRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = FailoverManagerImpl.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = FailoverManagerImpl.class.getDeclaredMethod("setReplayInitiationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = FailoverManagerImpl.class.getDeclaredMethod("setDataSource", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = FailoverManagerImpl.class.getDeclaredMethod("getReplayLifecycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = FailoverManagerImpl.class.getDeclaredMethod("setReplayInCurrentMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = FailoverManagerImpl.class.getDeclaredMethod("isReplayInCurrentMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = FailoverManagerImpl.class.getDeclaredMethod("replayAllBeforeLastCall", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = FailoverManagerImpl.class.getDeclaredMethod("replayAllInternal", SQLRecoverableException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = FailoverManagerImpl.class.getDeclaredMethod("replayAll", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = FailoverManagerImpl.class.getDeclaredMethod("fillInAllChecksums", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = FailoverManagerImpl.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = FailoverManagerImpl.class.getDeclaredMethod("purgeForSameProxy", Set.class, CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = FailoverManagerImpl.class.getDeclaredMethod("purge", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = FailoverManagerImpl.class.getDeclaredMethod("update", Object.class, CallHistoryEntry.class, Object.class, String.class, Long.TYPE, Long.TYPE, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = FailoverManagerImpl.class.getDeclaredMethod("record", Object.class, Method.class, Object[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = FailoverManagerImpl.class.getDeclaredMethod("remove", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = FailoverManagerImpl.class.getDeclaredMethod("append", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = FailoverManagerImpl.class.getDeclaredMethod("getFailoverManager", NonTxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public Thread newThread(Runnable r2) {
                Thread newT = new Thread(null, r2, THREAD_NAME);
                newT.setPriority(5);
                newT.setDaemon(true);
                return newT;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("newThread", Runnable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
    }

    static final class ReplayLifecycle
    extends Enum<ReplayLifecycle> {
        public static final /* enum */ ReplayLifecycle ENABLED_NOT_REPLAYING;
        public static final /* enum */ ReplayLifecycle INTERNALLY_FAILED;
        public static final /* enum */ ReplayLifecycle INTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle ALWAYS_DISABLED;
        public static final /* enum */ ReplayLifecycle EXTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle REPLAYING_CALLBACK;
        public static final /* enum */ ReplayLifecycle REPLAYING;
        public static final /* enum */ ReplayLifecycle REPLAYING_LASTCALL;
        private static final /* synthetic */ ReplayLifecycle[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ReplayLifecycle[] values() {
            return (ReplayLifecycle[])$VALUES.clone();
        }

        public static ReplayLifecycle valueOf(String name) {
            return Enum.valueOf(ReplayLifecycle.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = ReplayLifecycle.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ReplayLifecycle.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ReplayLifecycle.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ENABLED_NOT_REPLAYING = new ReplayLifecycle();
            INTERNALLY_FAILED = new ReplayLifecycle();
            INTERNALLY_DISABLED = new ReplayLifecycle();
            ALWAYS_DISABLED = new ReplayLifecycle();
            EXTERNALLY_DISABLED = new ReplayLifecycle();
            REPLAYING_CALLBACK = new ReplayLifecycle();
            REPLAYING = new ReplayLifecycle();
            REPLAYING_LASTCALL = new ReplayLifecycle();
            $VALUES = new ReplayLifecycle[]{ENABLED_NOT_REPLAYING, INTERNALLY_FAILED, INTERNALLY_DISABLED, ALWAYS_DISABLED, EXTERNALLY_DISABLED, REPLAYING_CALLBACK, REPLAYING, REPLAYING_LASTCALL};
        }
    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long scn;
        long checksum;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        CallHistoryEntry(Object jdbcProxy, Method m2, Object[] args, String callStatus) {
            this.jdbcProxy = jdbcProxy;
            this.method = m2;
            this.args = args;
            this.result = null;
            this.callStatus = callStatus;
        }

        static {
            try {
                $$$methodRef$$$0 = CallHistoryEntry.class.getDeclaredConstructor(Object.class, Method.class, Object[].class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

