/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.ROWID;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public abstract class OracleType
implements Serializable {
    static final long serialVersionUID = -4124152314660261528L;
    public static final int STYLE_ARRAY_LENGTH = 0;
    public static final int STYLE_DATUM = 1;
    public static final int STYLE_JAVA = 2;
    public static final int STYLE_RAWBYTE = 3;
    public static final int STYLE_INT = 4;
    public static final int STYLE_DOUBLE = 5;
    public static final int STYLE_FLOAT = 6;
    public static final int STYLE_LONG = 7;
    public static final int STYLE_SHORT = 8;
    public static final int STYLE_SKIP = 9;
    static final int FORMAT_ADT_ATTR = 1;
    static final int FORMAT_COLL_ELEM = 2;
    static final int FORMAT_COLL_ELEM_NO_INDICATOR = 3;
    static final int SQLCS_IMPLICIT = 1;
    static final int SQLCS_NCHAR = 2;
    static final int SQLCS_EXPLICIT = 3;
    static final int SQLCS_FLEXIBLE = 4;
    static final int SQLCS_LIT_NULL = 5;
    int typeCode;
    int dbTypeCode;
    boolean metaDataInitialized;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;

    public OracleType() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, OracleType.class, $$$methodRef$$$37, null, new Object[0]);
            }
            this.metaDataInitialized = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, OracleType.class, $$$methodRef$$$37, null);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleType.class, $$$methodRef$$$37, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleType.class, $$$methodRef$$$37, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleType(int typecode) {
        this();
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, OracleType.class, $$$methodRef$$$38, null, typecode);
            }
            this.typeCode = typecode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, OracleType.class, $$$methodRef$$$38, null);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleType.class, $$$methodRef$$$38, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleType.class, $$$methodRef$$$38, null, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleType.class, $$$methodRef$$$0, this, oracleType);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleType.class, $$$methodRef$$$0, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleType.class, $$$methodRef$$$0, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleType.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleType.class, $$$methodRef$$$1, this, structDescriptor);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleType.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleType.class, $$$methodRef$$$1, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleType.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isObjectType() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleType.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleType.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleType.class, $$$methodRef$$$2, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleType.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public TypeDescriptor getTypeDescriptor() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleType.class, $$$methodRef$$$3, this, new Object[0]);
            }
            TypeDescriptor typeDescriptor = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleType.class, $$$methodRef$$$3, this, typeDescriptor);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleType.class, $$$methodRef$$$3, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleType.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    private Class getOracleSqlClassType() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            Class oracleSqlClassType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleType.class, $$$methodRef$$$4, this, new Object[0]);
            }
            int oracleTypeCode = this.getTypeCode();
            switch (oracleTypeCode) {
                case -2: {
                    oracleSqlClassType = RAW.class;
                    break;
                }
                case 101: {
                    oracleSqlClassType = BINARY_DOUBLE.class;
                    break;
                }
                case 100: {
                    oracleSqlClassType = BINARY_FLOAT.class;
                    break;
                }
                case 1: {
                    oracleSqlClassType = CHAR.class;
                    break;
                }
                case 2005: {
                    oracleSqlClassType = CLOB.class;
                    break;
                }
                case 91: {
                    oracleSqlClassType = DATE.class;
                    break;
                }
                case 2: 
                case 3: {
                    oracleSqlClassType = NUMBER.class;
                    break;
                }
                case -104: {
                    oracleSqlClassType = INTERVALDS.class;
                    break;
                }
                case -103: {
                    oracleSqlClassType = INTERVALYM.class;
                    break;
                }
                case -8: {
                    oracleSqlClassType = ROWID.class;
                    break;
                }
                case 93: {
                    oracleSqlClassType = TIMESTAMP.class;
                    break;
                }
                case -102: {
                    oracleSqlClassType = TIMESTAMPLTZ.class;
                    break;
                }
                case -101: {
                    oracleSqlClassType = TIMESTAMPTZ.class;
                    break;
                }
                default: {
                    oracleSqlClassType = null;
                }
            }
            Class clazz = oracleSqlClassType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleType.class, $$$methodRef$$$4, this, clazz);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleType.class, $$$methodRef$$$4, this, null);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleType.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public abstract Datum toDatum(Object var1, oracle.jdbc.internal.OracleConnection var2) throws SQLException;

    /*
     * WARNING - void declaration
     */
    public Datum toDatumInternal(Object object, oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleType.class, $$$methodRef$$$5, this, object, oracleConnection);
            }
            Datum datum = this.toDatum(value, (oracle.jdbc.internal.OracleConnection)conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleType.class, $$$methodRef$$$5, this, datum);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleType.class, $$$methodRef$$$5, this, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleType.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Datum[] toDatumArrayInternal(Object object, oracle.jdbc.internal.OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void beginIdx;
            void conn;
            void obj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleType.class, $$$methodRef$$$6, this, object, oracleConnection, l2, n2);
            }
            Datum[] datumArray = this.toDatumArray(obj, (oracle.jdbc.internal.OracleConnection)conn, (long)beginIdx, (int)count);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleType.class, $$$methodRef$$$6, this, datumArray);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleType.class, $$$methodRef$$$6, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleType.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Datum[] toDatumArray(Object object, oracle.jdbc.internal.OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void obj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleType.class, $$$methodRef$$$7, this, object, oracleConnection, l2, n2);
            }
            Datum[] datumArray = null;
            if (obj != null) {
                if (obj instanceof Object[]) {
                    void beginIdx;
                    void count;
                    Object[] objArray = (Object[])obj;
                    int length = (int)(count == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[length];
                    for (int i2 = 0; i2 < length; ++i2) {
                        Class oracleSqlClass;
                        void conn;
                        Object value = objArray[(int)beginIdx + i2 - 1];
                        if (conn != null && conn instanceof OracleConnection && value != null && (oracleSqlClass = this.getOracleSqlClassType()) != null) {
                            try {
                                value = JavaToJavaConverter.convert(value, oracleSqlClass, (OracleConnection)conn, null, null);
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        datumArray[i2] = this.toDatum(value, (oracle.jdbc.internal.OracleConnection)conn);
                    }
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, obj).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleType.class, $$$methodRef$$$7, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            Datum[] datumArray2 = datumArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleType.class, $$$methodRef$$$7, this, datumArray2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleType.class, $$$methodRef$$$7, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleType.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTypeCode(int n2) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void code;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleType.class, $$$methodRef$$$8, this, n2);
            }
            this.typeCode = code;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleType.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleType.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleType.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getTypeCode() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleType.class, $$$methodRef$$$9, this, new Object[0]);
            }
            int n2 = this.typeCode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleType.class, $$$methodRef$$$9, this, n2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleType.class, $$$methodRef$$$9, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleType.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDBTypeCode(int n2) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void code;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleType.class, $$$methodRef$$$10, this, n2);
            }
            this.dbTypeCode = code;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleType.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleType.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleType.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getDBTypeCode() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleType.class, $$$methodRef$$$11, this, new Object[0]);
            }
            int n2 = this.dbTypeCode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleType.class, $$$methodRef$$$11, this, n2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleType.class, $$$methodRef$$$11, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleType.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleType.class, $$$methodRef$$$12, this, tDSReader);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleType.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleType.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleType.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object unpickle81rec(PickleContext pickleContext, int n2, Map map) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void map2;
            void context;
            void type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleType.class, $$$methodRef$$$13, this, pickleContext, n2, map);
            }
            if (type == 9) {
                context.skipDataValue();
                Object var6_5 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleType.class, $$$methodRef$$$13, this, var6_5);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleType.class, $$$methodRef$$$13, this, null);
                }
                return null;
            }
            byte[] val = context.readDataValue();
            Object object = this.toObject(val, (int)type, (Map)map2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleType.class, $$$methodRef$$$13, this, object);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleType.class, $$$methodRef$$$13, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleType.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n2, Map map) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void map2;
            void byte1;
            void context;
            void type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleType.class, $$$methodRef$$$14, this, pickleContext, by, n2, map);
            }
            if (type == 9) {
                context.skipDataValue();
                Object var7_6 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleType.class, $$$methodRef$$$14, this, var7_6);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleType.class, $$$methodRef$$$14, this, null);
                }
                return null;
            }
            byte[] val = context.readDataValue((byte)byte1);
            Object object = this.toObject(val, (int)type, (Map)map2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleType.class, $$$methodRef$$$14, this, object);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleType.class, $$$methodRef$$$14, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleType.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    protected Datum unpickle81datumAsNull(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleType.class, $$$methodRef$$$15, this, pickleContext, by, by2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleType.class, $$$methodRef$$$15, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleType.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleType.class, $$$methodRef$$$16, this, byArray, n2, map);
            }
            Object var5_5 = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleType.class, $$$methodRef$$$16, this, var5_5);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleType.class, $$$methodRef$$$16, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleType.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void data;
            void ctx;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleType.class, $$$methodRef$$$17, this, pickleContext, datum);
            }
            int len = ctx.writeLength((int)data.getLength());
            int n2 = len += ctx.writeData(data.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleType.class, $$$methodRef$$$17, this, n2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleType.class, $$$methodRef$$$17, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleType.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void writeSerializedFields(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void out;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleType.class, $$$methodRef$$$18, this, objectOutputStream);
            }
            this.writeObject((ObjectOutputStream)out);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleType.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleType.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleType.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void readSerializedFields(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void in;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleType.class, $$$methodRef$$$19, this, objectInputStream);
            }
            this.readObject((ObjectInputStream)in);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleType.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleType.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleType.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void out;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleType.class, $$$methodRef$$$20, this, objectOutputStream);
            }
            out.writeInt(0);
            out.writeInt(0);
            out.writeInt(0);
            out.writeInt(0);
            out.writeInt(this.typeCode);
            out.writeInt(this.dbTypeCode);
            out.writeBoolean(this.metaDataInitialized);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleType.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleType.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleType.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void in;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleType.class, $$$methodRef$$$21, this, objectInputStream);
            }
            int nullOffset = in.readInt();
            int ldsOffset = in.readInt();
            int sizeForLds = in.readInt();
            int alignForLds = in.readInt();
            this.typeCode = in.readInt();
            this.dbTypeCode = in.readInt();
            this.metaDataInitialized = in.readBoolean();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleType.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleType.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleType.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    public void setConnection(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleType.class, $$$methodRef$$$22, this, oracleConnection);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleType.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleType.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleType.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isNCHAR() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleType.class, $$$methodRef$$$23, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleType.class, $$$methodRef$$$23, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleType.class, $$$methodRef$$$23, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleType.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getPrecision() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleType.class, $$$methodRef$$$24, this, new Object[0]);
            }
            int n2 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleType.class, $$$methodRef$$$24, this, n2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleType.class, $$$methodRef$$$24, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleType.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getScale() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleType.class, $$$methodRef$$$25, this, new Object[0]);
            }
            int n2 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleType.class, $$$methodRef$$$25, this, n2);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleType.class, $$$methodRef$$$25, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleType.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    public void initMetadataRecursively() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleType.class, $$$methodRef$$$26, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleType.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleType.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleType.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    public void initNamesRecursively() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleType.class, $$$methodRef$$$27, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleType.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleType.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleType.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    public void initChildNamesRecursively(Map map) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleType.class, $$$methodRef$$$28, this, map);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleType.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleType.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleType.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    public void cacheDescriptor() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleType.class, $$$methodRef$$$29, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleType.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleType.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleType.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    public void setNames(String string, String string2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleType.class, $$$methodRef$$$30, this, string, string2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleType.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleType.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleType.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    public String toXMLString() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleType.class, $$$methodRef$$$31, this, new Object[0]);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.printXMLHeader(pw);
            this.printXML(pw, 0);
            String string = sw.getBuffer().substring(0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleType.class, $$$methodRef$$$31, this, string);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleType.class, $$$methodRef$$$31, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleType.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printXML(PrintStream printStream) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void ps;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleType.class, $$$methodRef$$$32, this, printStream);
            }
            PrintWriter pw = new PrintWriter((OutputStream)ps, true);
            this.printXMLHeader(pw);
            this.printXML(pw, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleType.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleType.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleType.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void printXMLHeader(PrintWriter printWriter) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void pw;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleType.class, $$$methodRef$$$33, this, printWriter);
            }
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleType.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleType.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleType.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void indent;
            void pw;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleType.class, $$$methodRef$$$34, this, printWriter, n2);
            }
            this.printXML((PrintWriter)pw, (int)indent, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleType.class, $$$methodRef$$$34, this);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleType.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleType.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void pw;
            void indent;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OracleType.class, $$$methodRef$$$35, this, printWriter, n2, bl);
            }
            for (int i2 = 0; i2 < indent; ++i2) {
                pw.print("  ");
            }
            pw.println("<OracleType typecode=\"" + this.typeCode + "\" />");
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OracleType.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleType.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleType.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, OracleType.class, $$$methodRef$$$36, this, new Object[0]);
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, OracleType.class, $$$methodRef$$$36, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleType.class, $$$methodRef$$$36, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleType.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$38 = OracleType.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleType.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleType.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleType.class.getDeclaredMethod("printXML", PrintWriter.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleType.class.getDeclaredMethod("printXML", PrintWriter.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleType.class.getDeclaredMethod("printXMLHeader", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleType.class.getDeclaredMethod("printXML", PrintStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleType.class.getDeclaredMethod("toXMLString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleType.class.getDeclaredMethod("setNames", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleType.class.getDeclaredMethod("cacheDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleType.class.getDeclaredMethod("initChildNamesRecursively", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleType.class.getDeclaredMethod("initNamesRecursively", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleType.class.getDeclaredMethod("initMetadataRecursively", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleType.class.getDeclaredMethod("getScale", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleType.class.getDeclaredMethod("getPrecision", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleType.class.getDeclaredMethod("isNCHAR", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleType.class.getDeclaredMethod("setConnection", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleType.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleType.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleType.class.getDeclaredMethod("readSerializedFields", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleType.class.getDeclaredMethod("writeSerializedFields", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleType.class.getDeclaredMethod("pickle81", PickleContext.class, Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleType.class.getDeclaredMethod("toObject", byte[].class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleType.class.getDeclaredMethod("unpickle81datumAsNull", PickleContext.class, Byte.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleType.class.getDeclaredMethod("unpickle81rec", PickleContext.class, Byte.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleType.class.getDeclaredMethod("unpickle81rec", PickleContext.class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleType.class.getDeclaredMethod("parseTDSrec", TDSReader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleType.class.getDeclaredMethod("getDBTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleType.class.getDeclaredMethod("setDBTypeCode", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleType.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleType.class.getDeclaredMethod("setTypeCode", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleType.class.getDeclaredMethod("toDatumArray", Object.class, oracle.jdbc.internal.OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleType.class.getDeclaredMethod("toDatumArrayInternal", Object.class, oracle.jdbc.internal.OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleType.class.getDeclaredMethod("toDatumInternal", Object.class, oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleType.class.getDeclaredMethod("getOracleSqlClassType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleType.class.getDeclaredMethod("getTypeDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleType.class.getDeclaredMethod("isObjectType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleType.class.getDeclaredMethod("isInHierarchyOf", StructDescriptor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleType.class.getDeclaredMethod("isInHierarchyOf", OracleType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

