/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.sql;

import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ext.sql.JavaSqlBlobSerializer;
import tools.jackson.databind.ext.sql.JavaSqlDateDeserializer;
import tools.jackson.databind.ext.sql.JavaSqlDateSerializer;
import tools.jackson.databind.ext.sql.JavaSqlTimeSerializer;
import tools.jackson.databind.ext.sql.JavaSqlTimestampDeserializer;
import tools.jackson.databind.ser.jdk.JavaUtilDateSerializer;

public class JavaSqlTypeHandlerFactory {
    public static final JavaSqlTypeHandlerFactory instance = new JavaSqlTypeHandlerFactory();
    private static final String CLS_NAME_JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String CLS_NAME_JAVA_SQL_DATE = "java.sql.Date";
    private static final String CLS_NAME_JAVA_SQL_TIME = "java.sql.Time";
    private static final String CLS_NAME_JAVA_SQL_BLOB = "java.sql.Blob";
    private static final String CLS_NAME_JAVA_SQL_SERIALBLOB = "javax.sql.rowset.serial.SerialBlob";

    protected JavaSqlTypeHandlerFactory() {
    }

    public ValueSerializer<?> findSerializer(SerializationConfig config, JavaType type) {
        switch (type.getRawClass().getName()) {
            case "java.sql.Timestamp": {
                return JavaUtilDateSerializer.instance;
            }
            case "java.sql.Date": {
                return JavaSqlDateSerializer.instance;
            }
            case "java.sql.Time": {
                return JavaSqlTimeSerializer.instance;
            }
            case "java.sql.Blob": {
                return JavaSqlBlobSerializer.instance;
            }
            case "javax.sql.rowset.serial.SerialBlob": {
                return JavaSqlBlobSerializer.instance;
            }
        }
        return null;
    }

    public ValueDeserializer<?> findDeserializer(DeserializationConfig config, JavaType type) {
        switch (type.getRawClass().getName()) {
            case "java.sql.Date": {
                return JavaSqlDateDeserializer.instance;
            }
            case "java.sql.Timestamp": {
                return JavaSqlTimestampDeserializer.instance;
            }
        }
        return null;
    }

    public boolean hasDeserializerFor(Class<?> valueType) {
        switch (valueType.getName()) {
            case "java.sql.Date": 
            case "java.sql.Timestamp": {
                return true;
            }
        }
        return false;
    }
}

