/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.AbstractInternalNode;
import com.oracle.truffle.api.strings.AbstractPublicNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.Encodings;
import com.oracle.truffle.api.strings.IndexOfCodePointSet;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.InternalErrors;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.MutableTruffleString;
import com.oracle.truffle.api.strings.NativeAllocator;
import com.oracle.truffle.api.strings.NumberConversion;
import com.oracle.truffle.api.strings.Stride;
import com.oracle.truffle.api.strings.StringAttributes;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringConstants;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringInternalNodes;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TStringOpsNodes;
import com.oracle.truffle.api.strings.TStringUnsafe;
import com.oracle.truffle.api.strings.TranscodingErrorHandler;
import com.oracle.truffle.api.strings.TruffleStringFactory;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.BitSet;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public final class TruffleString
extends AbstractTruffleString {
    static final Object ETERNAL_POINTER = new Object();
    private static final VarHandle NEXT_UPDATER = TruffleString.initializeNextUpdater();
    private static final byte FLAG_CACHE_HEAD = -128;
    TruffleString next;

    @CompilerDirectives.TruffleBoundary
    private static VarHandle initializeNextUpdater() {
        try {
            return MethodHandles.lookup().findVarHandle(TruffleString.class, "next", TruffleString.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private TruffleString(Object data, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, int hashCode, boolean isCacheHead) {
        super(data, offset, length, stride, encoding, isCacheHead ? -128 : 0, codePointLength, codeRange, hashCode);
    }

    private TruffleString(Object data, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, int hashCode, boolean isCacheHead, TruffleString cacheEntry) {
        this(data, offset, length, stride, encoding, codePointLength, codeRange, hashCode, isCacheHead);
        if (cacheEntry != null) {
            TruffleString cacheHead;
            assert (!cacheEntry.isCacheHead());
            assert (this.isCacheHead());
            assert (this.next == null);
            cacheEntry.next = cacheHead = this;
            cacheHead.next = cacheEntry;
        }
    }

    private static TruffleString create(Object data, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, int hashCode, boolean isCacheHead) {
        TruffleString string = new TruffleString(data, offset, length, stride, encoding, codePointLength, codeRange, hashCode, isCacheHead);
        if (AbstractTruffleString.DEBUG_ALWAYS_CREATE_JAVA_STRING) {
            string.toJavaStringUncached();
        }
        return string;
    }

    private static TruffleString createWithCacheEntry(Object data, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, int hashCode, TruffleString cacheEntry) {
        TruffleString string = new TruffleString(data, offset, length, stride, encoding, codePointLength, codeRange, hashCode, true, cacheEntry);
        if (AbstractTruffleString.DEBUG_ALWAYS_CREATE_JAVA_STRING) {
            string.toJavaStringUncached();
        }
        return string;
    }

    static TruffleString createFromByteArray(byte[] bytes, int length, int stride, Encoding encoding, int codePointLength, int codeRange) {
        return TruffleString.createFromByteArray(bytes, 0, length, stride, encoding, codePointLength, codeRange, true);
    }

    static TruffleString createFromByteArray(byte[] bytes, int length, int stride, Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
        return TruffleString.createFromByteArray(bytes, 0, length, stride, encoding, codePointLength, codeRange, 0, isCacheHead);
    }

    static TruffleString createFromByteArray(byte[] bytes, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
        return TruffleString.createFromByteArray(bytes, offset, length, stride, encoding, codePointLength, codeRange, 0, isCacheHead);
    }

    static TruffleString createFromByteArray(byte[] bytes, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, int hashCode, boolean isCacheHead) {
        return TruffleString.createFromArray(bytes, offset, length, stride, encoding, codePointLength, codeRange, hashCode, isCacheHead);
    }

    static TruffleString createFromArray(Object bytes, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange) {
        return TruffleString.createFromArray(bytes, offset, length, stride, encoding, codePointLength, codeRange, true);
    }

    static TruffleString createFromArray(Object bytes, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
        return TruffleString.createFromArray(bytes, offset, length, stride, encoding, codePointLength, codeRange, 0, isCacheHead);
    }

    static TruffleString createFromArray(Object bytes, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, int hashCode, boolean isCacheHead) {
        assert (bytes instanceof byte[] || TStringGuards.isInlinedJavaString(bytes) || bytes instanceof AbstractTruffleString.NativePointer);
        assert (offset >= 0);
        assert (bytes instanceof AbstractTruffleString.NativePointer || (long)offset + ((long)length << stride) <= (long)((byte[])bytes).length);
        assert (TruffleString.attrsAreCorrect(bytes, encoding, offset, length, codePointLength, codeRange, stride));
        if (DEBUG_NON_ZERO_OFFSET && bytes instanceof byte[]) {
            int byteLength;
            int add = byteLength = Math.toIntExact((long)length << stride);
            byte[] copy = new byte[add + byteLength];
            System.arraycopy(bytes, offset, copy, add, byteLength);
            return TruffleString.create(copy, add, length, stride, encoding, codePointLength, codeRange, hashCode, isCacheHead);
        }
        return TruffleString.create(bytes, offset, length, stride, encoding, codePointLength, codeRange, hashCode, isCacheHead);
    }

    static TruffleString createFromByteArrayWithCacheEntry(byte[] bytes, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, int hashCode, TruffleString cacheEntry) {
        assert (offset >= 0);
        assert ((long)offset + ((long)length << stride) <= (long)bytes.length);
        assert (TruffleString.attrsAreCorrect(bytes, encoding, offset, length, codePointLength, codeRange, stride));
        return TruffleString.createWithCacheEntry(bytes, offset, length, stride, encoding, codePointLength, codeRange, hashCode, cacheEntry);
    }

    static TruffleString createConstant(byte[] bytes, int length, int stride, Encoding encoding, int codePointLength, int codeRange) {
        return TruffleString.createConstant(bytes, length, stride, encoding, codePointLength, codeRange, true);
    }

    static TruffleString createConstant(byte[] bytes, int length, int stride, Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
        TruffleString ret = TruffleString.createFromByteArray(bytes, length, stride, encoding, codePointLength, codeRange, isCacheHead);
        ret.hashCode();
        return ret;
    }

    static TruffleString createLazyLong(long value, Encoding encoding) {
        int length = NumberConversion.stringLengthLong(value);
        int hash = HashCodeNode.maskZero(NumberConversion.computeLongStringHashCode(value));
        return TruffleString.create(new AbstractTruffleString.LazyLong(value), 0, length, 0, encoding, length, TSCodeRange.get7Bit(), hash, true);
    }

    static TruffleString createLazyConcat(TruffleString a, TruffleString b, Encoding encoding, int length, int stride, int codeRange) {
        assert (!TSCodeRange.isBrokenMultiByte(a.codeRange()));
        assert (!TSCodeRange.isBrokenMultiByte(b.codeRange()));
        assert (a.isLooselyCompatibleTo(encoding));
        assert (b.isLooselyCompatibleTo(encoding));
        assert (length == a.length() + b.length());
        return TruffleString.create(new AbstractTruffleString.LazyConcat(a, b), 0, length, stride, encoding, a.codePointLength() + b.codePointLength(), codeRange, 0, true);
    }

    static TruffleString createWrapJavaString(String str, int codePointLength, int codeRange) {
        int stride = TStringUnsafe.getJavaStringStride(str);
        int hash = TStringUnsafe.getJavaStringHashMasked(str);
        return TruffleString.create(str, 0, str.length(), stride, Encoding.UTF_16, codePointLength, codeRange, hash, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean attrsAreCorrect(Object dataA, Encoding encoding, int offset, int length, int codePointLength, int codeRange, int stride) {
        CompilerAsserts.neverPartOfCompilation();
        int knownCodeRange = TSCodeRange.getUnknownCodeRangeForEncoding(encoding.id);
        if (TStringGuards.isUTF16Or32(encoding) && stride == 0) {
            knownCodeRange = TSCodeRange.get8Bit();
        } else if (TStringGuards.isUTF32(encoding) && stride == 1) {
            knownCodeRange = TSCodeRange.get16Bit();
        }
        assert (dataA instanceof AbstractTruffleString.NativePointer || stride == Stride.fromCodeRangeAllowImprecise(codeRange, encoding));
        try {
            long addOffsetA;
            byte[] arrayA;
            if (dataA instanceof byte[]) {
                arrayA = (byte[])dataA;
                addOffsetA = TStringUnsafe.byteArrayBaseOffset();
            } else {
                arrayA = null;
                addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
            }
            long offsetA = (long)offset + addOffsetA;
            long attrs = TStringInternalNodesFactory.CalcStringAttributesNodeGen.getUncached().execute(TStringInternalNodesFactory.CalcStringAttributesNodeGen.getUncached(), null, arrayA, offsetA, length, stride, encoding, 0, knownCodeRange);
            int cpLengthCalc = StringAttributes.getCodePointLength(attrs);
            int codeRangeCalc = StringAttributes.getCodeRange(attrs);
            assert (codePointLength == -1 || cpLengthCalc == codePointLength) : "inconsistent codePointLength: " + cpLengthCalc + " != " + codePointLength;
            if (TSCodeRange.isPrecise(codeRange)) {
                assert (codeRangeCalc == codeRange) : "inconsistent codeRange: " + TSCodeRange.toString(codeRangeCalc) + " != " + TSCodeRange.toString(codeRange);
            } else assert (TSCodeRange.isMoreRestrictiveOrEqual(codeRangeCalc, codeRange)) : "imprecise codeRange more restrictive than actual codeRange: " + TSCodeRange.toString(codeRangeCalc) + " > " + TSCodeRange.toString(codeRange);
            boolean bl = true;
            return bl;
        }
        finally {
            Reference.reachabilityFence(dataA);
        }
    }

    boolean isCacheHead() {
        assert ((this.flags() & 0xFFFFFF80) != 0 == this.flags() < 0);
        return this.flags() < 0;
    }

    TruffleString getCacheHead() {
        assert (this.cacheRingIsValid());
        TruffleString cur = this.next;
        if (cur == null) {
            assert (this.isCacheHead());
            return this;
        }
        while (!cur.isCacheHead()) {
            cur = cur.next;
        }
        return cur;
    }

    @CompilerDirectives.TruffleBoundary
    void cacheInsert(TruffleString entry) {
        TruffleString cacheHeadNext;
        assert (!entry.isCacheHead());
        TruffleString cacheHead = this.getCacheHead();
        assert (!TruffleString.cacheEntryEquals(cacheHead, entry));
        do {
            if (TruffleString.hasDuplicateEncoding(cacheHead, cacheHeadNext = cacheHead.next, entry)) {
                return;
            }
            TruffleString truffleString = entry.next = cacheHeadNext == null ? cacheHead : cacheHeadNext;
        } while (!TruffleString.setNextAtomic(cacheHead, cacheHeadNext, entry));
    }

    private static boolean hasDuplicateEncoding(TruffleString cacheHead, TruffleString start, TruffleString insertEntry) {
        if (start == null) {
            return false;
        }
        TruffleString current = start;
        while (current != cacheHead) {
            if (TruffleString.cacheEntryEquals(insertEntry, current)) {
                return true;
            }
            current = current.next;
        }
        return false;
    }

    private static boolean cacheEntryEquals(TruffleString a, TruffleString b) {
        return b.encoding() == a.encoding() && a.isNative() == b.isNative() && a.stride() == b.stride() && (!TStringGuards.isUTF16(a.encoding()) || b.isJavaString() == a.isJavaString());
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean setNextAtomic(TruffleString cacheHead, TruffleString currentNext, TruffleString newNext) {
        return NEXT_UPDATER.compareAndSet(cacheHead, currentNext, newNext);
    }

    private boolean cacheRingIsValid() {
        CompilerAsserts.neverPartOfCompilation();
        TruffleString head = null;
        TruffleString cur = this;
        boolean javaStringVisited = false;
        BitSet visitedManaged = new BitSet(Encoding.values().length);
        BitSet visitedNativeRegular = new BitSet(Encoding.values().length);
        BitSet visitedNativeCompact = new BitSet(Encoding.values().length);
        EconomicSet visited = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        do {
            if (cur.isCacheHead()) {
                assert (head == null) : "multiple cache heads";
                head = cur;
            }
            if (cur.isJavaString()) {
                assert (!javaStringVisited) : "duplicate cached java string";
                javaStringVisited = true;
            } else {
                Encoding encoding = Encoding.get(cur.encoding());
                if (cur.isManaged()) {
                    assert (!visitedManaged.get(cur.encoding())) : "duplicate managed " + String.valueOf((Object)encoding);
                    visitedManaged.set(cur.encoding());
                } else if (cur.stride() == encoding.naturalStride) {
                    assert (!visitedNativeRegular.get(cur.encoding())) : "duplicate native " + String.valueOf((Object)encoding);
                    visitedNativeRegular.set(cur.encoding());
                } else {
                    assert (!visitedNativeCompact.get(cur.encoding())) : "duplicate compact native " + String.valueOf((Object)encoding);
                    visitedNativeCompact.set(cur.encoding());
                }
            }
            assert (visited.add((Object)cur)) : "not a ring structure";
        } while ((cur = cur.next) != this && cur != null);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromCodePointUncached(int codepoint, Encoding encoding) {
        return FromCodePointNode.getUncached().execute(codepoint, encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromCodePointUncached(int codepoint, Encoding encoding, boolean allowUTF16Surrogates) {
        return FromCodePointNode.getUncached().execute(codepoint, encoding, allowUTF16Surrogates);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromLongUncached(long value, Encoding encoding, boolean lazy) {
        return FromLongNode.getUncached().execute(value, encoding, lazy);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromByteArrayUncached(byte[] value, Encoding encoding) {
        return FromByteArrayNode.getUncached().execute(value, encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromByteArrayUncached(byte[] value, Encoding encoding, boolean copy) {
        return FromByteArrayNode.getUncached().execute(value, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromByteArrayUncached(byte[] value, int byteOffset, int byteLength, Encoding encoding, boolean copy) {
        return FromByteArrayNode.getUncached().execute(value, byteOffset, byteLength, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromCharArrayUTF16Uncached(char[] value) {
        return FromCharArrayUTF16Node.getUncached().execute(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromCharArrayUTF16Uncached(char[] value, int charOffset, int charLength) {
        return FromCharArrayUTF16Node.getUncached().execute(value, charOffset, charLength);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromJavaStringUncached(String s, Encoding encoding) {
        return FromJavaStringNode.getUncached().execute(s, encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromJavaStringUncached(String s, int charOffset, int length, Encoding encoding, boolean copy) {
        return FromJavaStringNode.getUncached().execute(s, charOffset, length, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromConstant(String s, Encoding encoding) {
        TruffleString string = FromJavaStringNode.getUncached().execute(s, 0, s.length(), encoding, false);
        string.getCodeRangeUncached(encoding);
        string.hashCodeUncached(encoding);
        return string;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromIntArrayUTF32Uncached(int[] value) {
        return FromIntArrayUTF32Node.getUncached().execute(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromIntArrayUTF32Uncached(int[] value, int intOffset, int intLength) {
        return FromIntArrayUTF32Node.getUncached().execute(value, intOffset, intLength);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromNativePointerUncached(Object pointerObject, int byteOffset, int byteLength, Encoding encoding, boolean copy) {
        return FromNativePointerNode.getUncached().execute(pointerObject, byteOffset, byteLength, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleString fromNativePointerEmbedder(long rawPointer, int byteOffset, int byteLength, Encoding encoding, boolean copy) {
        return TStringInternalNodesFactory.FromNativePointerEmbedderNodeGen.getUncached().execute(rawPointer, byteOffset, byteLength, encoding, copy);
    }

    private static boolean noneIsAscii(Node location, byte[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (Byte.toUnsignedInt(values[i]) <= 127) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    private static boolean noneInCodeRange(Node location, int codeRange, char[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (TSCodeRange.isInCodeRange(values[i], codeRange)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    private static boolean noneInCodeRange(Node location, int codeRange, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (TSCodeRange.isInCodeRange(values[i], codeRange)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    public TruffleString asNativeUncached(NativeAllocator allocator, Encoding expectedEncoding, boolean useCompaction, boolean cacheResult) {
        return AsNativeNode.getUncached().execute(this, allocator, expectedEncoding, useCompaction, cacheResult);
    }

    public static final class Encoding
    extends Enum<Encoding> {
        public static final /* enum */ Encoding UTF_32LE = new Encoding(TStringGuards.littleEndian() ? 0 : 99, "UTF-32LE", TStringGuards.littleEndian() ? 2 : 0, TStringGuards.littleEndian());
        public static final /* enum */ Encoding UTF_32BE = new Encoding(TStringGuards.littleEndian() ? 99 : 0, "UTF-32BE", TStringGuards.littleEndian() ? 0 : 2, TStringGuards.bigEndian());
        public static final /* enum */ Encoding UTF_16LE = new Encoding(TStringGuards.littleEndian() ? 1 : 100, "UTF-16LE", TStringGuards.littleEndian() ? 1 : 0, false);
        public static final /* enum */ Encoding UTF_16BE = new Encoding(TStringGuards.littleEndian() ? 100 : 1, "UTF-16BE", TStringGuards.littleEndian() ? 0 : 1, false);
        public static final /* enum */ Encoding ISO_8859_1 = new Encoding(2, "ISO-8859-1", 0, true);
        public static final /* enum */ Encoding UTF_8 = new Encoding(3, "UTF-8", 0, false);
        public static final /* enum */ Encoding US_ASCII = new Encoding(4, "US-ASCII", 0, true);
        public static final /* enum */ Encoding BYTES = new Encoding(5, "ASCII-8BIT", 0, true);
        public static final /* enum */ Encoding Big5 = new Encoding(6, "Big5", false);
        public static final /* enum */ Encoding Big5_HKSCS = new Encoding(7, "Big5-HKSCS", false);
        public static final /* enum */ Encoding Big5_UAO = new Encoding(8, "Big5-UAO", false);
        public static final /* enum */ Encoding CESU_8 = new Encoding(9, "CESU-8", false);
        public static final /* enum */ Encoding CP51932 = new Encoding(10, "CP51932", false);
        public static final /* enum */ Encoding CP850 = new Encoding(11, "CP850", true);
        public static final /* enum */ Encoding CP852 = new Encoding(12, "CP852", true);
        public static final /* enum */ Encoding CP855 = new Encoding(13, "CP855", true);
        public static final /* enum */ Encoding CP949 = new Encoding(14, "CP949", false);
        public static final /* enum */ Encoding CP950 = new Encoding(15, "CP950", false);
        public static final /* enum */ Encoding CP951 = new Encoding(16, "CP951", false);
        public static final /* enum */ Encoding EUC_JIS_2004 = new Encoding(17, "EUC-JIS-2004", false);
        public static final /* enum */ Encoding EUC_JP = new Encoding(18, "EUC-JP", false);
        public static final /* enum */ Encoding EUC_KR = new Encoding(19, "EUC-KR", false);
        public static final /* enum */ Encoding EUC_TW = new Encoding(20, "EUC-TW", false);
        public static final /* enum */ Encoding Emacs_Mule = new Encoding(21, "Emacs-Mule", false);
        public static final /* enum */ Encoding EucJP_ms = new Encoding(22, "eucJP-ms", false);
        public static final /* enum */ Encoding GB12345 = new Encoding(23, "GB12345", false);
        public static final /* enum */ Encoding GB18030 = new Encoding(24, "GB18030", false);
        public static final /* enum */ Encoding GB1988 = new Encoding(25, "GB1988", true);
        public static final /* enum */ Encoding GB2312 = new Encoding(26, "GB2312", false);
        public static final /* enum */ Encoding GBK = new Encoding(27, "GBK", false);
        public static final /* enum */ Encoding IBM437 = new Encoding(28, "IBM437", true);
        public static final /* enum */ Encoding IBM720 = new Encoding(29, "IBM720", true);
        public static final /* enum */ Encoding IBM737 = new Encoding(30, "IBM737", true);
        public static final /* enum */ Encoding IBM775 = new Encoding(31, "IBM775", true);
        public static final /* enum */ Encoding IBM852 = new Encoding(32, "IBM852", true);
        public static final /* enum */ Encoding IBM855 = new Encoding(33, "IBM855", true);
        public static final /* enum */ Encoding IBM857 = new Encoding(34, "IBM857", true);
        public static final /* enum */ Encoding IBM860 = new Encoding(35, "IBM860", true);
        public static final /* enum */ Encoding IBM861 = new Encoding(36, "IBM861", true);
        public static final /* enum */ Encoding IBM862 = new Encoding(37, "IBM862", true);
        public static final /* enum */ Encoding IBM863 = new Encoding(38, "IBM863", true);
        public static final /* enum */ Encoding IBM864 = new Encoding(39, "IBM864", true);
        public static final /* enum */ Encoding IBM865 = new Encoding(40, "IBM865", true);
        public static final /* enum */ Encoding IBM866 = new Encoding(41, "IBM866", true);
        public static final /* enum */ Encoding IBM869 = new Encoding(42, "IBM869", true);
        public static final /* enum */ Encoding ISO_8859_10 = new Encoding(43, "ISO-8859-10", true);
        public static final /* enum */ Encoding ISO_8859_11 = new Encoding(44, "ISO-8859-11", true);
        public static final /* enum */ Encoding ISO_8859_13 = new Encoding(45, "ISO-8859-13", true);
        public static final /* enum */ Encoding ISO_8859_14 = new Encoding(46, "ISO-8859-14", true);
        public static final /* enum */ Encoding ISO_8859_15 = new Encoding(47, "ISO-8859-15", true);
        public static final /* enum */ Encoding ISO_8859_16 = new Encoding(48, "ISO-8859-16", true);
        public static final /* enum */ Encoding ISO_8859_2 = new Encoding(49, "ISO-8859-2", true);
        public static final /* enum */ Encoding ISO_8859_3 = new Encoding(50, "ISO-8859-3", true);
        public static final /* enum */ Encoding ISO_8859_4 = new Encoding(51, "ISO-8859-4", true);
        public static final /* enum */ Encoding ISO_8859_5 = new Encoding(52, "ISO-8859-5", true);
        public static final /* enum */ Encoding ISO_8859_6 = new Encoding(53, "ISO-8859-6", true);
        public static final /* enum */ Encoding ISO_8859_7 = new Encoding(54, "ISO-8859-7", true);
        public static final /* enum */ Encoding ISO_8859_8 = new Encoding(55, "ISO-8859-8", true);
        public static final /* enum */ Encoding ISO_8859_9 = new Encoding(56, "ISO-8859-9", true);
        public static final /* enum */ Encoding KOI8_R = new Encoding(57, "KOI8-R", true);
        public static final /* enum */ Encoding KOI8_U = new Encoding(58, "KOI8-U", true);
        public static final /* enum */ Encoding MacCentEuro = new Encoding(59, "macCentEuro", true);
        public static final /* enum */ Encoding MacCroatian = new Encoding(60, "macCroatian", true);
        public static final /* enum */ Encoding MacCyrillic = new Encoding(61, "macCyrillic", true);
        public static final /* enum */ Encoding MacGreek = new Encoding(62, "macGreek", true);
        public static final /* enum */ Encoding MacIceland = new Encoding(63, "macIceland", true);
        public static final /* enum */ Encoding MacJapanese = new Encoding(64, "MacJapanese", false);
        public static final /* enum */ Encoding MacRoman = new Encoding(65, "macRoman", true);
        public static final /* enum */ Encoding MacRomania = new Encoding(66, "macRomania", true);
        public static final /* enum */ Encoding MacThai = new Encoding(67, "macThai", true);
        public static final /* enum */ Encoding MacTurkish = new Encoding(68, "macTurkish", true);
        public static final /* enum */ Encoding MacUkraine = new Encoding(69, "macUkraine", true);
        public static final /* enum */ Encoding SJIS_DoCoMo = new Encoding(70, "SJIS-DoCoMo", false);
        public static final /* enum */ Encoding SJIS_KDDI = new Encoding(71, "SJIS-KDDI", false);
        public static final /* enum */ Encoding SJIS_SoftBank = new Encoding(72, "SJIS-SoftBank", false);
        public static final /* enum */ Encoding Shift_JIS = new Encoding(73, "Shift_JIS", false);
        public static final /* enum */ Encoding Stateless_ISO_2022_JP = new Encoding(74, "stateless-ISO-2022-JP", false);
        public static final /* enum */ Encoding Stateless_ISO_2022_JP_KDDI = new Encoding(75, "stateless-ISO-2022-JP-KDDI", false);
        public static final /* enum */ Encoding TIS_620 = new Encoding(76, "TIS-620", true);
        public static final /* enum */ Encoding UTF8_DoCoMo = new Encoding(77, "UTF8-DoCoMo", false);
        public static final /* enum */ Encoding UTF8_KDDI = new Encoding(78, "UTF8-KDDI", false);
        public static final /* enum */ Encoding UTF8_MAC = new Encoding(79, "UTF8-MAC", false);
        public static final /* enum */ Encoding UTF8_SoftBank = new Encoding(80, "UTF8-SoftBank", false);
        public static final /* enum */ Encoding Windows_1250 = new Encoding(81, "Windows-1250", true);
        public static final /* enum */ Encoding Windows_1251 = new Encoding(82, "Windows-1251", true);
        public static final /* enum */ Encoding Windows_1252 = new Encoding(83, "Windows-1252", true);
        public static final /* enum */ Encoding Windows_1253 = new Encoding(84, "Windows-1253", true);
        public static final /* enum */ Encoding Windows_1254 = new Encoding(85, "Windows-1254", true);
        public static final /* enum */ Encoding Windows_1255 = new Encoding(86, "Windows-1255", true);
        public static final /* enum */ Encoding Windows_1256 = new Encoding(87, "Windows-1256", true);
        public static final /* enum */ Encoding Windows_1257 = new Encoding(88, "Windows-1257", true);
        public static final /* enum */ Encoding Windows_1258 = new Encoding(89, "Windows-1258", true);
        public static final /* enum */ Encoding Windows_31J = new Encoding(90, "Windows-31J", false);
        public static final /* enum */ Encoding Windows_874 = new Encoding(91, "Windows-874", true);
        public static final /* enum */ Encoding CP50220 = new Encoding(92, "CP50220", true);
        public static final /* enum */ Encoding CP50221 = new Encoding(93, "CP50221", true);
        public static final /* enum */ Encoding IBM037 = new Encoding(94, "IBM037", true);
        public static final /* enum */ Encoding ISO_2022_JP = new Encoding(95, "ISO-2022-JP", true);
        public static final /* enum */ Encoding ISO_2022_JP_2 = new Encoding(96, "ISO-2022-JP-2", true);
        public static final /* enum */ Encoding ISO_2022_JP_KDDI = new Encoding(97, "ISO-2022-JP-KDDI", true);
        public static final /* enum */ Encoding UTF_7 = new Encoding(98, "UTF-7", true);
        public static final Encoding UTF_32;
        public static final Encoding UTF_16;
        static final Encoding UTF_32_FOREIGN_ENDIAN;
        static final Encoding UTF_16_FOREIGN_ENDIAN;
        final byte id;
        final String jCodingName;
        final byte maxCompatibleCodeRange;
        final byte naturalStride;
        final boolean fixedWidth;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        static final byte[] EMPTY_BYTES;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final Encoding[] ENCODINGS_TABLE;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final byte[] MAX_COMPATIBLE_CODE_RANGE;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final TruffleString[] EMPTY_STRINGS;
        private static final /* synthetic */ Encoding[] $VALUES;

        public static Encoding[] values() {
            return (Encoding[])$VALUES.clone();
        }

        public static Encoding valueOf(String name) {
            return Enum.valueOf(Encoding.class, name);
        }

        private Encoding(int id, String jCodingName, boolean fixedWidth) {
            this(id, jCodingName, 0, fixedWidth);
        }

        private Encoding(int id, String jCodingName, int naturalStride, boolean fixedWidth) {
            assert (id <= 127) : id;
            assert (Stride.isStride(naturalStride)) : naturalStride;
            this.id = (byte)id;
            this.jCodingName = jCodingName;
            this.maxCompatibleCodeRange = this.is16BitCompatible() ? (byte)(TSCodeRange.get16Bit() + 1) : (this.is8BitCompatible() ? (byte)(TSCodeRange.get8Bit() + 1) : (this.is7BitCompatible() ? (byte)(TSCodeRange.get7Bit() + 1) : (byte)0));
            this.naturalStride = (byte)naturalStride;
            this.fixedWidth = fixedWidth;
        }

        private static TruffleString createEmpty(Encoding encoding) {
            if (encoding.is7BitCompatible() && !AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS || encoding == US_ASCII) {
                return EMPTY_STRINGS[Encoding.US_ASCII.id];
            }
            TruffleString ret = TruffleString.createConstant(EMPTY_BYTES, 0, 0, encoding, 0, TSCodeRange.getAsciiCodeRange(encoding), false);
            EMPTY_STRINGS[Encoding.US_ASCII.id].cacheInsert(ret);
            return ret;
        }

        public TruffleString getEmpty() {
            TruffleString emptyString = EMPTY_STRINGS[this.id];
            assert (emptyString != null) : this;
            return emptyString;
        }

        @CompilerDirectives.TruffleBoundary
        public static Encoding fromJCodingName(String name) {
            Encoding encoding = JCodings.fromJCodingsName(name);
            if (encoding == null) {
                throw InternalErrors.unknownEncoding(name);
            }
            return encoding;
        }

        static Encoding get(int encoding) {
            return ENCODINGS_TABLE[encoding];
        }

        static int getMaxCompatibleCodeRange(int encoding) {
            return MAX_COMPATIBLE_CODE_RANGE[encoding];
        }

        boolean is7BitCompatible() {
            return Encoding.is7BitCompatible(this.id);
        }

        boolean is8BitCompatible() {
            return Encoding.is8BitCompatible(this.id);
        }

        boolean is16BitCompatible() {
            return Encoding.is16BitCompatible(this.id);
        }

        boolean isSupported() {
            return Encoding.isSupported(this.id);
        }

        boolean isUnsupported() {
            return Encoding.isUnsupported(this.id);
        }

        static boolean is7BitCompatible(int encoding) {
            return encoding < 92;
        }

        static boolean is8BitCompatible(int encoding) {
            return encoding < 3;
        }

        static boolean is16BitCompatible(int encoding) {
            return encoding < 2;
        }

        static boolean isSupportedWithCompaction(int encoding) {
            return encoding < 6;
        }

        static boolean isSupported(int encoding) {
            return encoding < 6 || encoding > 98;
        }

        static boolean isUnsupported(int encoding) {
            return encoding >= 6 && encoding < 99;
        }

        boolean isFixedWidth() {
            return this.fixedWidth;
        }

        static boolean isFixedWidth(int encoding) {
            return Encoding.get(encoding).isFixedWidth();
        }

        boolean isSingleByte() {
            return this.fixedWidth && this.naturalStride == 0;
        }

        private static /* synthetic */ Encoding[] $values() {
            return new Encoding[]{UTF_32LE, UTF_32BE, UTF_16LE, UTF_16BE, ISO_8859_1, UTF_8, US_ASCII, BYTES, Big5, Big5_HKSCS, Big5_UAO, CESU_8, CP51932, CP850, CP852, CP855, CP949, CP950, CP951, EUC_JIS_2004, EUC_JP, EUC_KR, EUC_TW, Emacs_Mule, EucJP_ms, GB12345, GB18030, GB1988, GB2312, GBK, IBM437, IBM720, IBM737, IBM775, IBM852, IBM855, IBM857, IBM860, IBM861, IBM862, IBM863, IBM864, IBM865, IBM866, IBM869, ISO_8859_10, ISO_8859_11, ISO_8859_13, ISO_8859_14, ISO_8859_15, ISO_8859_16, ISO_8859_2, ISO_8859_3, ISO_8859_4, ISO_8859_5, ISO_8859_6, ISO_8859_7, ISO_8859_8, ISO_8859_9, KOI8_R, KOI8_U, MacCentEuro, MacCroatian, MacCyrillic, MacGreek, MacIceland, MacJapanese, MacRoman, MacRomania, MacThai, MacTurkish, MacUkraine, SJIS_DoCoMo, SJIS_KDDI, SJIS_SoftBank, Shift_JIS, Stateless_ISO_2022_JP, Stateless_ISO_2022_JP_KDDI, TIS_620, UTF8_DoCoMo, UTF8_KDDI, UTF8_MAC, UTF8_SoftBank, Windows_1250, Windows_1251, Windows_1252, Windows_1253, Windows_1254, Windows_1255, Windows_1256, Windows_1257, Windows_1258, Windows_31J, Windows_874, CP50220, CP50221, IBM037, ISO_2022_JP, ISO_2022_JP_2, ISO_2022_JP_KDDI, UTF_7};
        }

        static {
            $VALUES = Encoding.$values();
            UTF_32 = TStringGuards.littleEndian() ? UTF_32LE : UTF_32BE;
            UTF_16 = TStringGuards.littleEndian() ? UTF_16LE : UTF_16BE;
            UTF_32_FOREIGN_ENDIAN = TStringGuards.littleEndian() ? UTF_32BE : UTF_32LE;
            UTF_16_FOREIGN_ENDIAN = TStringGuards.littleEndian() ? UTF_16BE : UTF_16LE;
            EMPTY_BYTES = new byte[0];
            Encoding[] encodingValues = Encoding.values();
            ENCODINGS_TABLE = new Encoding[encodingValues.length];
            MAX_COMPATIBLE_CODE_RANGE = new byte[encodingValues.length];
            for (Encoding e : encodingValues) {
                assert (ENCODINGS_TABLE[e.id] == null);
                Encoding.ENCODINGS_TABLE[e.id] = e;
                Encoding.MAX_COMPATIBLE_CODE_RANGE[e.id] = e.maxCompatibleCodeRange;
            }
            assert (Encoding.UTF_16.naturalStride == 1);
            assert (Encoding.UTF_32.naturalStride == 2);
            EMPTY_STRINGS = new TruffleString[encodingValues.length];
            Encoding.EMPTY_STRINGS[Encoding.US_ASCII.id] = TruffleString.createConstant(EMPTY_BYTES, 0, 0, US_ASCII, 0, TSCodeRange.get7Bit());
            for (Encoding e : encodingValues) {
                if (e == US_ASCII) continue;
                assert (EMPTY_STRINGS[e.id] == null);
                Encoding.EMPTY_STRINGS[e.id] = Encoding.createEmpty(e);
            }
        }
    }

    public static abstract class HashCodeNode
    extends AbstractPublicNode {
        HashCodeNode() {
        }

        public abstract int execute(AbstractTruffleString var1, Encoding var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int calculateHash(AbstractTruffleString a, Encoding expectedEncoding, @Cached InlinedConditionProfile cacheMiss, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringOpsNodes.CalculateHashCodeNode calculateHashCodeNode) {
            a.checkEncoding(expectedEncoding);
            int h = a.hashCode;
            if (cacheMiss.profile(this, h == 0)) {
                Object dataA = a.data();
                try {
                    long addOffsetA;
                    byte[] arrayA;
                    if (managedProfileA.profile(this, dataA instanceof byte[])) {
                        arrayA = (byte[])dataA;
                        addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                    } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                        arrayA = null;
                        addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                    } else {
                        arrayA = a.materializeLazy(this, dataA);
                        addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                    }
                    long offsetA = (long)a.offset() + addOffsetA;
                    h = a.setHashCode(HashCodeNode.maskZero(calculateHashCodeNode.execute(this, a, arrayA, offsetA)));
                }
                finally {
                    Reference.reachabilityFence(dataA);
                }
            }
            return h;
        }

        static int maskZero(int rawHashCode) {
            int h = rawHashCode;
            if (h == 0) assert (--h == -1);
            return h;
        }

        @NeverDefault
        public static HashCodeNode create() {
            return TruffleStringFactory.HashCodeNodeGen.create();
        }

        public static HashCodeNode getUncached() {
            return TruffleStringFactory.HashCodeNodeGen.getUncached();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int calculateHashCodeUncached(AbstractTruffleString a) {
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (dataA instanceof byte[]) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (dataA instanceof AbstractTruffleString.NativePointer) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(HashCodeNode.getUncached(), dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int n = a.setHashCode(HashCodeNode.maskZero(TStringOps.hashCodeWithStride(HashCodeNode.getUncached(), a, arrayA, offsetA, a.stride())));
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }
    }

    public static abstract class FromCodePointNode
    extends AbstractPublicNode {
        FromCodePointNode() {
        }

        public final TruffleString execute(int codepoint, Encoding encoding) {
            return this.execute(codepoint, encoding, encoding == Encoding.UTF_16);
        }

        public abstract TruffleString execute(int var1, Encoding var2, boolean var3);

        /*
         * Enabled aggressive block sorting
         */
        @Specialization
        final TruffleString fromCodePoint(int c, Encoding enc, boolean allowUTF16Surrogates, @Cached InlinedConditionProfile bytesProfile, @Cached InlinedConditionProfile utf8Profile, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16FEProfile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32FEProfile, @Cached InlinedConditionProfile exoticProfile, @Cached InlinedConditionProfile bmpProfile, @Cached InlinedBranchProfile invalidCodePoint) {
            int codeRange;
            int stride;
            int length;
            byte[] bytes;
            assert (!allowUTF16Surrogates || TStringGuards.isUTF16Or32(enc) || TStringGuards.isUTF16FE(enc) || TStringGuards.isUTF32FE(enc)) : "allowUTF16Surrogates is only supported on UTF-16 and UTF-32";
            CompilerAsserts.partialEvaluationConstant(allowUTF16Surrogates);
            if (TStringGuards.is7BitCompatible(enc) && Integer.compareUnsigned(c, 127) <= 0) {
                return TStringConstants.getSingleByteAscii(enc, c);
            }
            if (TStringGuards.is8BitCompatible(enc) && Integer.compareUnsigned(c, 255) <= 0) {
                if ($assertionsDisabled) return TStringConstants.getSingleByte(enc, c);
                if (TStringGuards.isSupportedEncoding(enc)) return TStringConstants.getSingleByte(enc, c);
                throw new AssertionError();
            }
            if (bytesProfile.profile(this, TStringGuards.isBytes(enc))) {
                if (Integer.compareUnsigned(c, 255) <= 0) return TStringConstants.getSingleByte(Encoding.BYTES, c);
                invalidCodePoint.enter(this);
                return null;
            }
            if (utf8Profile.profile(this, TStringGuards.isUTF8(enc))) {
                if (!Encodings.isValidUnicodeCodepoint(c)) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                assert (c > 127);
                bytes = Encodings.utf8Encode(c);
                length = bytes.length;
                stride = 0;
                codeRange = TSCodeRange.getValidMultiByte();
                return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
            }
            if (utf16Profile.profile(this, TStringGuards.isUTF16(enc))) {
                if (Integer.toUnsignedLong(c) > 0x10FFFFL) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                assert (c > 255);
                bytes = new byte[c <= 65535 ? 2 : 4];
                stride = 1;
                if (!bmpProfile.profile(this, c <= 65535)) {
                    length = 2;
                    codeRange = TSCodeRange.getValidMultiByte();
                    Encodings.utf16EncodeSurrogatePair(c, bytes, 0);
                    return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
                }
                length = 1;
                if (Encodings.isUTF16Surrogate(c)) {
                    if (!allowUTF16Surrogates) {
                        invalidCodePoint.enter(this);
                        return null;
                    }
                    codeRange = TSCodeRange.getBrokenMultiByte();
                } else {
                    codeRange = TSCodeRange.get16Bit();
                }
                TStringOps.writeToByteArrayS1(bytes, 0, c);
                return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
            }
            if (utf32Profile.profile(this, TStringGuards.isUTF32(enc))) {
                if (Integer.toUnsignedLong(c) > 0x10FFFFL) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                assert (c > 255);
                if (c <= 65535) {
                    if (Encodings.isUTF16Surrogate(c)) {
                        if (!allowUTF16Surrogates) {
                            invalidCodePoint.enter(this);
                            return null;
                        }
                        codeRange = TSCodeRange.getBrokenFixedWidth();
                    } else {
                        codeRange = TSCodeRange.get16Bit();
                    }
                } else {
                    codeRange = TSCodeRange.getValidFixedWidth();
                }
                boolean compact1 = TSCodeRange.is16Bit(codeRange);
                bytes = new byte[compact1 ? 2 : 4];
                length = 1;
                if (bmpProfile.profile(this, compact1)) {
                    stride = 1;
                    TStringOps.writeToByteArrayS1(bytes, 0, c);
                    return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
                }
                stride = 2;
                TStringOps.writeToByteArrayS2(bytes, 0, c);
                return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
            }
            if (utf16FEProfile.profile(this, TStringGuards.isUTF16FE(enc))) {
                if (Integer.toUnsignedLong(c) > 0x10FFFFL) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                bytes = new byte[c <= 65535 ? 2 : 4];
                stride = 0;
                if (!bmpProfile.profile(this, c <= 65535)) {
                    length = 4;
                    codeRange = TSCodeRange.getValidMultiByte();
                    Encodings.utf16FEEncodeSurrogatePair(c, bytes, 0);
                    return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
                }
                length = 2;
                if (Encodings.isUTF16Surrogate(c)) {
                    if (!allowUTF16Surrogates) {
                        invalidCodePoint.enter(this);
                        return null;
                    }
                    codeRange = TSCodeRange.getBrokenMultiByte();
                } else {
                    codeRange = TSCodeRange.getValidMultiByte();
                }
                TStringOps.writeToByteArrayS1(bytes, 0, Character.reverseBytes((char)c));
                return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
            }
            if (utf32FEProfile.profile(this, TStringGuards.isUTF32FE(enc))) {
                if (Integer.toUnsignedLong(c) > 0x10FFFFL) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                if (Encodings.isUTF16Surrogate(c)) {
                    if (!allowUTF16Surrogates) {
                        invalidCodePoint.enter(this);
                        return null;
                    }
                    codeRange = TSCodeRange.getBrokenMultiByte();
                } else {
                    codeRange = TSCodeRange.getValidMultiByte();
                }
                bytes = new byte[4];
                length = 4;
                stride = 0;
                TStringOps.writeToByteArrayS2(bytes, 0, Integer.reverseBytes(c));
                return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
            }
            if (exoticProfile.profile(this, TStringGuards.isUnsupportedEncoding(enc))) {
                assert (!TStringGuards.isBytes(enc));
                length = JCodings.getInstance().getCodePointLength(enc, c);
                stride = 0;
                codeRange = TSCodeRange.getValid(JCodings.getInstance().isSingleByte(enc));
                if (length < 1) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                bytes = new byte[length];
                int ret = JCodings.getInstance().writeCodePoint(enc, c, bytes, 0);
                if (ret == length && JCodings.getInstance().getCodePointLength(enc, bytes, 0, length) == ret) {
                    if (JCodings.getInstance().readCodePoint(enc, bytes, 0, length, DecodingErrorHandler.RETURN_NEGATIVE) == c) return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
                }
                invalidCodePoint.enter(this);
                return null;
            }
            if (!($assertionsDisabled || TStringGuards.isAscii(enc) && Integer.compareUnsigned(c, 127) > 0)) {
                if (!TStringGuards.isLatin1(enc)) throw new AssertionError();
                if (Integer.compareUnsigned(c, 255) <= 0) {
                    throw new AssertionError();
                }
            }
            invalidCodePoint.enter(this);
            return null;
        }

        @NeverDefault
        public static FromCodePointNode create() {
            return TruffleStringFactory.FromCodePointNodeGen.create();
        }

        public static FromCodePointNode getUncached() {
            return TruffleStringFactory.FromCodePointNodeGen.getUncached();
        }
    }

    public static abstract class FromLongNode
    extends AbstractPublicNode {
        FromLongNode() {
        }

        public abstract TruffleString execute(long var1, Encoding var3, boolean var4);

        @Specialization(guards={"is7BitCompatible(enc)", "lazy"})
        static TruffleString doLazy(long value, Encoding enc, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            return TruffleString.createLazyLong(value, enc);
        }

        @Specialization(guards={"is7BitCompatible(enc)", "!lazy"})
        static TruffleString doEager(long value, Encoding enc, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            int length = NumberConversion.stringLengthLong(value);
            int hash = HashCodeNode.maskZero(NumberConversion.computeLongStringHashCode(value));
            return TruffleString.createFromByteArray(NumberConversion.longToString(value, length), 0, length, 0, enc, length, TSCodeRange.get7Bit(), hash, true);
        }

        @Specialization(guards={"!is7BitCompatible(enc)"})
        static TruffleString unsupported(long value, Encoding enc, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            throw InternalErrors.unsupportedOperation(FromLongNode.nonAsciiCompatibleMessage(enc));
        }

        @CompilerDirectives.TruffleBoundary
        private static String nonAsciiCompatibleMessage(Encoding enc) {
            return "Encoding " + String.valueOf((Object)enc) + " is not ASCII-compatible";
        }

        @NeverDefault
        public static FromLongNode create() {
            return TruffleStringFactory.FromLongNodeGen.create();
        }

        public static FromLongNode getUncached() {
            return TruffleStringFactory.FromLongNodeGen.getUncached();
        }
    }

    public static abstract class FromByteArrayNode
    extends AbstractPublicNode {
        FromByteArrayNode() {
        }

        public final TruffleString execute(byte[] value, Encoding encoding) {
            return this.execute(value, encoding, true);
        }

        public final TruffleString execute(byte[] value, Encoding encoding, boolean copy) {
            return this.execute(value, 0, value.length, encoding, copy);
        }

        public abstract TruffleString execute(byte[] var1, int var2, int var3, Encoding var4, boolean var5);

        @Specialization
        final TruffleString fromByteArray(byte[] value, int byteOffset, int byteLength, Encoding enc, boolean copy, @Cached TStringInternalNodes.FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            AbstractTruffleString.checkArrayRange(value, byteOffset, byteLength);
            return fromBufferWithStringCompactionNode.execute(this, value, byteOffset, byteLength, enc, copy, true);
        }

        @NeverDefault
        public static FromByteArrayNode create() {
            return TruffleStringFactory.FromByteArrayNodeGen.create();
        }

        public static FromByteArrayNode getUncached() {
            return TruffleStringFactory.FromByteArrayNodeGen.getUncached();
        }
    }

    public static abstract class FromCharArrayUTF16Node
    extends AbstractPublicNode {
        FromCharArrayUTF16Node() {
        }

        public final TruffleString execute(char[] value) {
            return this.execute(value, 0, value.length);
        }

        public abstract TruffleString execute(char[] var1, int var2, int var3);

        @Specialization
        final TruffleString doNonEmpty(char[] value, int charOffset, int charLength, @Cached InlinedConditionProfile utf16CompactProfile, @Cached InlinedBranchProfile outOfMemoryProfile) {
            AbstractTruffleString.checkArrayRange(value.length, charOffset, charLength);
            if (charLength == 0) {
                return Encoding.UTF_16.getEmpty();
            }
            if (charLength == 1 && value[charOffset] <= '\u00ff') {
                return TStringConstants.getSingleByte(Encoding.UTF_16, value[charOffset]);
            }
            long offsetV = ((long)charOffset << 1) + (long)TStringUnsafe.charArrayBaseOffset();
            if (value.length > 0x3FFFFFFB) {
                outOfMemoryProfile.enter(this);
                throw InternalErrors.outOfMemory();
            }
            long attrs = TStringOps.calcStringAttributesUTF16C(this, value, offsetV, charLength);
            int codePointLength = StringAttributes.getCodePointLength(attrs);
            int codeRange = StringAttributes.getCodeRange(attrs);
            int stride = Stride.fromCodeRangeUTF16(codeRange);
            byte[] array = new byte[charLength << stride];
            if (utf16CompactProfile.profile(this, stride == 0)) {
                TStringOps.arraycopyWithStrideCB(this, value, offsetV, array, TStringUnsafe.byteArrayBaseOffset(), 0, charLength);
            } else {
                TStringOps.arraycopyWithStrideCB(this, value, offsetV, array, TStringUnsafe.byteArrayBaseOffset(), 1, charLength);
            }
            return TruffleString.createFromByteArray(array, charLength, stride, Encoding.UTF_16, codePointLength, codeRange);
        }

        @NeverDefault
        public static FromCharArrayUTF16Node create() {
            return TruffleStringFactory.FromCharArrayUTF16NodeGen.create();
        }

        public static FromCharArrayUTF16Node getUncached() {
            return TruffleStringFactory.FromCharArrayUTF16NodeGen.getUncached();
        }
    }

    public static abstract class FromJavaStringNode
    extends AbstractPublicNode {
        FromJavaStringNode() {
        }

        public final TruffleString execute(String value, Encoding encoding) {
            return this.execute(value, 0, value.length(), encoding, false);
        }

        public abstract TruffleString execute(String var1, int var2, int var3, Encoding var4, boolean var5);

        @Specialization
        final TruffleString doUTF16(String javaString, int charOffset, int length, Encoding encoding, boolean copy, @Cached TStringInternalNodes.FromJavaStringUTF16Node fromJavaStringUTF16Node, @Cached InternalSwitchEncodingNode switchEncodingNode, @Cached InlinedConditionProfile utf16Profile) {
            if (javaString.isEmpty()) {
                return encoding.getEmpty();
            }
            TruffleString utf16String = fromJavaStringUTF16Node.execute(this, javaString, charOffset, length, copy);
            if (utf16Profile.profile(this, encoding == Encoding.UTF_16)) {
                return utf16String;
            }
            return switchEncodingNode.execute(this, utf16String, encoding, TranscodingErrorHandler.DEFAULT);
        }

        @NeverDefault
        public static FromJavaStringNode create() {
            return TruffleStringFactory.FromJavaStringNodeGen.create();
        }

        public static FromJavaStringNode getUncached() {
            return TruffleStringFactory.FromJavaStringNodeGen.getUncached();
        }
    }

    public static final class CodeRange
    extends Enum<CodeRange> {
        public static final /* enum */ CodeRange ASCII = new CodeRange();
        public static final /* enum */ CodeRange LATIN_1 = new CodeRange();
        public static final /* enum */ CodeRange BMP = new CodeRange();
        public static final /* enum */ CodeRange VALID = new CodeRange();
        public static final /* enum */ CodeRange BROKEN = new CodeRange();
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final CodeRange[] BYTE_CODE_RANGES;
        private static final /* synthetic */ CodeRange[] $VALUES;

        public static CodeRange[] values() {
            return (CodeRange[])$VALUES.clone();
        }

        public static CodeRange valueOf(String name) {
            return Enum.valueOf(CodeRange.class, name);
        }

        public boolean isSubsetOf(CodeRange other) {
            return this.ordinal() <= other.ordinal();
        }

        public boolean isSupersetOf(CodeRange other) {
            return this.ordinal() >= other.ordinal();
        }

        static CodeRange get(int codeRange) {
            assert (TSCodeRange.ordinal(TSCodeRange.get7Bit()) == 0);
            assert (TSCodeRange.ordinal(TSCodeRange.get8Bit()) == 1);
            assert (TSCodeRange.ordinal(TSCodeRange.get16Bit()) == 2);
            assert (TSCodeRange.ordinal(TSCodeRange.getValidFixedWidth()) == 3);
            assert (TSCodeRange.ordinal(TSCodeRange.getValidMultiByte()) == 3);
            assert (TSCodeRange.ordinal(TSCodeRange.getBrokenFixedWidth()) == 4);
            assert (TSCodeRange.ordinal(TSCodeRange.getBrokenMultiByte()) == 4);
            int ordinal = TSCodeRange.ordinal(codeRange);
            switch (ordinal) {
                case 0: {
                    return ASCII;
                }
                case 1: {
                    return LATIN_1;
                }
                case 2: {
                    return BMP;
                }
                case 3: {
                    return VALID;
                }
            }
            assert (ordinal == 4);
            return BROKEN;
        }

        static CodeRange getByteCodeRange(int codeRange, Encoding encoding) {
            return TSCodeRange.is7Bit(codeRange) && TStringGuards.isUTF16Or32(encoding) ? VALID : BYTE_CODE_RANGES[TSCodeRange.ordinal(codeRange)];
        }

        static boolean equals(int codeRange, CodeRange codeRangeEnum) {
            return TSCodeRange.ordinal(codeRange) == codeRangeEnum.ordinal();
        }

        private static /* synthetic */ CodeRange[] $values() {
            return new CodeRange[]{ASCII, LATIN_1, BMP, VALID, BROKEN};
        }

        static {
            $VALUES = CodeRange.$values();
            BYTE_CODE_RANGES = new CodeRange[]{ASCII, VALID, VALID, VALID, BROKEN};
            assert (CodeRange.get(TSCodeRange.get7Bit()) == ASCII);
            assert (CodeRange.get(TSCodeRange.get8Bit()) == LATIN_1);
            assert (CodeRange.get(TSCodeRange.get16Bit()) == BMP);
            assert (CodeRange.get(TSCodeRange.getValidFixedWidth()) == VALID);
            assert (CodeRange.get(TSCodeRange.getBrokenFixedWidth()) == BROKEN);
            assert (CodeRange.get(TSCodeRange.getValidMultiByte()) == VALID);
            assert (CodeRange.get(TSCodeRange.getBrokenMultiByte()) == BROKEN);
            assert (CodeRange.equals(TSCodeRange.get7Bit(), ASCII));
            assert (CodeRange.equals(TSCodeRange.get8Bit(), LATIN_1));
            assert (CodeRange.equals(TSCodeRange.get16Bit(), BMP));
            assert (CodeRange.equals(TSCodeRange.getValidFixedWidth(), VALID));
            assert (CodeRange.equals(TSCodeRange.getBrokenFixedWidth(), BROKEN));
            assert (CodeRange.equals(TSCodeRange.getValidMultiByte(), VALID));
            assert (CodeRange.equals(TSCodeRange.getBrokenMultiByte(), BROKEN));
        }
    }

    public static abstract class FromIntArrayUTF32Node
    extends AbstractPublicNode {
        FromIntArrayUTF32Node() {
        }

        public final TruffleString execute(int[] value) {
            return this.execute(value, 0, value.length);
        }

        public abstract TruffleString execute(int[] var1, int var2, int var3);

        @Specialization
        final TruffleString doNonEmpty(int[] value, int intOffset, int length, @Cached InlinedConditionProfile utf32Compact0Profile, @Cached InlinedConditionProfile utf32Compact1Profile, @Cached InlinedBranchProfile outOfMemoryProfile) {
            AbstractTruffleString.checkArrayRange(value.length, intOffset, length);
            if (length == 0) {
                return Encoding.UTF_32.getEmpty();
            }
            if (length == 1 && Integer.compareUnsigned(value[intOffset], 255) <= 0) {
                return TStringConstants.getSingleByte(Encoding.UTF_32, value[intOffset]);
            }
            long offsetV = ((long)intOffset << 2) + (long)TStringUnsafe.intArrayBaseOffset();
            if (length > 0x1FFFFFFD) {
                outOfMemoryProfile.enter(this);
                throw InternalErrors.outOfMemory();
            }
            int codeRange = TStringOps.calcStringAttributesUTF32I(this, value, offsetV, length);
            int stride = Stride.fromCodeRangeUTF32(codeRange);
            byte[] array = new byte[length << stride];
            if (utf32Compact0Profile.profile(this, stride == 0)) {
                TStringOps.arraycopyWithStrideIB(this, value, offsetV, array, TStringUnsafe.byteArrayBaseOffset(), 0, length);
            } else if (utf32Compact1Profile.profile(this, stride == 1)) {
                TStringOps.arraycopyWithStrideIB(this, value, offsetV, array, TStringUnsafe.byteArrayBaseOffset(), 1, length);
            } else {
                TStringOps.arraycopyWithStrideIB(this, value, offsetV, array, TStringUnsafe.byteArrayBaseOffset(), 2, length);
            }
            return TruffleString.createFromByteArray(array, length, stride, Encoding.UTF_32, length, codeRange);
        }

        @NeverDefault
        public static FromIntArrayUTF32Node create() {
            return TruffleStringFactory.FromIntArrayUTF32NodeGen.create();
        }

        public static FromIntArrayUTF32Node getUncached() {
            return TruffleStringFactory.FromIntArrayUTF32NodeGen.getUncached();
        }
    }

    public static abstract class FromNativePointerNode
    extends AbstractPublicNode {
        FromNativePointerNode() {
        }

        public abstract TruffleString execute(Object var1, int var2, int var3, Encoding var4, boolean var5);

        @Specialization
        final TruffleString fromNativePointer(Object pointerObject, int byteOffset, int byteLength, Encoding enc, boolean copy, @Cached(value="createInteropLibrary()", uncached="getUncachedInteropLibrary()") Node interopLibrary, @Cached TStringInternalNodes.FromNativePointerNode fromNativePointerNode, @Cached TStringInternalNodes.FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            AbstractTruffleString.NativePointer pointer = AbstractTruffleString.NativePointer.create(this, pointerObject, interopLibrary);
            if (copy) {
                return fromBufferWithStringCompactionNode.execute(this, pointer, byteOffset, byteLength, enc, true, true);
            }
            return fromNativePointerNode.execute(this, pointer, byteOffset, byteLength, enc, true);
        }

        @NeverDefault
        public static FromNativePointerNode create() {
            return TruffleStringFactory.FromNativePointerNodeGen.create();
        }

        public static FromNativePointerNode getUncached() {
            return TruffleStringFactory.FromNativePointerNodeGen.getUncached();
        }
    }

    public static abstract class AsNativeNode
    extends AbstractPublicNode {
        private static final int NULL_TERMINATION_BYTES = 4;

        AsNativeNode() {
        }

        public abstract TruffleString execute(TruffleString var1, NativeAllocator var2, Encoding var3, boolean var4, boolean var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static TruffleString asNative(TruffleString a, NativeAllocator allocator, Encoding encoding, boolean useCompaction, boolean cacheResult, @Bind Node node, @Cached(value="createInteropLibrary()", uncached="getUncachedInteropLibrary()") Node interopLibrary, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedConditionProfile cacheHit, @Cached InlinedIntValueProfile inflateStrideProfile, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode) {
            a.checkEncoding(encoding);
            CompilerAsserts.partialEvaluationConstant(allocator);
            CompilerAsserts.partialEvaluationConstant(useCompaction);
            CompilerAsserts.partialEvaluationConstant(cacheResult);
            int strideA = inflateStrideProfile.profile(node, a.stride());
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(node, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getPreciseCodeRangeNode.execute(node, a, arrayA, offsetA, encoding);
                if (isNativeProfile.profile(node, a.isNative() && strideA == (useCompaction ? Stride.fromCodeRange(codeRangeA, encoding) : encoding.naturalStride))) {
                    TruffleString truffleString = a;
                    return truffleString;
                }
                TruffleString cur = a.next;
                assert (!a.isJavaString());
                if (cacheResult && cur != null) {
                    while (!(cur == a || cur.isNative() && cur.isCompatibleToIntl(encoding) && cur.stride() == (useCompaction ? strideA : (int)encoding.naturalStride))) {
                        cur = cur.next;
                    }
                    if (cacheHit.profile(node, cur != a)) {
                        assert (cur.isCompatibleToIntl(encoding) && cur.isNative() && !cur.isJavaString() && cur.stride() == (useCompaction ? strideA : (int)encoding.naturalStride));
                        TruffleString truffleString = cur;
                        return truffleString;
                    }
                }
                int length = a.length();
                int stride = useCompaction ? Stride.fromCodeRange(codeRangeA, encoding) : encoding.naturalStride;
                int byteSize = length << stride;
                Object buffer = allocator.allocate(byteSize + 4);
                AbstractTruffleString.NativePointer nativePointer = AbstractTruffleString.NativePointer.create(node, buffer, interopLibrary);
                try {
                    if (useCompaction) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, strideA, 0, null, nativePointer.pointer, stride, 0, length);
                    } else if (TStringGuards.isUTF16(encoding)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, strideA, 0, null, nativePointer.pointer, 1, 0, length);
                    } else if (TStringGuards.isUTF32(encoding)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, strideA, 0, null, nativePointer.pointer, 2, 0, length);
                    } else {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, 0, null, nativePointer.pointer, 0, 0, byteSize);
                    }
                    AsNativeNode.checkIntSize();
                    TStringUnsafe.putInt(null, nativePointer.pointer + (long)byteSize, 0);
                }
                finally {
                    Reference.reachabilityFence(nativePointer);
                }
                TruffleString nativeString = TruffleString.createFromArray(nativePointer, 0, length, stride, encoding, a.codePointLength(), codeRangeA, !cacheResult);
                if (cacheResult) {
                    a.cacheInsert(nativeString);
                }
                TruffleString truffleString = nativeString;
                return truffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        private static void checkIntSize() {
        }

        @NeverDefault
        public static AsNativeNode create() {
            return TruffleStringFactory.AsNativeNodeGen.create();
        }

        public static AsNativeNode getUncached() {
            return TruffleStringFactory.AsNativeNodeGen.getUncached();
        }
    }

    public static abstract class CreateBackwardCodePointIteratorNode
    extends AbstractPublicNode {
        CreateBackwardCodePointIteratorNode() {
        }

        public final TruffleStringIterator execute(AbstractTruffleString a, Encoding expectedEncoding) {
            return this.execute(a, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract TruffleStringIterator execute(AbstractTruffleString var1, Encoding var2, ErrorHandling var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final TruffleStringIterator createIterator(AbstractTruffleString a, Encoding encoding, ErrorHandling errorHandling, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            a.checkEncoding(encoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encoding);
                TruffleStringIterator truffleStringIterator = AbstractTruffleString.backwardIterator(a, arrayA, offsetA, codeRangeA, encoding, errorHandling);
                return truffleStringIterator;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static CreateBackwardCodePointIteratorNode create() {
            return TruffleStringFactory.CreateBackwardCodePointIteratorNodeGen.create();
        }

        public static CreateBackwardCodePointIteratorNode getUncached() {
            return TruffleStringFactory.CreateBackwardCodePointIteratorNodeGen.getUncached();
        }
    }

    public static abstract class CreateCodePointIteratorNode
    extends AbstractPublicNode {
        CreateCodePointIteratorNode() {
        }

        public final TruffleStringIterator execute(AbstractTruffleString a, Encoding expectedEncoding) {
            return this.execute(a, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract TruffleStringIterator execute(AbstractTruffleString var1, Encoding var2, ErrorHandling var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final TruffleStringIterator createIterator(AbstractTruffleString a, Encoding encoding, ErrorHandling errorHandling, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            a.checkEncoding(encoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encoding);
                TruffleStringIterator truffleStringIterator = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding, errorHandling);
                return truffleStringIterator;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static CreateCodePointIteratorNode create() {
            return TruffleStringFactory.CreateCodePointIteratorNodeGen.create();
        }

        public static CreateCodePointIteratorNode getUncached() {
            return TruffleStringFactory.CreateCodePointIteratorNodeGen.getUncached();
        }
    }

    public static abstract class ForceEncodingNode
    extends AbstractPublicNode {
        ForceEncodingNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, Encoding var2, Encoding var3);

        @Specialization(guards={"isCompatibleAndNotCompacted(a, expectedEncoding, targetEncoding)"})
        static TruffleString compatibleImmutable(TruffleString a, Encoding expectedEncoding, Encoding targetEncoding) {
            assert (!a.isJavaString());
            return a;
        }

        @Specialization(guards={"isCompatibleAndNotCompacted(a, expectedEncoding, targetEncoding)"})
        final TruffleString compatibleMutable(MutableTruffleString a, Encoding expectedEncoding, Encoding targetEncoding, @Cached InternalAsTruffleStringNode asTruffleStringNode) {
            return asTruffleStringNode.execute(this, a, targetEncoding);
        }

        @Specialization(guards={"!isCompatibleAndNotCompacted(a, expectedEncoding, targetEncoding)"})
        final TruffleString reinterpret(AbstractTruffleString a, Encoding expectedEncoding, Encoding targetEncoding, @Cached TStringInternalNodes.ToIndexableNode toIndexableNode, @Cached InlinedConditionProfile inflateProfile, @Cached InternalCopyToByteArrayNode copyToByteArrayNode, @Cached TStringInternalNodes.FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            int offset;
            Object dataANoCompaction;
            Object dataA = toIndexableNode.execute(this, a, a.data());
            int byteLength = a.length() << expectedEncoding.naturalStride;
            if (inflateProfile.profile(this, TStringGuards.isUTF16Or32(expectedEncoding) && a.stride() != expectedEncoding.naturalStride)) {
                byte[] inflated = new byte[byteLength];
                copyToByteArrayNode.execute(this, a, 0, inflated, 0, byteLength, expectedEncoding);
                dataANoCompaction = inflated;
                offset = 0;
            } else {
                dataANoCompaction = dataA;
                offset = a.offset();
            }
            return fromBufferWithStringCompactionNode.execute(this, dataANoCompaction, offset, byteLength, targetEncoding, a.isMutable(), true);
        }

        static boolean isCompatibleAndNotCompacted(AbstractTruffleString a, Encoding expectedEncoding, Encoding targetEncoding) {
            return expectedEncoding.naturalStride == targetEncoding.naturalStride && (a.encoding() == targetEncoding.id || a.stride() == targetEncoding.naturalStride && a.isCompatibleToIntl(targetEncoding));
        }

        @NeverDefault
        public static ForceEncodingNode create() {
            return TruffleStringFactory.ForceEncodingNodeGen.create();
        }

        public static ForceEncodingNode getUncached() {
            return TruffleStringFactory.ForceEncodingNodeGen.getUncached();
        }
    }

    static abstract class InternalSwitchEncodingNode
    extends AbstractInternalNode {
        InternalSwitchEncodingNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Encoding var3, TranscodingErrorHandler var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static TruffleString immutable(Node node, TruffleString a, Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode getPreciseCodeRangeNode, @Cached @Cached.Exclusive InlinedConditionProfile isCompatibleProfile, @Cached @Cached.Exclusive InlinedConditionProfile noOpProfile, @Cached @Cached.Exclusive InlinedConditionProfile mustCompactProfile, @Cached @Cached.Exclusive InlinedConditionProfile compact10Profile, @Cached @Cached.Exclusive InlinedConditionProfile compact20Profile, @Cached @Cached.Exclusive InlinedConditionProfile cacheHit, @Cached @Cached.Exclusive InlinedConditionProfile managedProfileA, @Cached @Cached.Exclusive InlinedConditionProfile nativeProfileA, @Cached @Cached.Shared TStringInternalNodes.TransCodeNode transCodeNode) {
            TruffleString transCoded;
            int preciseCodeRangeA;
            boolean isCompatible;
            if (isCompatibleProfile.profile(node, a.isCompatibleToIntl(targetEncoding))) {
                isCompatible = true;
                preciseCodeRangeA = a.codeRange();
            } else {
                Encoding encodingA = Encoding.get(a.encoding());
                preciseCodeRangeA = getPreciseCodeRangeNode.execute(node, a, encodingA);
                isCompatible = a.isCodeRangeCompatibleTo(preciseCodeRangeA, targetEncoding);
            }
            boolean mustCompact = a.stride() > targetEncoding.naturalStride;
            if (noOpProfile.profile(node, isCompatible && !mustCompact)) {
                assert (!a.isJavaString());
                return a;
            }
            if (a.isEmpty()) {
                return targetEncoding.getEmpty();
            }
            TruffleString cur = a.next;
            assert (!a.isJavaString());
            if (cur != null) {
                while (cur != a && cur.encoding() != targetEncoding.id || TStringGuards.isUTF16(targetEncoding) && cur.isJavaString()) {
                    cur = cur.next;
                }
                if (cacheHit.profile(node, cur.encoding() == targetEncoding.id)) {
                    assert (!cur.isJavaString());
                    return cur;
                }
            }
            if (mustCompactProfile.profile(node, isCompatible && mustCompact)) {
                Object dataA = a.data();
                assert (dataA instanceof AbstractTruffleString.NativePointer);
                try {
                    long offsetA = (long)a.offset() + AbstractTruffleString.NativePointer.unwrap(dataA);
                    int strideA = a.stride();
                    int lengthA = a.length();
                    int stride = Stride.fromCodeRangeUTF16(preciseCodeRangeA);
                    byte[] array = new byte[lengthA << stride];
                    if (compact10Profile.profile(node, strideA == 1 && stride == 0)) {
                        TStringOps.arraycopyWithStride(node, null, offsetA, 1, 0, array, TStringUnsafe.byteArrayBaseOffset(), 0, 0, lengthA);
                    } else if (compact20Profile.profile(node, strideA == 2 && stride == 0)) {
                        TStringOps.arraycopyWithStride(node, null, offsetA, 2, 0, array, TStringUnsafe.byteArrayBaseOffset(), 0, 0, lengthA);
                    } else {
                        assert (strideA == 2 && stride == 1);
                        TStringOps.arraycopyWithStride(node, null, offsetA, 2, 0, array, TStringUnsafe.byteArrayBaseOffset(), 1, 0, lengthA);
                    }
                    transCoded = TruffleString.createFromByteArray(array, 0, lengthA, stride, targetEncoding, a.codePointLength(), preciseCodeRangeA, false);
                }
                finally {
                    Reference.reachabilityFence(dataA);
                }
            }
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(node, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                transCoded = transCodeNode.execute(node, a, arrayA, offsetA, a.codePointLength(), preciseCodeRangeA, targetEncoding, errorHandler);
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
            if (!transCoded.isCacheHead()) {
                a.cacheInsert(transCoded);
            }
            return transCoded;
        }

        @Specialization(guards={"a.isCompatibleToIntl(targetEncoding)"})
        static TruffleString compatibleMutable(Node node, MutableTruffleString a, Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached InternalAsTruffleStringNode asTruffleStringNode) {
            return asTruffleStringNode.execute(node, a, targetEncoding);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!a.isCompatibleToIntl(targetEncoding)"})
        static TruffleString transCodeMutable(Node node, MutableTruffleString a, Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Exclusive InlinedConditionProfile managedProfileA, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached @Cached.Shared TStringInternalNodes.TransCodeNode transCodeNode, @Cached @Cached.Exclusive InlinedConditionProfile isCompatibleProfile) {
            if (a.isEmpty()) {
                return targetEncoding.getEmpty();
            }
            Encoding encodingA = Encoding.get(a.encoding());
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codePointLengthA = getCodePointLengthNode.execute(node, a, arrayA, offsetA, encodingA);
                int codeRangeA = getPreciseCodeRangeNode.execute(node, a, arrayA, offsetA, encodingA);
                if (isCompatibleProfile.profile(node, TSCodeRange.isMoreRestrictiveThan(codeRangeA, targetEncoding.maxCompatibleCodeRange))) {
                    int strideDst = Stride.fromCodeRange(codeRangeA, targetEncoding);
                    byte[] arrayDst = new byte[a.length() << strideDst];
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, a.stride(), 0, arrayDst, TStringUnsafe.byteArrayBaseOffset(), strideDst, 0, a.length());
                    TruffleString truffleString = TruffleString.createFromByteArray(arrayDst, a.length(), strideDst, targetEncoding, codePointLengthA, codeRangeA);
                    return truffleString;
                }
                TruffleString truffleString = transCodeNode.execute(node, a, arrayA, offsetA, codePointLengthA, codeRangeA, targetEncoding, errorHandler);
                return truffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }
    }

    public static abstract class SwitchEncodingNode
    extends AbstractPublicNode {
        SwitchEncodingNode() {
        }

        public final TruffleString execute(AbstractTruffleString a, Encoding encoding) {
            return this.execute(a, encoding, TranscodingErrorHandler.DEFAULT);
        }

        public abstract TruffleString execute(AbstractTruffleString var1, Encoding var2, TranscodingErrorHandler var3);

        @Specialization
        final TruffleString switchEncoding(AbstractTruffleString a, Encoding encoding, TranscodingErrorHandler errorHandler, @Cached InternalSwitchEncodingNode internalNode) {
            return internalNode.execute(this, a, encoding, errorHandler);
        }

        @NeverDefault
        public static SwitchEncodingNode create() {
            return TruffleStringFactory.SwitchEncodingNodeGen.create();
        }

        public static SwitchEncodingNode getUncached() {
            return TruffleStringFactory.SwitchEncodingNodeGen.getUncached();
        }
    }

    public static abstract class ToValidStringNode
    extends AbstractPublicNode {
        ToValidStringNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, Encoding var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final TruffleString toValid(AbstractTruffleString a, Encoding encoding, @Cached InlinedConditionProfile isValidProfile, @Cached TStringInternalNodes.GetValidOrBrokenCodeRangeNode getCodeRangeNode, @Cached InternalAsTruffleStringNode asTruffleStringNode, @Cached TStringInternalNodes.ToValidStringNode internalNode, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA) {
            a.checkEncoding(encoding);
            int codeRangeA = getCodeRangeNode.execute(this, a, encoding);
            if (isValidProfile.profile(this, !TStringGuards.isBroken(codeRangeA))) {
                return asTruffleStringNode.execute(this, a, encoding);
            }
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                TruffleString truffleString = internalNode.execute(this, a, arrayA, offsetA, encoding);
                return truffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ToValidStringNode create() {
            return TruffleStringFactory.ToValidStringNodeGen.create();
        }

        public static ToValidStringNode getUncached() {
            return TruffleStringFactory.ToValidStringNodeGen.getUncached();
        }
    }

    public static abstract class ToJavaStringNode
    extends AbstractPublicNode {
        ToJavaStringNode() {
        }

        public abstract String execute(AbstractTruffleString var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static String doUTF16(TruffleString a, @Bind Node node, @Cached InlinedConditionProfile cacheHit, @Cached @Cached.Exclusive InlinedConditionProfile managedProfileA, @Cached @Cached.Exclusive InlinedConditionProfile nativeProfileA, @Cached @Cached.Shared TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached @Cached.Shared TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode getPreciseCodeRangeNode, @Cached @Cached.Shared TStringInternalNodes.TransCodeNode transCodeNode, @Cached @Cached.Shared TStringInternalNodes.CreateJavaStringNode createJavaStringNode, @Cached @Cached.Shared InlinedConditionProfile noTranscodeProfile) {
            if (a.isEmpty()) {
                return "";
            }
            TruffleString cur = a.next;
            if (cur != null) {
                while (cur != a && !cur.isJavaString()) {
                    cur = cur.next;
                }
                if (cacheHit.profile(node, cur.isJavaString())) {
                    return (String)cur.data();
                }
            }
            if ((cur = a.next) != null) {
                while (cur != a && !cur.isCompatibleToIntl(Encoding.UTF_16)) {
                    cur = cur.next;
                }
            } else {
                cur = a;
            }
            if (cur.isJavaString()) {
                return (String)cur.data();
            }
            Encoding encodingA = Encoding.get(cur.encoding());
            Object dataCur = cur.data();
            try {
                long utf16Offset;
                byte[] utf16Array;
                TruffleString utf16String;
                long addOffsetCur;
                byte[] arrayCur;
                if (managedProfileA.profile(node, dataCur instanceof byte[])) {
                    arrayCur = (byte[])dataCur;
                    addOffsetCur = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(node, dataCur instanceof AbstractTruffleString.NativePointer)) {
                    arrayCur = null;
                    addOffsetCur = AbstractTruffleString.NativePointer.unwrap(dataCur);
                } else {
                    arrayCur = cur.materializeLazy(node, dataCur);
                    addOffsetCur = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetCur = (long)cur.offset() + addOffsetCur;
                if (noTranscodeProfile.profile(node, ToJavaStringNode.doesNotNeedTranscoding(node, cur, encodingA, getPreciseCodeRangeNode))) {
                    utf16String = cur;
                    utf16Array = arrayCur;
                    utf16Offset = offsetCur;
                } else {
                    assert (TSCodeRange.isPrecise(cur.codeRange()));
                    TruffleString transCoded = transCodeNode.execute(node, cur, arrayCur, offsetCur, getCodePointLengthNode.execute(node, cur, arrayCur, offsetCur, encodingA), cur.codeRange(), Encoding.UTF_16, TranscodingErrorHandler.DEFAULT);
                    if (!transCoded.isCacheHead()) {
                        a.cacheInsert(transCoded);
                    }
                    utf16String = transCoded;
                    utf16Array = (byte[])transCoded.data();
                    assert (transCoded.isManaged());
                    utf16Offset = TStringUnsafe.byteArrayBaseOffset() + transCoded.offset();
                }
                String javaString = createJavaStringNode.execute(node, utf16String, utf16Array, utf16Offset);
                a.cacheInsert(TruffleString.createWrapJavaString(javaString, utf16String.codePointLength(), utf16String.codeRange()));
                String string = javaString;
                return string;
            }
            finally {
                Reference.reachabilityFence(dataCur);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static String doMutable(MutableTruffleString a, @Bind Node node, @Cached @Cached.Exclusive InlinedConditionProfile managedProfileA, @Cached @Cached.Shared TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached @Cached.Shared TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode getPreciseCodeRangeNode, @Cached @Cached.Shared TStringInternalNodes.TransCodeNode transCodeNode, @Cached @Cached.Shared TStringInternalNodes.CreateJavaStringNode createJavaStringNode, @Cached @Cached.Shared InlinedConditionProfile noTranscodeProfile) {
            if (a.isEmpty()) {
                return "";
            }
            Encoding encodingA = Encoding.get(a.encoding());
            Object dataA = a.data();
            try {
                long utf16Offset;
                byte[] utf16Array;
                AbstractTruffleString utf16String;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (noTranscodeProfile.profile(node, ToJavaStringNode.doesNotNeedTranscoding(node, a, encodingA, getPreciseCodeRangeNode))) {
                    utf16String = a;
                    utf16Array = arrayA;
                    utf16Offset = offsetA;
                } else {
                    assert (TSCodeRange.isPrecise(a.codeRange()));
                    utf16String = transCodeNode.execute(node, a, arrayA, offsetA, getCodePointLengthNode.execute(node, a, arrayA, offsetA, encodingA), a.codeRange(), Encoding.UTF_16, TranscodingErrorHandler.DEFAULT);
                    utf16Array = (byte[])utf16String.data();
                    utf16Offset = TStringUnsafe.byteArrayBaseOffset();
                }
                String string = createJavaStringNode.execute(node, utf16String, utf16Array, utf16Offset);
                return string;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        private static boolean doesNotNeedTranscoding(Node node, AbstractTruffleString a, Encoding encodingA, TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode getPreciseCodeRangeNode) {
            return TStringGuards.is7Or8Bit(a.codeRange()) || TSCodeRange.isMoreRestrictiveThan(getPreciseCodeRangeNode.execute(node, a, encodingA), Encoding.UTF_16.maxCompatibleCodeRange) || TStringGuards.isUTF16(a.encoding());
        }

        @NeverDefault
        public static ToJavaStringNode create() {
            return TruffleStringFactory.ToJavaStringNodeGen.create();
        }

        public static ToJavaStringNode getUncached() {
            return TruffleStringFactory.ToJavaStringNodeGen.getUncached();
        }
    }

    public static abstract class CopyToNativeMemoryNode
    extends AbstractPublicNode {
        CopyToNativeMemoryNode() {
        }

        public abstract void execute(AbstractTruffleString var1, int var2, Object var3, int var4, int var5, Encoding var6);

        @Specialization
        void doCopy(AbstractTruffleString a, int byteFromIndexA, Object pointerObject, int byteFromIndexB, int byteLength, Encoding expectedEncoding, @Cached(value="createInteropLibrary()", uncached="getUncachedInteropLibrary()") Node interopLibrary, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16S0Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32S0Profile, @Cached InlinedConditionProfile utf32S1Profile) {
            AbstractTruffleString.NativePointer nativePointer = AbstractTruffleString.NativePointer.create(this, pointerObject, interopLibrary);
            InternalCopyToByteArrayNode.doCopyInternal(this, a, byteFromIndexA, null, nativePointer.pointer, byteFromIndexB, byteLength, expectedEncoding, managedProfileA, nativeProfileA, utf16Profile, utf16S0Profile, utf32Profile, utf32S0Profile, utf32S1Profile);
            Reference.reachabilityFence(pointerObject);
        }

        @NeverDefault
        public static CopyToNativeMemoryNode create() {
            return TruffleStringFactory.CopyToNativeMemoryNodeGen.create();
        }

        public static CopyToNativeMemoryNode getUncached() {
            return TruffleStringFactory.CopyToNativeMemoryNodeGen.getUncached();
        }
    }

    static abstract class InternalCopyToByteArrayNode
    extends AbstractInternalNode {
        InternalCopyToByteArrayNode() {
        }

        abstract void execute(Node var1, AbstractTruffleString var2, int var3, byte[] var4, int var5, int var6, Encoding var7);

        @Specialization
        static void doCopy(Node node, AbstractTruffleString a, int byteFromIndexA, byte[] arrayB, int byteFromIndexB, int byteLength, Encoding expectedEncoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16S0Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32S0Profile, @Cached InlinedConditionProfile utf32S1Profile) {
            AbstractTruffleString.boundsCheckRegionI(byteFromIndexB, byteLength, arrayB.length);
            InternalCopyToByteArrayNode.doCopyInternal(node, a, byteFromIndexA, arrayB, TStringUnsafe.byteArrayBaseOffset(), byteFromIndexB, byteLength, expectedEncoding, managedProfileA, nativeProfileA, utf16Profile, utf16S0Profile, utf32Profile, utf32S0Profile, utf32S1Profile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void doCopyInternal(Node node, AbstractTruffleString a, int byteFromIndexA, byte[] arrayB, long offsetB, int byteFromIndexB, int byteLength, Encoding expectedEncoding, InlinedConditionProfile managedProfileA, InlinedConditionProfile nativeProfileA, InlinedConditionProfile utf16Profile, InlinedConditionProfile utf16S0Profile, InlinedConditionProfile utf32Profile, InlinedConditionProfile utf32S0Profile, InlinedConditionProfile utf32S1Profile) {
            if (byteLength == 0) {
                return;
            }
            a.checkEncoding(expectedEncoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(node, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (utf16Profile.profile(node, TStringGuards.isUTF16(expectedEncoding))) {
                    a.boundsCheckByteIndexUTF16(byteFromIndexA);
                    AbstractTruffleString.checkByteLengthUTF16(byteLength);
                    fromIndexA = AbstractTruffleString.rawIndex(byteFromIndexA, expectedEncoding);
                    int fromIndexB = AbstractTruffleString.rawIndex(byteFromIndexB, expectedEncoding);
                    int length = AbstractTruffleString.rawIndex(byteLength, expectedEncoding);
                    a.boundsCheckRegionRaw(fromIndexA, length);
                    if (utf16S0Profile.profile(node, TStringGuards.isStride0(a))) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, fromIndexA, arrayB, offsetB, 1, fromIndexB, length);
                        return;
                    }
                } else if (utf32Profile.profile(node, TStringGuards.isUTF32(expectedEncoding))) {
                    a.boundsCheckByteIndexUTF32(byteFromIndexA);
                    AbstractTruffleString.checkByteLengthUTF32(byteLength);
                    fromIndexA = AbstractTruffleString.rawIndex(byteFromIndexA, expectedEncoding);
                    int fromIndexB = AbstractTruffleString.rawIndex(byteFromIndexB, expectedEncoding);
                    int length = AbstractTruffleString.rawIndex(byteLength, expectedEncoding);
                    a.boundsCheckRegionRaw(fromIndexA, length);
                    if (utf32S0Profile.profile(node, TStringGuards.isStride0(a))) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, fromIndexA, arrayB, offsetB, 2, fromIndexB, length);
                        return;
                    }
                    if (utf32S1Profile.profile(node, TStringGuards.isStride1(a))) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, fromIndexA, arrayB, offsetB, 2, fromIndexB, length);
                        return;
                    }
                }
                assert (a.stride() == expectedEncoding.naturalStride);
                int byteLengthA = a.length() << a.stride();
                AbstractTruffleString.boundsCheckRegionI(byteFromIndexA, byteLength, byteLengthA);
                TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, byteFromIndexA, arrayB, offsetB, 0, byteFromIndexB, byteLength);
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }
    }

    public static abstract class CopyToByteArrayNode
    extends AbstractPublicNode {
        CopyToByteArrayNode() {
        }

        public final byte[] execute(AbstractTruffleString string, Encoding expectedEncoding) {
            int byteLength = string.byteLength(expectedEncoding);
            byte[] copy = new byte[byteLength];
            this.execute(string, 0, copy, 0, byteLength, expectedEncoding);
            return copy;
        }

        public abstract void execute(AbstractTruffleString var1, int var2, byte[] var3, int var4, int var5, Encoding var6);

        @Specialization
        final void doCopy(AbstractTruffleString a, int byteFromIndexA, byte[] dst, int byteFromIndexDst, int byteLength, Encoding expectedEncoding, @Cached InternalCopyToByteArrayNode internalNode) {
            internalNode.execute(this, a, byteFromIndexA, dst, byteFromIndexDst, byteLength, expectedEncoding);
        }

        @NeverDefault
        public static CopyToByteArrayNode create() {
            return TruffleStringFactory.CopyToByteArrayNodeGen.create();
        }

        public static CopyToByteArrayNode getUncached() {
            return TruffleStringFactory.CopyToByteArrayNodeGen.getUncached();
        }
    }

    public static abstract class GetInternalNativePointerNode
    extends AbstractPublicNode {
        GetInternalNativePointerNode() {
        }

        public abstract Object execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        static Object getNativePointer(AbstractTruffleString a, Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            if (!a.isNative()) {
                throw InternalErrors.unsupportedOperation("string is not backed by a native pointer!");
            }
            return ((AbstractTruffleString.NativePointer)a.data()).getPointerObject();
        }

        @NeverDefault
        public static GetInternalNativePointerNode create() {
            return TruffleStringFactory.GetInternalNativePointerNodeGen.create();
        }

        public static GetInternalNativePointerNode getUncached() {
            return TruffleStringFactory.GetInternalNativePointerNodeGen.getUncached();
        }
    }

    public static abstract class GetInternalByteArrayNode
    extends AbstractPublicNode {
        GetInternalByteArrayNode() {
        }

        public abstract InternalByteArray execute(AbstractTruffleString var1, Encoding var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        InternalByteArray getInternalByteArray(AbstractTruffleString a, Encoding expectedEncoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16S0Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32S0Profile, @Cached InlinedConditionProfile utf32S1Profile, @Cached InlinedConditionProfile isByteArrayProfile) {
            if (a.isEmpty()) {
                return InternalByteArray.EMPTY;
            }
            a.checkEncoding(expectedEncoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (utf16Profile.profile(this, TStringGuards.isUTF16(expectedEncoding))) {
                    if (utf16S0Profile.profile(this, TStringGuards.isStride0(a))) {
                        InternalByteArray internalByteArray = this.inflate(a, arrayA, offsetA, 0, 1);
                        return internalByteArray;
                    }
                } else if (utf32Profile.profile(this, TStringGuards.isUTF32(expectedEncoding))) {
                    if (utf32S0Profile.profile(this, TStringGuards.isStride0(a))) {
                        InternalByteArray internalByteArray = this.inflate(a, arrayA, offsetA, 0, 2);
                        return internalByteArray;
                    }
                    if (utf32S1Profile.profile(this, TStringGuards.isStride1(a))) {
                        InternalByteArray internalByteArray = this.inflate(a, arrayA, offsetA, 1, 2);
                        return internalByteArray;
                    }
                }
                int byteLength = a.length() << a.stride();
                if (isByteArrayProfile.profile(this, arrayA != null)) {
                    InternalByteArray internalByteArray = new InternalByteArray(arrayA, a.offset(), byteLength);
                    return internalByteArray;
                }
                InternalByteArray internalByteArray = new InternalByteArray(TStringOps.arraycopyOfWithStride(this, arrayA, offsetA, byteLength, 0, byteLength, 0), 0, byteLength);
                return internalByteArray;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        private InternalByteArray inflate(AbstractTruffleString a, byte[] dataA, long offsetA, int strideA, int strideB) {
            assert (a.stride() == strideA);
            CompilerAsserts.partialEvaluationConstant(strideA);
            CompilerAsserts.partialEvaluationConstant(strideB);
            return new InternalByteArray(TStringOps.arraycopyOfWithStride(this, dataA, offsetA, a.length(), strideA, a.length(), strideB), 0, a.length() << strideB);
        }

        @NeverDefault
        public static GetInternalByteArrayNode create() {
            return TruffleStringFactory.GetInternalByteArrayNodeGen.create();
        }

        public static GetInternalByteArrayNode getUncached() {
            return TruffleStringFactory.GetInternalByteArrayNodeGen.getUncached();
        }
    }

    public static abstract class ParseDoubleNode
    extends AbstractPublicNode {
        ParseDoubleNode() {
        }

        public abstract double execute(AbstractTruffleString var1) throws NumberFormatException;

        @Specialization(guards={"isLazyLongSafeInteger(a)"})
        static double doLazyLong(AbstractTruffleString a) {
            return ((AbstractTruffleString.LazyLong)a.data()).value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Fallback
        final double parseDouble(AbstractTruffleString a, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.ParseDoubleNode parseDoubleNode) throws NumberFormatException {
            assert (!ParseDoubleNode.isLazyLongSafeInteger(a));
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                double d = parseDoubleNode.execute(this, a, arrayA, offsetA);
                return d;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        static boolean isLazyLongSafeInteger(AbstractTruffleString a) {
            return a.isLazyLong() && NumberConversion.isSafeInteger(((AbstractTruffleString.LazyLong)a.data()).value);
        }

        @NeverDefault
        public static ParseDoubleNode create() {
            return TruffleStringFactory.ParseDoubleNodeGen.create();
        }

        public static ParseDoubleNode getUncached() {
            return TruffleStringFactory.ParseDoubleNodeGen.getUncached();
        }
    }

    public static abstract class ParseLongNode
    extends AbstractPublicNode {
        ParseLongNode() {
        }

        public abstract long execute(AbstractTruffleString var1, int var2) throws NumberFormatException;

        @Specialization(guards={"a.isLazyLong()", "radix == 10"})
        static long doLazyLong(AbstractTruffleString a, int radix) {
            return ((AbstractTruffleString.LazyLong)a.data()).value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Fallback
        final long doParse(AbstractTruffleString a, int radix, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getCodeRangeANode, @Cached TStringInternalNodes.ParseLongNode parseLongNode, @Cached InlinedIntValueProfile radixProfile) throws NumberFormatException {
            assert (!a.isLazyLong() || radix != 10);
            Encoding encodingA = Encoding.get(a.encoding());
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encodingA);
                long l = parseLongNode.execute(this, a, arrayA, offsetA, codeRangeA, encodingA, radixProfile.profile(this, radix));
                return l;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ParseLongNode create() {
            return TruffleStringFactory.ParseLongNodeGen.create();
        }

        public static ParseLongNode getUncached() {
            return TruffleStringFactory.ParseLongNodeGen.getUncached();
        }
    }

    public static abstract class ParseIntNode
    extends AbstractPublicNode {
        ParseIntNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2) throws NumberFormatException;

        @Specialization(guards={"a.isLazyLong()", "radix == 10"})
        final int doLazyLong(AbstractTruffleString a, int radix, @Cached InlinedBranchProfile errorProfile) throws NumberFormatException {
            long value = ((AbstractTruffleString.LazyLong)a.data()).value;
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                errorProfile.enter(this);
                throw NumberConversion.numberFormatException(a, NumberFormatException.Reason.OVERFLOW);
            }
            return (int)value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Fallback
        final int doParse(AbstractTruffleString a, int radix, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getCodeRangeANode, @Cached TStringInternalNodes.ParseIntNode parseIntNode, @Cached InlinedIntValueProfile radixProfile) throws NumberFormatException {
            assert (!a.isLazyLong() || radix != 10);
            Encoding encodingA = Encoding.get(a.encoding());
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encodingA);
                int n = parseIntNode.execute(this, a, arrayA, offsetA, codeRangeA, encodingA, radixProfile.profile(this, radix));
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ParseIntNode create() {
            return TruffleStringFactory.ParseIntNodeGen.create();
        }

        public static ParseIntNode getUncached() {
            return TruffleStringFactory.ParseIntNodeGen.getUncached();
        }
    }

    public static final class IllegalByteArrayLengthException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 2871353611734808666L;

        IllegalByteArrayLengthException(String msg) {
            super(msg);
        }
    }

    public static final class NumberFormatException
    extends Exception {
        private static final long serialVersionUID = 102938855488837538L;
        private final AbstractTruffleString string;
        private final int regionOffset;
        private final int regionLength;
        private final Reason reason;

        NumberFormatException(AbstractTruffleString string, Reason reason) {
            this(string, -1, -1, reason);
        }

        NumberFormatException(AbstractTruffleString string, int regionOffset, int regionLength, Reason reason) {
            this.string = string;
            this.regionOffset = regionOffset;
            this.regionLength = regionLength;
            this.reason = reason;
        }

        Reason getReason() {
            return this.reason;
        }

        AbstractTruffleString getString() {
            return this.string;
        }

        int getRegionByteOffset() {
            return this.regionOffset < 0 ? this.regionOffset : this.regionOffset << this.string.stride();
        }

        int getRegionByteLength() {
            return this.regionLength < 0 ? this.regionLength : this.regionLength << this.string.stride();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("error parsing \"").append(this.getString()).append("\": ");
            sb.append(this.getReason().message);
            if (this.regionOffset >= 0) {
                if (this.regionLength == 1) {
                    sb.append(" at byte index ").append(this.getRegionByteOffset());
                } else {
                    sb.append(" from byte index ").append(this.getRegionByteOffset()).append(" to ").append(this.getRegionByteOffset() + this.getRegionByteLength());
                }
            }
            return sb.toString();
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        static enum Reason {
            EMPTY("no digits found"),
            INVALID_CODEPOINT("invalid codepoint"),
            LONE_SIGN("lone '+' or '-'"),
            OVERFLOW("overflow"),
            MALFORMED_HEX_ESCAPE("malformed hex escape sequence"),
            MULTIPLE_DECIMAL_POINTS("multiple decimal points"),
            UNSUPPORTED_RADIX("unsupported radix");

            private final String message;

            private Reason(String message) {
                this.message = message;
            }

            public String getMessage() {
                return this.message;
            }
        }
    }

    public static abstract class EqualNode
    extends AbstractPublicNode {
        EqualNode() {
        }

        public abstract boolean execute(AbstractTruffleString var1, AbstractTruffleString var2, Encoding var3);

        @Specialization(guards={"a == b"})
        static boolean sameObject(AbstractTruffleString a, AbstractTruffleString b, Encoding expectedEncoding) {
            return true;
        }

        @Fallback
        static boolean check(AbstractTruffleString a, AbstractTruffleString b, Encoding expectedEncoding, @Bind Node node, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB, @Cached InlinedConditionProfile lengthAndCodeRangeCheckProfile, @Cached InlinedBranchProfile compareHashProfile, @Cached InlinedConditionProfile checkFirstByteProfile) {
            a.looseCheckEncoding(expectedEncoding, a.codeRange());
            b.looseCheckEncoding(expectedEncoding, b.codeRange());
            return EqualNode.checkContentEquals(node, a, b, managedProfileA, nativeProfileA, managedProfileB, nativeProfileB, lengthAndCodeRangeCheckProfile, compareHashProfile, checkFirstByteProfile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean checkContentEquals(Node node, AbstractTruffleString a, AbstractTruffleString b, InlinedConditionProfile managedProfileA, InlinedConditionProfile nativeProfileA, InlinedConditionProfile managedProfileB, InlinedConditionProfile nativeProfileB, InlinedConditionProfile lengthAndCodeRangeCheckProfile, InlinedBranchProfile compareHashProfile, InlinedConditionProfile checkFirstByteProfile) {
            int codeRangeA = a.codeRange();
            int codeRangeB = b.codeRange();
            int lengthCMP = a.length();
            if (lengthAndCodeRangeCheckProfile.profile(node, lengthCMP != b.length() || TSCodeRange.isPrecise(codeRangeA, codeRangeB) && codeRangeA != codeRangeB)) {
                return false;
            }
            if (a.isHashCodeCalculated() && b.isHashCodeCalculated()) {
                compareHashProfile.enter(node);
                if (a.getHashCodeUnsafe() != b.getHashCodeUnsafe()) {
                    return false;
                }
            }
            if (lengthCMP == 0) {
                return true;
            }
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    if (dataA instanceof AbstractTruffleString.LazyLong) {
                        AbstractTruffleString.LazyLong lazyLongA = (AbstractTruffleString.LazyLong)dataA;
                        if (dataB instanceof AbstractTruffleString.LazyLong) {
                            AbstractTruffleString.LazyLong lazyLongB = (AbstractTruffleString.LazyLong)dataB;
                            boolean bl = lazyLongA.value == lazyLongB.value;
                            return bl;
                        }
                    }
                    arrayA = a.materializeLazy(node, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(node, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(node, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(node, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                int strideA = a.stride();
                int strideB = b.stride();
                if (checkFirstByteProfile.profile(node, (strideA | strideB) == 0)) {
                    if (TStringOps.readS0(arrayA, offsetA, a.length(), 0) != TStringOps.readS0(arrayB, offsetB, b.length(), 0)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (lengthCMP == 1) {
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = TStringOps.regionEqualsWithOrMaskWithStride(node, a, arrayA, offsetA, strideA, 0, b, arrayB, offsetB, strideB, 0, null, lengthCMP);
                return bl;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean checkContentEqualsUncached(AbstractTruffleString a, AbstractTruffleString b) {
            EqualNode node = EqualNode.getUncached();
            int codeRangeA = a.codeRange();
            int codeRangeB = b.codeRange();
            int lengthCMP = a.length();
            if (lengthCMP != b.length() || TSCodeRange.isPrecise(codeRangeA, codeRangeB) && codeRangeA != codeRangeB) {
                return false;
            }
            if (a.isHashCodeCalculated() && b.isHashCodeCalculated() && a.getHashCodeUnsafe() != b.getHashCodeUnsafe()) {
                return false;
            }
            if (lengthCMP == 0) {
                return true;
            }
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (dataA instanceof byte[]) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (dataA instanceof AbstractTruffleString.NativePointer) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    if (dataA instanceof AbstractTruffleString.LazyLong) {
                        AbstractTruffleString.LazyLong lazyLongA = (AbstractTruffleString.LazyLong)dataA;
                        if (dataB instanceof AbstractTruffleString.LazyLong) {
                            AbstractTruffleString.LazyLong lazyLongB = (AbstractTruffleString.LazyLong)dataB;
                            boolean bl = lazyLongA.value == lazyLongB.value;
                            return bl;
                        }
                    }
                    arrayA = a.materializeLazy(node, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (dataB instanceof byte[]) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (dataB instanceof AbstractTruffleString.NativePointer) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(node, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                int strideA = a.stride();
                int strideB = b.stride();
                if ((strideA | strideB) == 0) {
                    if (TStringOps.readS0(arrayA, offsetA, a.length(), 0) != TStringOps.readS0(arrayB, offsetB, b.length(), 0)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (lengthCMP == 1) {
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = TStringOps.regionEqualsWithOrMaskWithStride(node, a, arrayA, offsetA, strideA, 0, b, arrayB, offsetB, strideB, 0, null, lengthCMP);
                return bl;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static EqualNode create() {
            return TruffleStringFactory.EqualNodeGen.create();
        }

        public static EqualNode getUncached() {
            return TruffleStringFactory.EqualNodeGen.getUncached();
        }
    }

    public static abstract class SubstringByteIndexNode
    extends AbstractPublicNode {
        SubstringByteIndexNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, int var2, int var3, Encoding var4, boolean var5);

        @Specialization(guards={"byteLength == 0"})
        static TruffleString substringEmpty(AbstractTruffleString a, int fromByteIndex, int byteLength, Encoding expectedEncoding, boolean lazy) {
            a.checkEncoding(expectedEncoding);
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, expectedEncoding);
            a.boundsCheckRegionRaw(fromIndex, 0);
            return expectedEncoding.getEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Fallback
        final TruffleString substringRaw(AbstractTruffleString a, int fromByteIndex, int byteLength, Encoding expectedEncoding, boolean lazy, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.SubstringNode substringNode) {
            assert (byteLength != 0) : byteLength;
            a.checkEncoding(expectedEncoding);
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, expectedEncoding);
            int length = AbstractTruffleString.rawIndex(byteLength, expectedEncoding);
            a.boundsCheckRegionRaw(fromIndex, length);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                TruffleString truffleString = substringNode.execute(this, a, arrayA, offsetA, a.codeRange(), expectedEncoding, fromIndex, length, lazy && a.isImmutable());
                return truffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static SubstringByteIndexNode create() {
            return TruffleStringFactory.SubstringByteIndexNodeGen.create();
        }

        public static SubstringByteIndexNode getUncached() {
            return TruffleStringFactory.SubstringByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class SubstringNode
    extends AbstractPublicNode {
        SubstringNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, int var2, int var3, Encoding var4, boolean var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final TruffleString substring(AbstractTruffleString a, int fromIndex, int length, Encoding encoding, boolean lazy, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.CodePointIndexToRawNode translateIndexNode, @Cached TStringInternalNodes.SubstringNode substringNode) {
            a.checkEncoding(encoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                a.boundsCheckRegion(this, arrayA, offsetA, fromIndex, length, encoding, getCodePointLengthNode);
                if (length == 0) {
                    TruffleString truffleString = encoding.getEmpty();
                    return truffleString;
                }
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encoding);
                int fromIndexRaw = translateIndexNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, 0, fromIndex, false);
                int lengthRaw = translateIndexNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, fromIndexRaw, length, true);
                TruffleString truffleString = substringNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, fromIndexRaw, lengthRaw, lazy && a.isImmutable());
                return truffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static SubstringNode create() {
            return TruffleStringFactory.SubstringNodeGen.create();
        }

        public static SubstringNode getUncached() {
            return TruffleStringFactory.SubstringNodeGen.getUncached();
        }
    }

    public static abstract class RepeatNode
    extends AbstractPublicNode {
        RepeatNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, int var2, Encoding var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final TruffleString repeat(AbstractTruffleString a, int n, Encoding expectedEncoding, @Cached AsTruffleStringNode asTruffleStringNode, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.CalcStringAttributesNode calcStringAttributesNode, @Cached InlinedConditionProfile brokenProfile, @Cached InlinedBranchProfile outOfMemoryProfile, @Cached InlinedBranchProfile compactProfile) {
            a.checkEncoding(expectedEncoding);
            if (n < 0) {
                throw InternalErrors.illegalArgument("n must be positive (was: %d)", n);
            }
            if (a.isEmpty() || n == 0) {
                return expectedEncoding.getEmpty();
            }
            if (n == 1) {
                return asTruffleStringNode.execute(a, expectedEncoding);
            }
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getPreciseCodeRangeNode.execute(this, a, arrayA, offsetA, expectedEncoding);
                int codePointLengthA = getCodePointLengthNode.execute(this, a, arrayA, offsetA, expectedEncoding);
                int byteLengthA = a.length() << a.stride();
                int stride = Stride.fromCodeRange(codeRangeA, expectedEncoding);
                long byteLength = ((long)a.length() << stride) * (long)n;
                if (Long.compareUnsigned(byteLength, 0x7FFFFFF7L) > 0) {
                    outOfMemoryProfile.enter(this);
                    throw InternalErrors.outOfMemory();
                }
                byte[] array = new byte[(int)byteLength];
                int offsetB = TStringUnsafe.byteArrayBaseOffset();
                if (stride == a.stride()) {
                    for (int i = 0; i < n; ++i) {
                        TStringOps.arraycopyWithStride(this, arrayA, offsetA, 0, 0, array, offsetB, 0, 0, byteLengthA);
                        offsetB += byteLengthA;
                        TStringConstants.truffleSafePointPoll(this, i + 1);
                    }
                } else {
                    compactProfile.enter(this);
                    int byteLengthCompact = a.length() << stride;
                    for (int i = 0; i < n; ++i) {
                        TStringOps.arraycopyWithStride(this, arrayA, offsetA, a.stride(), 0, array, offsetB, stride, 0, a.length());
                        offsetB += byteLengthCompact;
                        TStringConstants.truffleSafePointPoll(this, i + 1);
                    }
                }
                int length = (int)(byteLength >> stride);
                if (brokenProfile.profile(this, TStringGuards.isBroken(codeRangeA))) {
                    long attrs = calcStringAttributesNode.execute(this, null, array, TStringUnsafe.byteArrayBaseOffset(), length, stride, expectedEncoding, 0, codeRangeA);
                    codeRangeA = StringAttributes.getCodeRange(attrs);
                    codePointLengthA = StringAttributes.getCodePointLength(attrs);
                } else {
                    codePointLengthA *= n;
                }
                TruffleString truffleString = TruffleString.createFromByteArray(array, length, stride, expectedEncoding, codePointLengthA, codeRangeA);
                return truffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static RepeatNode create() {
            return TruffleStringFactory.RepeatNodeGen.create();
        }

        public static RepeatNode getUncached() {
            return TruffleStringFactory.RepeatNodeGen.getUncached();
        }
    }

    public static abstract class ConcatNode
    extends AbstractPublicNode {
        ConcatNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, AbstractTruffleString var2, Encoding var3, boolean var4);

        @Specialization(guards={"isEmpty(a)"})
        static TruffleString aEmpty(AbstractTruffleString a, TruffleString b, Encoding expectedEncoding, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                b.looseCheckEncoding(expectedEncoding, b.codeRange());
                return b.switchEncodingUncached(expectedEncoding);
            }
            b.checkEncoding(expectedEncoding);
            return b;
        }

        @Specialization(guards={"isEmpty(a)"})
        TruffleString aEmptyMutable(AbstractTruffleString a, MutableTruffleString b, Encoding expectedEncoding, boolean lazy, @Cached.Shared(value="attributesNode") @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode attributesNode) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                b.looseCheckEncoding(expectedEncoding, b.codeRange());
                return b.switchEncodingUncached(expectedEncoding);
            }
            return attributesNode.execute(this, b, expectedEncoding);
        }

        @Specialization(guards={"isEmpty(b)"})
        static TruffleString bEmpty(TruffleString a, AbstractTruffleString b, Encoding expectedEncoding, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                a.looseCheckEncoding(expectedEncoding, a.codeRange());
                return a.switchEncodingUncached(expectedEncoding);
            }
            a.checkEncoding(expectedEncoding);
            return a;
        }

        @Specialization(guards={"isEmpty(b)"})
        static TruffleString bEmptyMutable(MutableTruffleString a, AbstractTruffleString b, Encoding expectedEncoding, boolean lazy, @Bind Node node, @Cached.Shared(value="attributesNode") @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode attributesNode) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                a.looseCheckEncoding(expectedEncoding, a.codeRange());
                return a.switchEncodingUncached(expectedEncoding);
            }
            return attributesNode.execute(node, a, expectedEncoding);
        }

        @Specialization(guards={"!isEmpty(a)", "!isEmpty(b)"})
        static TruffleString doConcat(AbstractTruffleString a, AbstractTruffleString b, Encoding encoding, boolean lazy, @Bind Node node, @Cached TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode getCodeRangeANode, @Cached TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode getCodeRangeBNode, @Cached TStringInternalNodes.StrideFromCodeRangeNode getStrideNode, @Cached TStringInternalNodes.ConcatEagerNode concatEagerNode, @Cached AsTruffleStringNode asTruffleStringANode, @Cached AsTruffleStringNode asTruffleStringBNode, @Cached InlinedBranchProfile outOfMemoryProfile, @Cached InlinedConditionProfile lazyProfile) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            int codeRangeA = getCodeRangeANode.execute(node, a, encoding);
            int codeRangeB = getCodeRangeBNode.execute(node, b, encoding);
            a.looseCheckEncoding(encoding, codeRangeA);
            b.looseCheckEncoding(encoding, codeRangeB);
            int commonCodeRange = TSCodeRange.commonCodeRange(codeRangeA, codeRangeB);
            assert (!TStringGuards.isBrokenMultiByte(codeRangeA) && !TStringGuards.isBrokenMultiByte(codeRangeB) || TStringGuards.isBrokenMultiByte(commonCodeRange));
            int targetStride = getStrideNode.execute(node, commonCodeRange, encoding);
            int length = ConcatNode.addByteLengths(node, a, b, targetStride, outOfMemoryProfile);
            boolean valid = !TStringGuards.isBrokenMultiByte(commonCodeRange);
            if (lazyProfile.profile(node, lazy && valid && (a.isImmutable() || b.isImmutable()) && length << targetStride >= 40)) {
                if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                    return TruffleString.createLazyConcat(ConcatNode.asTruffleStringLoose(a, encoding), ConcatNode.asTruffleStringLoose(b, encoding), encoding, length, targetStride, commonCodeRange);
                }
                return TruffleString.createLazyConcat(asTruffleStringANode.execute(a, encoding), asTruffleStringBNode.execute(b, encoding), encoding, length, targetStride, commonCodeRange);
            }
            return concatEagerNode.execute(node, a, b, encoding, length, targetStride, commonCodeRange);
        }

        static int addByteLengths(Node node, AbstractTruffleString a, AbstractTruffleString b, int targetStride, InlinedBranchProfile outOfMemoryProfile) {
            long length = (long)a.length() + (long)b.length();
            if (length << targetStride > 0x7FFFFFF7L) {
                outOfMemoryProfile.enter(node);
                throw InternalErrors.outOfMemory();
            }
            return (int)length;
        }

        private static TruffleString asTruffleStringLoose(AbstractTruffleString a, Encoding encoding) {
            if (a.isImmutable()) {
                return (TruffleString)a;
            }
            return TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.getUncached().execute(TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.getUncached(), a, encoding);
        }

        @NeverDefault
        public static ConcatNode create() {
            return TruffleStringFactory.ConcatNodeGen.create();
        }

        public static ConcatNode getUncached() {
            return TruffleStringFactory.ConcatNodeGen.getUncached();
        }
    }

    public static abstract class RegionEqualByteIndexNode
    extends AbstractPublicNode {
        RegionEqualByteIndexNode() {
        }

        public final boolean execute(AbstractTruffleString a, int fromByteIndexA, AbstractTruffleString b, int fromByteIndexB, int length, Encoding expectedEncoding) {
            return this.execute(a, fromByteIndexA, b, fromByteIndexB, length, null, expectedEncoding);
        }

        public final boolean execute(AbstractTruffleString a, int fromByteIndexA, WithMask b, int fromByteIndexB, int length, Encoding expectedEncoding) {
            return this.execute(a, fromByteIndexA, b.string, fromByteIndexB, length, b.mask, expectedEncoding);
        }

        abstract boolean execute(AbstractTruffleString var1, int var2, AbstractTruffleString var3, int var4, int var5, byte[] var6, Encoding var7);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        boolean regionEquals(AbstractTruffleString a, int byteFromIndexA, AbstractTruffleString b, int byteFromIndexB, int byteLength, byte[] mask, Encoding expectedEncoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB) {
            if (byteLength == 0) {
                return true;
            }
            a.looseCheckEncoding(expectedEncoding, a.codeRange());
            b.looseCheckEncoding(expectedEncoding, b.codeRange());
            int fromIndexA = AbstractTruffleString.rawIndex(byteFromIndexA, expectedEncoding);
            int fromIndexB = AbstractTruffleString.rawIndex(byteFromIndexB, expectedEncoding);
            int length = AbstractTruffleString.rawIndex(byteLength, expectedEncoding);
            a.boundsCheckRegionRaw(fromIndexA, length);
            b.boundsCheckRegionRaw(fromIndexB, length);
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                boolean bl = TStringOps.regionEqualsWithOrMaskWithStride(this, a, arrayA, offsetA, a.stride(), fromIndexA, b, arrayB, offsetB, b.stride(), fromIndexB, mask, length);
                return bl;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static RegionEqualByteIndexNode create() {
            return TruffleStringFactory.RegionEqualByteIndexNodeGen.create();
        }

        public static RegionEqualByteIndexNode getUncached() {
            return TruffleStringFactory.RegionEqualByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class RegionEqualNode
    extends AbstractPublicNode {
        RegionEqualNode() {
        }

        public abstract boolean execute(AbstractTruffleString var1, int var2, AbstractTruffleString var3, int var4, int var5, Encoding var6);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final boolean regionEquals(AbstractTruffleString a, int fromIndexA, AbstractTruffleString b, int fromIndexB, int length, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthBNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.RegionEqualsNode regionEqualsNode) {
            if (length == 0) {
                return true;
            }
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encoding);
                int codeRangeB = getCodeRangeBNode.execute(this, b, arrayB, offsetB, encoding);
                a.looseCheckEncoding(encoding, codeRangeA);
                b.looseCheckEncoding(encoding, codeRangeB);
                a.boundsCheckRegion(this, arrayA, offsetA, fromIndexA, length, encoding, getCodePointLengthANode);
                b.boundsCheckRegion(this, arrayB, offsetB, fromIndexB, length, encoding, getCodePointLengthBNode);
                boolean bl = regionEqualsNode.execute(this, a, arrayA, offsetA, codeRangeA, fromIndexA, b, arrayB, offsetB, codeRangeB, fromIndexB, length, encoding);
                return bl;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static RegionEqualNode create() {
            return TruffleStringFactory.RegionEqualNodeGen.create();
        }

        public static RegionEqualNode getUncached() {
            return TruffleStringFactory.RegionEqualNodeGen.getUncached();
        }
    }

    public static abstract class CompareIntsUTF32Node
    extends AbstractPublicNode {
        CompareIntsUTF32Node() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        int compare(AbstractTruffleString a, AbstractTruffleString b, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB) {
            a.looseCheckEncoding(Encoding.UTF_32, a.codeRange());
            b.looseCheckEncoding(Encoding.UTF_32, b.codeRange());
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                int n;
                int cmp;
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                if ((a.stride() | b.stride()) == 0 && !a.isEmpty() && !b.isEmpty() && (cmp = TStringOps.readS0(arrayA, offsetA, a.length(), 0) - TStringOps.readS0(arrayB, offsetB, b.length(), 0)) != 0) {
                    int n2 = cmp;
                    return n2;
                }
                if (a == b) {
                    n = 0;
                    return n;
                }
                n = TStringOpsNodes.memcmp(this, a, arrayA, offsetA, b, arrayB, offsetB);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static CompareIntsUTF32Node create() {
            return TruffleStringFactory.CompareIntsUTF32NodeGen.create();
        }

        public static CompareIntsUTF32Node getUncached() {
            return TruffleStringFactory.CompareIntsUTF32NodeGen.getUncached();
        }
    }

    public static abstract class CompareCharsUTF16Node
    extends AbstractPublicNode {
        CompareCharsUTF16Node() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        int compare(AbstractTruffleString a, AbstractTruffleString b, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB) {
            a.looseCheckEncoding(Encoding.UTF_16, a.codeRange());
            b.looseCheckEncoding(Encoding.UTF_16, b.codeRange());
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                int n;
                int cmp;
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                if ((a.stride() | b.stride()) == 0 && !a.isEmpty() && !b.isEmpty() && (cmp = TStringOps.readS0(arrayA, offsetA, a.length(), 0) - TStringOps.readS0(arrayB, offsetB, b.length(), 0)) != 0) {
                    int n2 = cmp;
                    return n2;
                }
                if (a == b) {
                    n = 0;
                    return n;
                }
                n = TStringOpsNodes.memcmp(this, a, arrayA, offsetA, b, arrayB, offsetB);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static CompareCharsUTF16Node create() {
            return TruffleStringFactory.CompareCharsUTF16NodeGen.create();
        }

        public static CompareCharsUTF16Node getUncached() {
            return TruffleStringFactory.CompareCharsUTF16NodeGen.getUncached();
        }
    }

    public static abstract class CompareBytesNode
    extends AbstractPublicNode {
        CompareBytesNode() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, Encoding var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        int compare(AbstractTruffleString a, AbstractTruffleString b, Encoding expectedEncoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB) {
            a.looseCheckEncoding(expectedEncoding, a.codeRange());
            b.looseCheckEncoding(expectedEncoding, b.codeRange());
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                int n;
                int cmp;
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                if ((a.stride() | b.stride()) == 0 && !a.isEmpty() && !b.isEmpty() && (cmp = TStringOps.readS0(arrayA, offsetA, a.length(), 0) - TStringOps.readS0(arrayB, offsetB, b.length(), 0)) != 0) {
                    int n2 = cmp;
                    return n2;
                }
                if (a == b) {
                    n = 0;
                    return n;
                }
                n = TStringOpsNodes.memcmpBytes(this, a, arrayA, offsetA, b, arrayB, offsetB);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static CompareBytesNode create() {
            return TruffleStringFactory.CompareBytesNodeGen.create();
        }

        public static CompareBytesNode getUncached() {
            return TruffleStringFactory.CompareBytesNodeGen.getUncached();
        }
    }

    public static abstract class LastByteIndexOfStringNode
    extends AbstractPublicNode {
        LastByteIndexOfStringNode() {
        }

        public final int execute(AbstractTruffleString a, AbstractTruffleString b, int fromIndex, int toIndex, Encoding expectedEncoding) {
            return this.execute(a, b, fromIndex, toIndex, null, expectedEncoding);
        }

        public final int execute(AbstractTruffleString a, WithMask b, int fromIndex, int toIndex, Encoding expectedEncoding) {
            return this.execute(a, b.string, fromIndex, toIndex, b.mask, expectedEncoding);
        }

        abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, int var3, int var4, byte[] var5, Encoding var6);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int lastByteIndexOfString(AbstractTruffleString a, AbstractTruffleString b, int fromIndexB, int toIndexB, byte[] mask, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.LastIndexOfStringRawNode indexOfStringNode) {
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encoding);
                int codeRangeB = getCodeRangeBNode.execute(this, b, arrayB, offsetB, encoding);
                a.looseCheckEncoding(encoding, codeRangeA);
                b.looseCheckEncoding(encoding, codeRangeB);
                if (JCodings.JCODINGS_ENABLED && mask != null && TStringGuards.isUnsupportedEncoding(encoding) && !TStringGuards.isFixedWidth(codeRangeA)) {
                    throw InternalErrors.unsupportedOperation();
                }
                if (b.isEmpty()) {
                    int n = fromIndexB;
                    return n;
                }
                if (a.isEmpty()) {
                    int n = -1;
                    return n;
                }
                int fromIndex = AbstractTruffleString.rawIndex(fromIndexB, encoding);
                int toIndex = AbstractTruffleString.rawIndex(toIndexB, encoding);
                a.boundsCheckRaw(toIndex, fromIndex);
                if (TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, fromIndex - toIndex)) {
                    int n = -1;
                    return n;
                }
                int n = AbstractTruffleString.byteIndex(indexOfStringNode.execute(this, a, arrayA, offsetA, codeRangeA, b, arrayB, offsetB, codeRangeB, fromIndex, toIndex, mask, encoding), encoding);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static LastByteIndexOfStringNode create() {
            return TruffleStringFactory.LastByteIndexOfStringNodeGen.create();
        }

        public static LastByteIndexOfStringNode getUncached() {
            return TruffleStringFactory.LastByteIndexOfStringNodeGen.getUncached();
        }
    }

    public static abstract class LastIndexOfStringNode
    extends AbstractPublicNode {
        LastIndexOfStringNode() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, int var3, int var4, Encoding var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int lastIndexOfString(AbstractTruffleString a, AbstractTruffleString b, int fromIndex, int toIndex, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthBNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.LastIndexOfStringNode indexOfStringNode) {
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encoding);
                int codeRangeB = getCodeRangeBNode.execute(this, b, arrayB, offsetB, encoding);
                a.looseCheckEncoding(encoding, codeRangeA);
                b.looseCheckEncoding(encoding, codeRangeB);
                if (b.isEmpty()) {
                    int n = fromIndex;
                    return n;
                }
                if (a.isEmpty()) {
                    int n = -1;
                    return n;
                }
                a.boundsCheck(this, arrayA, offsetA, toIndex, fromIndex, encoding, getCodePointLengthANode);
                if (TStringGuards.indexOfCannotMatch(this, codeRangeA, b, arrayB, offsetB, codeRangeB, fromIndex - toIndex, encoding, getCodePointLengthBNode)) {
                    int n = -1;
                    return n;
                }
                int n = indexOfStringNode.execute(this, a, arrayA, offsetA, codeRangeA, b, arrayB, offsetB, codeRangeB, fromIndex, toIndex, encoding);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static LastIndexOfStringNode create() {
            return TruffleStringFactory.LastIndexOfStringNodeGen.create();
        }

        public static LastIndexOfStringNode getUncached() {
            return TruffleStringFactory.LastIndexOfStringNodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexOfStringNode
    extends AbstractPublicNode {
        ByteIndexOfStringNode() {
        }

        public final int execute(AbstractTruffleString a, AbstractTruffleString b, int fromByteIndex, int toByteIndex, Encoding expectedEncoding) {
            return this.execute(a, b, fromByteIndex, toByteIndex, null, expectedEncoding);
        }

        public final int execute(AbstractTruffleString a, WithMask b, int fromByteIndex, int toByteIndex, Encoding expectedEncoding) {
            return this.execute(a, b.string, fromByteIndex, toByteIndex, b.mask, expectedEncoding);
        }

        abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, int var3, int var4, byte[] var5, Encoding var6);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int indexOfString(AbstractTruffleString a, AbstractTruffleString b, int fromByteIndex, int toByteIndex, byte[] mask, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.IndexOfStringRawNode indexOfStringNode) {
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encoding);
                int codeRangeB = getCodeRangeBNode.execute(this, b, arrayB, offsetB, encoding);
                a.looseCheckEncoding(encoding, codeRangeA);
                b.looseCheckEncoding(encoding, codeRangeB);
                if (JCodings.JCODINGS_ENABLED && mask != null && !TStringGuards.isSupportedEncodingWithCompaction(encoding) && !TStringGuards.isFixedWidth(codeRangeA)) {
                    throw InternalErrors.unsupportedOperation();
                }
                if (b.isEmpty()) {
                    int n = fromByteIndex;
                    return n;
                }
                if (a.isEmpty()) {
                    int n = -1;
                    return n;
                }
                int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
                int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
                a.boundsCheckRaw(fromIndex, toIndex);
                if (TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, toIndex - fromIndex)) {
                    int n = -1;
                    return n;
                }
                int n = AbstractTruffleString.byteIndex(indexOfStringNode.execute(this, a, arrayA, offsetA, codeRangeA, b, arrayB, offsetB, codeRangeB, fromIndex, toIndex, mask, encoding), encoding);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static ByteIndexOfStringNode create() {
            return TruffleStringFactory.ByteIndexOfStringNodeGen.create();
        }

        public static ByteIndexOfStringNode getUncached() {
            return TruffleStringFactory.ByteIndexOfStringNodeGen.getUncached();
        }
    }

    public static abstract class IndexOfStringNode
    extends AbstractPublicNode {
        IndexOfStringNode() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, int var3, int var4, Encoding var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int indexOfString(AbstractTruffleString a, AbstractTruffleString b, int fromIndex, int toIndex, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthBNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.InternalIndexOfStringNode indexOfStringNode) {
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encoding);
                int codeRangeB = getCodeRangeBNode.execute(this, b, arrayB, offsetB, encoding);
                a.looseCheckEncoding(encoding, codeRangeA);
                b.looseCheckEncoding(encoding, codeRangeB);
                if (b.isEmpty()) {
                    int n = fromIndex;
                    return n;
                }
                if (a.isEmpty()) {
                    int n = -1;
                    return n;
                }
                a.boundsCheck(this, arrayA, offsetA, fromIndex, toIndex, encoding, getCodePointLengthANode);
                if (TStringGuards.indexOfCannotMatch(this, codeRangeA, b, arrayB, offsetB, codeRangeB, toIndex - fromIndex, encoding, getCodePointLengthBNode)) {
                    int n = -1;
                    return n;
                }
                int n = indexOfStringNode.execute(this, a, arrayA, offsetA, codeRangeA, b, arrayB, offsetB, codeRangeB, fromIndex, toIndex, encoding);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static IndexOfStringNode create() {
            return TruffleStringFactory.IndexOfStringNodeGen.create();
        }

        public static IndexOfStringNode getUncached() {
            return TruffleStringFactory.IndexOfStringNodeGen.getUncached();
        }
    }

    public static abstract class LastByteIndexOfCodePointNode
    extends AbstractPublicNode {
        LastByteIndexOfCodePointNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int var4, Encoding var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int doIndexOf(AbstractTruffleString a, int codepoint, int fromByteIndex, int toByteIndex, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.LastIndexOfCodePointRawNode lastIndexOfNode) {
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
            a.boundsCheckRaw(toIndex, fromIndex);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                int n = AbstractTruffleString.byteIndex(lastIndexOfNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, codepoint, fromIndex, toIndex), encoding);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static LastByteIndexOfCodePointNode create() {
            return TruffleStringFactory.LastByteIndexOfCodePointNodeGen.create();
        }

        public static LastByteIndexOfCodePointNode getUncached() {
            return TruffleStringFactory.LastByteIndexOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class LastIndexOfCodePointNode
    extends AbstractPublicNode {
        LastIndexOfCodePointNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int var4, Encoding var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int doIndexOf(AbstractTruffleString a, int codepoint, int fromIndex, int toIndex, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.LastIndexOfCodePointNode lastIndexOfNode) {
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                a.boundsCheck(this, arrayA, offsetA, toIndex, fromIndex, encoding, getCodePointLengthNode);
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                int n = lastIndexOfNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, codepoint, fromIndex, toIndex);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static LastIndexOfCodePointNode create() {
            return TruffleStringFactory.LastIndexOfCodePointNodeGen.create();
        }

        public static LastIndexOfCodePointNode getUncached() {
            return TruffleStringFactory.LastIndexOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexOfCodePointNode
    extends AbstractPublicNode {
        ByteIndexOfCodePointNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int var4, Encoding var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int doIndexOf(AbstractTruffleString a, int codepoint, int fromByteIndex, int toByteIndex, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.IndexOfCodePointRawNode indexOfNode) {
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
            a.boundsCheckRaw(fromIndex, toIndex);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                int n = AbstractTruffleString.byteIndex(indexOfNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, codepoint, fromIndex, toIndex), encoding);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ByteIndexOfCodePointNode create() {
            return TruffleStringFactory.ByteIndexOfCodePointNodeGen.create();
        }

        public static ByteIndexOfCodePointNode getUncached() {
            return TruffleStringFactory.ByteIndexOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class IndexOfCodePointNode
    extends AbstractPublicNode {
        IndexOfCodePointNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int var4, Encoding var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int doIndexOf(AbstractTruffleString a, int codepoint, int fromIndex, int toIndex, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.IndexOfCodePointNode indexOfNode) {
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                a.boundsCheck(this, arrayA, offsetA, fromIndex, toIndex, encoding, getCodePointLengthNode);
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                int n = indexOfNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, codepoint, fromIndex, toIndex);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static IndexOfCodePointNode create() {
            return TruffleStringFactory.IndexOfCodePointNodeGen.create();
        }

        public static IndexOfCodePointNode getUncached() {
            return TruffleStringFactory.IndexOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexOfCodePointSetNode
    extends AbstractPublicNode {
        ByteIndexOfCodePointSetNode() {
        }

        public final int execute(AbstractTruffleString a, int fromByteIndex, int toByteIndex, CodePointSet codePointSet) {
            return this.execute(a, fromByteIndex, toByteIndex, codePointSet, true);
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, CodePointSet var4, boolean var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"codePointSet == cachedCodePointSet"}, limit="1", excludeForUncached=true)
        static int indexOfSpecialized(AbstractTruffleString a, int fromByteIndex, int toByteIndex, CodePointSet codePointSet, boolean usePreciseCodeRange, @Bind Node node, @Cached @Cached.Exclusive InlinedConditionProfile managedProfileA, @Cached @Cached.Exclusive InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached(value="codePointSet") CodePointSet cachedCodePointSet, @Cached(value="cachedCodePointSet.createNode()") TStringInternalNodes.IndexOfCodePointSetNode internalNode) {
            Encoding encoding = cachedCodePointSet.encoding;
            CompilerAsserts.partialEvaluationConstant(codePointSet);
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            CompilerAsserts.partialEvaluationConstant(usePreciseCodeRange);
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
            a.boundsCheckRaw(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return -1;
            }
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(node, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = usePreciseCodeRange ? getPreciseCodeRangeNode.execute(node, a, arrayA, offsetA, encoding) : a.codeRange();
                int n = AbstractTruffleString.byteIndex(internalNode.execute(arrayA, offsetA, a.length(), a.stride(), codeRangeA, fromIndex, toIndex), encoding);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(replaces={"indexOfSpecialized"})
        int indexOfUncached(AbstractTruffleString a, int fromByteIndex, int toByteIndex, CodePointSet codePointSet, boolean usePreciseCodeRange, @Cached @Cached.Exclusive InlinedConditionProfile managedProfileA, @Cached @Cached.Exclusive InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            Encoding encoding = codePointSet.encoding;
            CompilerAsserts.partialEvaluationConstant(codePointSet);
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
            a.boundsCheckRaw(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return -1;
            }
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding);
                it.setRawIndex(fromIndex);
                while (it.getRawIndex() < toIndex) {
                    assert (it.hasNext());
                    int index = it.getByteIndex();
                    if (!IndexOfCodePointSet.IndexOfRangesNode.rangesContain(codePointSet.ranges, nextNode.execute(this, it, encoding))) continue;
                    int n = index;
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ByteIndexOfCodePointSetNode create() {
            return TruffleStringFactory.ByteIndexOfCodePointSetNodeGen.create();
        }

        public static ByteIndexOfCodePointSetNode getUncached() {
            return TruffleStringFactory.ByteIndexOfCodePointSetNodeGen.getUncached();
        }
    }

    public static final class CodePointSet {
        private final int[] ranges;
        private final Encoding encoding;
        private final IndexOfCodePointSet.IndexOfNode[] indexOfNodes;

        CodePointSet(int[] ranges, Encoding encoding, IndexOfCodePointSet.IndexOfNode[] indexOfNodes) {
            this.ranges = ranges;
            this.encoding = encoding;
            this.indexOfNodes = indexOfNodes;
        }

        @CompilerDirectives.TruffleBoundary
        public static CodePointSet fromRanges(int[] ranges, Encoding encoding) {
            int[] rangesDefensiveCopy = Arrays.copyOf(ranges, ranges.length);
            return new CodePointSet(rangesDefensiveCopy, encoding, IndexOfCodePointSet.fromRanges(rangesDefensiveCopy, encoding));
        }

        TStringInternalNodes.IndexOfCodePointSetNode createNode() {
            IndexOfCodePointSet.IndexOfNode[] nodesCopy = new IndexOfCodePointSet.IndexOfNode[this.indexOfNodes.length];
            for (int i = 0; i < this.indexOfNodes.length; ++i) {
                nodesCopy[i] = this.indexOfNodes[i].shallowCopy();
            }
            return TStringInternalNodesFactory.IndexOfCodePointSetNodeGen.create(nodesCopy, this.encoding);
        }

        public boolean isIntrinsicCandidate(CodeRange codeRange) {
            for (int i = 0; i < this.indexOfNodes.length - 1; ++i) {
                IndexOfCodePointSet.IndexOfNode node = this.indexOfNodes[i];
                if (TSCodeRange.ordinal(node.maxCodeRange) < codeRange.ordinal()) continue;
                return node.isFast();
            }
            return this.indexOfNodes[this.indexOfNodes.length - 1].isFast();
        }
    }

    public static abstract class IntIndexOfAnyIntUTF32Node
    extends AbstractPublicNode {
        IntIndexOfAnyIntUTF32Node() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int[] var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        int indexOfRaw(AbstractTruffleString a, int fromIntIndex, int maxIntIndex, int[] values, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringOpsNodes.IndexOfAnyIntNode indexOfNode) {
            a.checkEncoding(Encoding.UTF_32);
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheckRaw(fromIntIndex, maxIntIndex);
            if (fromIntIndex == maxIntIndex || TruffleString.noneInCodeRange((Node)this, a.codeRange(), values)) {
                return -1;
            }
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int n = indexOfNode.execute(this, a, arrayA, offsetA, fromIntIndex, maxIntIndex, values);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static IntIndexOfAnyIntUTF32Node create() {
            return TruffleStringFactory.IntIndexOfAnyIntUTF32NodeGen.create();
        }

        public static IntIndexOfAnyIntUTF32Node getUncached() {
            return TruffleStringFactory.IntIndexOfAnyIntUTF32NodeGen.getUncached();
        }
    }

    public static abstract class CharIndexOfAnyCharUTF16Node
    extends AbstractPublicNode {
        CharIndexOfAnyCharUTF16Node() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, char[] var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int indexOfRaw(AbstractTruffleString a, int fromCharIndex, int maxCharIndex, char[] values, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringOpsNodes.IndexOfAnyCharUTF16Node indexOfNode) {
            a.checkEncoding(Encoding.UTF_16);
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheckRaw(fromCharIndex, maxCharIndex);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, Encoding.UTF_16);
                if (fromCharIndex == maxCharIndex || TSCodeRange.isFixedWidth(codeRangeA) && TruffleString.noneInCodeRange((Node)this, codeRangeA, values)) {
                    int n = -1;
                    return n;
                }
                int n = indexOfNode.execute(this, a, arrayA, offsetA, fromCharIndex, maxCharIndex, values);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static CharIndexOfAnyCharUTF16Node create() {
            return TruffleStringFactory.CharIndexOfAnyCharUTF16NodeGen.create();
        }

        public static CharIndexOfAnyCharUTF16Node getUncached() {
            return TruffleStringFactory.CharIndexOfAnyCharUTF16NodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexOfAnyByteNode
    extends AbstractPublicNode {
        ByteIndexOfAnyByteNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, byte[] var4, Encoding var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        int indexOfRaw(AbstractTruffleString a, int fromByteIndex, int maxByteIndex, byte[] values, Encoding expectedEncoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA) {
            if (TStringGuards.isUTF16Or32(expectedEncoding)) {
                throw InternalErrors.illegalArgument("UTF-16 and UTF-32 not supported!");
            }
            a.checkEncoding(expectedEncoding);
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheckRaw(fromByteIndex, maxByteIndex);
            if (fromByteIndex == maxByteIndex || TSCodeRange.is7Bit(a.codeRange()) && TruffleString.noneIsAscii(this, values)) {
                return -1;
            }
            assert (TStringGuards.isStride0(a));
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int n = TStringOps.indexOfAnyByte(this, a, arrayA, offsetA, fromByteIndex, maxByteIndex, values);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ByteIndexOfAnyByteNode create() {
            return TruffleStringFactory.ByteIndexOfAnyByteNodeGen.create();
        }

        public static ByteIndexOfAnyByteNode getUncached() {
            return TruffleStringFactory.ByteIndexOfAnyByteNodeGen.getUncached();
        }
    }

    public static abstract class CodePointAtByteIndexNode
    extends AbstractPublicNode {
        CodePointAtByteIndexNode() {
        }

        public final int execute(AbstractTruffleString a, int i, Encoding expectedEncoding) {
            return this.execute(a, i, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract int execute(AbstractTruffleString var1, int var2, Encoding var3, ErrorHandling var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int readCodePoint(AbstractTruffleString a, int byteIndex, Encoding encoding, ErrorHandling errorHandling, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.CodePointAtRawNode readCodePointNode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            int i = AbstractTruffleString.rawIndex(byteIndex, encoding);
            a.checkEncoding(encoding);
            a.boundsCheckRaw(i);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                int n = readCodePointNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, i, errorHandling);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static CodePointAtByteIndexNode create() {
            return TruffleStringFactory.CodePointAtByteIndexNodeGen.create();
        }

        public static CodePointAtByteIndexNode getUncached() {
            return TruffleStringFactory.CodePointAtByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class CodePointAtIndexNode
    extends AbstractPublicNode {
        CodePointAtIndexNode() {
        }

        public final int execute(AbstractTruffleString a, int i, Encoding expectedEncoding) {
            return this.execute(a, i, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract int execute(AbstractTruffleString var1, int var2, Encoding var3, ErrorHandling var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int readCodePoint(AbstractTruffleString a, int i, Encoding encoding, ErrorHandling errorHandling, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.CodePointAtNode readCodePointNode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            a.checkEncoding(encoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                a.boundsCheck(this, arrayA, offsetA, i, encoding, getCodePointLengthNode);
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                int n = readCodePointNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, i, errorHandling);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static CodePointAtIndexNode create() {
            return TruffleStringFactory.CodePointAtIndexNodeGen.create();
        }

        public static CodePointAtIndexNode getUncached() {
            return TruffleStringFactory.CodePointAtIndexNodeGen.getUncached();
        }
    }

    public static abstract class CodePointIndexToByteIndexNode
    extends AbstractPublicNode {
        CodePointIndexToByteIndexNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, Encoding var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int translate(AbstractTruffleString a, int byteOffset, int codepointIndex, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.CodePointIndexToRawNode codePointIndexToRawNode) {
            a.checkEncoding(encoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                a.boundsCheckRegion(this, arrayA, offsetA, 0, codepointIndex, encoding, getCodePointLengthNode);
                int rawOffset = AbstractTruffleString.rawIndex(byteOffset, encoding);
                a.boundsCheckRawLength(rawOffset);
                if (codepointIndex == 0) {
                    int n = 0;
                    return n;
                }
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                int n = codePointIndexToRawNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, rawOffset, codepointIndex, true) << encoding.naturalStride;
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static CodePointIndexToByteIndexNode create() {
            return TruffleStringFactory.CodePointIndexToByteIndexNodeGen.create();
        }

        public static CodePointIndexToByteIndexNode getUncached() {
            return TruffleStringFactory.CodePointIndexToByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexToCodePointIndexNode
    extends AbstractPublicNode {
        ByteIndexToCodePointIndexNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, Encoding var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int translate(AbstractTruffleString a, int byteOffset, int byteIndex, Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.RawIndexToCodePointIndexNode rawIndexToCodePointIndexNode) {
            a.checkEncoding(encoding);
            int rawOffset = AbstractTruffleString.rawIndex(byteOffset, encoding);
            int rawIndex = AbstractTruffleString.rawIndex(byteIndex, encoding);
            a.boundsCheckRegionRaw(rawOffset, rawIndex);
            if (byteIndex == 0) {
                return 0;
            }
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                int n = rawIndexToCodePointIndexNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, byteOffset, rawIndex);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ByteIndexToCodePointIndexNode create() {
            return TruffleStringFactory.ByteIndexToCodePointIndexNodeGen.create();
        }

        public static ByteIndexToCodePointIndexNode getUncached() {
            return TruffleStringFactory.ByteIndexToCodePointIndexNodeGen.getUncached();
        }
    }

    public static abstract class ByteLengthOfCodePointNode
    extends AbstractPublicNode {
        ByteLengthOfCodePointNode() {
        }

        public final int execute(AbstractTruffleString a, int byteIndex, Encoding expectedEncoding) {
            return this.execute(a, byteIndex, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract int execute(AbstractTruffleString var1, int var2, Encoding var3, ErrorHandling var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int translate(AbstractTruffleString a, int byteIndex, Encoding encoding, ErrorHandling errorHandling, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.ByteLengthOfCodePointNode byteLengthOfCodePointNode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            a.checkEncoding(encoding);
            int rawIndex = AbstractTruffleString.rawIndex(byteIndex, encoding);
            a.boundsCheckRaw(rawIndex);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRangeA = getCodeRangeNode.execute(this, a, arrayA, offsetA, encoding);
                int n = byteLengthOfCodePointNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, rawIndex, errorHandling);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ByteLengthOfCodePointNode create() {
            return TruffleStringFactory.ByteLengthOfCodePointNodeGen.create();
        }

        public static ByteLengthOfCodePointNode getUncached() {
            return TruffleStringFactory.ByteLengthOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class ReadCharUTF16Node
    extends AbstractPublicNode {
        ReadCharUTF16Node() {
        }

        public abstract char execute(AbstractTruffleString var1, int var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final char doRead(AbstractTruffleString a, int i, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile utf16S0Profile) {
            a.checkEncoding(Encoding.UTF_16);
            a.boundsCheckRaw(i);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (utf16S0Profile.profile(this, TStringGuards.isStride0(a))) {
                    char c = (char)TStringOps.readS0(a, arrayA, offsetA, i);
                    return c;
                }
                assert (TStringGuards.isStride1(a));
                char c = TStringOps.readS1(a, arrayA, offsetA, i);
                return c;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ReadCharUTF16Node create() {
            return TruffleStringFactory.ReadCharUTF16NodeGen.create();
        }

        public static ReadCharUTF16Node getUncached() {
            return TruffleStringFactory.ReadCharUTF16NodeGen.getUncached();
        }
    }

    public static abstract class ReadByteNode
    extends AbstractPublicNode {
        ReadByteNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, Encoding var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final int doRead(AbstractTruffleString a, int i, Encoding expectedEncoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.ReadByteNode readByteNode) {
            a.checkEncoding(expectedEncoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int n = readByteNode.execute(this, a, arrayA, offsetA, i, expectedEncoding);
                return n;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ReadByteNode create() {
            return TruffleStringFactory.ReadByteNodeGen.create();
        }

        public static ReadByteNode getUncached() {
            return TruffleStringFactory.ReadByteNodeGen.getUncached();
        }
    }

    public static abstract class CodePointLengthNode
    extends AbstractPublicNode {
        CodePointLengthNode() {
        }

        public abstract int execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final int get(AbstractTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.GetCodePointLengthWithMaterializationNode getCodePointLengthNode) {
            a.checkEncoding(expectedEncoding);
            return getCodePointLengthNode.execute(this, a, expectedEncoding);
        }

        @NeverDefault
        public static CodePointLengthNode create() {
            return TruffleStringFactory.CodePointLengthNodeGen.create();
        }

        public static CodePointLengthNode getUncached() {
            return TruffleStringFactory.CodePointLengthNodeGen.getUncached();
        }
    }

    public static abstract class GetStringCompactionLevelNode
    extends AbstractPublicNode {
        GetStringCompactionLevelNode() {
        }

        public abstract CompactionLevel execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        static CompactionLevel getStringCompactionLevel(AbstractTruffleString a, Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            int stride = a.stride();
            if (CompilerDirectives.isPartialEvaluationConstant((Object)expectedEncoding)) {
                if (TStringGuards.isUTF16(expectedEncoding)) {
                    return stride == 0 ? CompactionLevel.S1 : CompactionLevel.S2;
                }
                if (TStringGuards.isUTF32(expectedEncoding)) {
                    return CompactionLevel.fromStride(stride);
                }
                return CompactionLevel.S1;
            }
            return CompactionLevel.fromStride(stride);
        }

        @NeverDefault
        public static GetStringCompactionLevelNode create() {
            return TruffleStringFactory.GetStringCompactionLevelNodeGen.create();
        }

        public static GetStringCompactionLevelNode getUncached() {
            return TruffleStringFactory.GetStringCompactionLevelNodeGen.getUncached();
        }
    }

    public static final class CompactionLevel
    extends Enum<CompactionLevel> {
        public static final /* enum */ CompactionLevel S1 = new CompactionLevel(1, 0);
        public static final /* enum */ CompactionLevel S2 = new CompactionLevel(2, 1);
        public static final /* enum */ CompactionLevel S4 = new CompactionLevel(4, 2);
        private final int bytes;
        private final int log2;
        private static final /* synthetic */ CompactionLevel[] $VALUES;

        public static CompactionLevel[] values() {
            return (CompactionLevel[])$VALUES.clone();
        }

        public static CompactionLevel valueOf(String name) {
            return Enum.valueOf(CompactionLevel.class, name);
        }

        private CompactionLevel(int bytes, int log2) {
            this.bytes = bytes;
            this.log2 = log2;
        }

        int getStride() {
            return this.log2;
        }

        public final int getBytes() {
            return this.bytes;
        }

        public final int getLog2() {
            return this.log2;
        }

        static CompactionLevel fromStride(int stride) {
            assert (Stride.isStride(stride));
            if (stride == 0) {
                return S1;
            }
            if (stride == 1) {
                return S2;
            }
            assert (stride == 2);
            return S4;
        }

        private static /* synthetic */ CompactionLevel[] $values() {
            return new CompactionLevel[]{S1, S2, S4};
        }

        static {
            $VALUES = CompactionLevel.$values();
        }
    }

    public static abstract class IsValidNode
    extends AbstractPublicNode {
        IsValidNode() {
        }

        public abstract boolean execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final boolean isValid(AbstractTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.GetValidOrBrokenCodeRangeNode getCodeRangeNode) {
            a.checkEncoding(expectedEncoding);
            return !TStringGuards.isBroken(getCodeRangeNode.execute(this, a, expectedEncoding));
        }

        @NeverDefault
        public static IsValidNode create() {
            return TruffleStringFactory.IsValidNodeGen.create();
        }

        public static IsValidNode getUncached() {
            return TruffleStringFactory.IsValidNodeGen.getUncached();
        }
    }

    public static abstract class CodeRangeEqualsNode
    extends AbstractPublicNode {
        CodeRangeEqualsNode() {
        }

        public abstract boolean execute(AbstractTruffleString var1, CodeRange var2);

        @Specialization
        final boolean codeRangeEquals(AbstractTruffleString a, CodeRange codeRange, @Cached TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode getPreciseCodeRangeNode) {
            return CodeRange.equals(getPreciseCodeRangeNode.execute(this, a, Encoding.get(a.encoding())), codeRange);
        }

        @NeverDefault
        public static CodeRangeEqualsNode create() {
            return TruffleStringFactory.CodeRangeEqualsNodeGen.create();
        }

        public static CodeRangeEqualsNode getUncached() {
            return TruffleStringFactory.CodeRangeEqualsNodeGen.getUncached();
        }
    }

    public static abstract class GetByteCodeRangeNode
    extends AbstractPublicNode {
        GetByteCodeRangeNode() {
        }

        public abstract CodeRange execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final CodeRange getCodeRange(AbstractTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode getPreciseCodeRangeNode) {
            a.checkEncoding(expectedEncoding);
            return CodeRange.getByteCodeRange(getPreciseCodeRangeNode.execute(this, a, expectedEncoding), expectedEncoding);
        }

        @NeverDefault
        public static GetByteCodeRangeNode create() {
            return TruffleStringFactory.GetByteCodeRangeNodeGen.create();
        }

        public static GetByteCodeRangeNode getUncached() {
            return TruffleStringFactory.GetByteCodeRangeNodeGen.getUncached();
        }
    }

    public static abstract class GetCodeRangeImpreciseNode
    extends AbstractPublicNode {
        GetCodeRangeImpreciseNode() {
        }

        public abstract CodeRange execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        static CodeRange getCodeRange(AbstractTruffleString a, Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            return CodeRange.get(a.codeRange());
        }

        @NeverDefault
        public static GetCodeRangeImpreciseNode create() {
            return TruffleStringFactory.GetCodeRangeImpreciseNodeGen.create();
        }

        public static GetCodeRangeImpreciseNode getUncached() {
            return TruffleStringFactory.GetCodeRangeImpreciseNodeGen.getUncached();
        }
    }

    public static abstract class GetCodeRangeNode
    extends AbstractPublicNode {
        GetCodeRangeNode() {
        }

        public abstract CodeRange execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final CodeRange getCodeRange(AbstractTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode getPreciseCodeRangeNode) {
            a.checkEncoding(expectedEncoding);
            return CodeRange.get(getPreciseCodeRangeNode.execute(this, a, expectedEncoding));
        }

        @NeverDefault
        public static GetCodeRangeNode create() {
            return TruffleStringFactory.GetCodeRangeNodeGen.create();
        }

        public static GetCodeRangeNode getUncached() {
            return TruffleStringFactory.GetCodeRangeNodeGen.getUncached();
        }
    }

    public static abstract class MaterializeNode
    extends AbstractPublicNode {
        MaterializeNode() {
        }

        public abstract void execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final void doMaterialize(AbstractTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.ToIndexableNode toIndexableNode) {
            a.checkEncoding(expectedEncoding);
            toIndexableNode.execute(this, a, a.data());
            assert (a.isMaterialized());
        }

        @NeverDefault
        public static MaterializeNode create() {
            return TruffleStringFactory.MaterializeNodeGen.create();
        }

        public static MaterializeNode getUncached() {
            return TruffleStringFactory.MaterializeNodeGen.getUncached();
        }
    }

    public static abstract class AsManagedNode
    extends AbstractPublicNode {
        AsManagedNode() {
        }

        public final TruffleString execute(AbstractTruffleString a, Encoding expectedEncoding) {
            return this.execute(a, expectedEncoding, false);
        }

        public abstract TruffleString execute(AbstractTruffleString var1, Encoding var2, boolean var3);

        @Specialization(guards={"!a.isNative()"})
        static TruffleString managedImmutable(TruffleString a, Encoding expectedEncoding, boolean cacheResult) {
            CompilerAsserts.partialEvaluationConstant(cacheResult);
            a.checkEncoding(expectedEncoding);
            assert (!(a.data() instanceof AbstractTruffleString.NativePointer));
            return a;
        }

        @Specialization(guards={"a.isNative()"})
        TruffleString nativeImmutable(TruffleString a, Encoding encoding, boolean cacheResult, @Cached InlinedConditionProfile cacheHit, @Cached.Shared(value="attributesNode") @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode attributesNode) {
            CompilerAsserts.partialEvaluationConstant(cacheResult);
            a.checkEncoding(encoding);
            TruffleString cur = a.next;
            assert (!a.isJavaString());
            if (cacheResult && cur != null) {
                while (cur != a && (cur.isNative() || cur.isJavaString() || !cur.isCompatibleToIntl(encoding))) {
                    cur = cur.next;
                }
                if (cacheHit.profile(this, cur != a)) {
                    assert (cur.isCompatibleToIntl(encoding) && cur.isManaged() && !cur.isJavaString());
                    return cur;
                }
            }
            TruffleString managed = attributesNode.execute(this, a, !cacheResult, encoding);
            if (cacheResult) {
                a.cacheInsert(managed);
            }
            return managed;
        }

        @Specialization
        TruffleString mutable(MutableTruffleString a, Encoding expectedEncoding, boolean cacheResult, @Cached.Shared(value="attributesNode") @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode attributesNode) {
            CompilerAsserts.partialEvaluationConstant(cacheResult);
            a.checkEncoding(expectedEncoding);
            return attributesNode.execute(this, a, expectedEncoding);
        }

        @NeverDefault
        public static AsManagedNode create() {
            return TruffleStringFactory.AsManagedNodeGen.create();
        }

        public static AsManagedNode getUncached() {
            return TruffleStringFactory.AsManagedNodeGen.getUncached();
        }
    }

    static abstract class InternalAsTruffleStringNode
    extends AbstractInternalNode {
        InternalAsTruffleStringNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Encoding var3);

        @Specialization
        static TruffleString immutable(TruffleString a, Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            return a;
        }

        @Specialization
        static TruffleString fromMutableString(Node node, MutableTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode fromBufferWithStringCompactionNode) {
            return fromBufferWithStringCompactionNode.execute(node, a, expectedEncoding);
        }
    }

    public static abstract class AsTruffleStringNode
    extends AbstractPublicNode {
        AsTruffleStringNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final TruffleString doDefault(AbstractTruffleString value, Encoding expectedEncoding, @Cached InternalAsTruffleStringNode internalNode) {
            return internalNode.execute(this, value, expectedEncoding);
        }

        @NeverDefault
        public static AsTruffleStringNode create() {
            return TruffleStringFactory.AsTruffleStringNodeGen.create();
        }

        public static AsTruffleStringNode getUncached() {
            return TruffleStringFactory.AsTruffleStringNodeGen.getUncached();
        }
    }

    public static enum ErrorHandling {
        BEST_EFFORT(DecodingErrorHandler.DEFAULT),
        RETURN_NEGATIVE(DecodingErrorHandler.RETURN_NEGATIVE);

        final DecodingErrorHandler errorHandler;

        private ErrorHandling(DecodingErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }
    }

    public static final class WithMask {
        final AbstractTruffleString string;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final byte[] mask;

        WithMask(AbstractTruffleString string, byte[] mask) {
            this.string = string;
            this.mask = mask;
        }

        public static WithMask createUncached(AbstractTruffleString a, byte[] mask, Encoding expectedEncoding) {
            return CreateNode.getUncached().execute(a, mask, expectedEncoding);
        }

        public static WithMask createUTF16Uncached(AbstractTruffleString a, char[] mask) {
            return CreateUTF16Node.getUncached().execute(a, mask);
        }

        public static WithMask createUTF32Uncached(AbstractTruffleString a, int[] mask) {
            return CreateUTF32Node.getUncached().execute(a, mask);
        }

        private static void checkMaskLength(AbstractTruffleString string, int length) {
            if (length != string.length()) {
                throw InternalErrors.illegalArgument("mask length does not match string length!");
            }
        }

        public static abstract class CreateNode
        extends AbstractPublicNode {
            CreateNode() {
            }

            public abstract WithMask execute(AbstractTruffleString var1, byte[] var2, Encoding var3);

            @Specialization
            WithMask doCreate(AbstractTruffleString a, byte[] mask, Encoding expectedEncoding) {
                if (expectedEncoding == Encoding.UTF_16 || expectedEncoding == Encoding.UTF_32) {
                    throw InternalErrors.illegalArgument("use a CreateUTF16Node for UTF-16, and CreateUTF32Node for UTF-32");
                }
                a.checkEncoding(expectedEncoding);
                WithMask.checkMaskLength(a, mask.length);
                assert (TStringGuards.isStride0(a));
                return new WithMask(a, Arrays.copyOf(mask, mask.length));
            }

            @NeverDefault
            public static CreateNode create() {
                return TruffleStringFactory.WithMaskFactory.CreateNodeGen.create();
            }

            public static CreateNode getUncached() {
                return TruffleStringFactory.WithMaskFactory.CreateNodeGen.getUncached();
            }
        }

        public static abstract class CreateUTF16Node
        extends AbstractPublicNode {
            CreateUTF16Node() {
            }

            public abstract WithMask execute(AbstractTruffleString var1, char[] var2);

            @Specialization
            WithMask doCreate(AbstractTruffleString a, char[] mask) {
                a.checkEncoding(Encoding.UTF_16);
                WithMask.checkMaskLength(a, mask.length);
                byte[] maskBytes = new byte[a.length() << a.stride()];
                if (a.stride() == 0) {
                    TStringOps.arraycopyWithStrideCB(this, mask, TStringUnsafe.charArrayBaseOffset(), maskBytes, TStringUnsafe.byteArrayBaseOffset(), 0, mask.length);
                } else {
                    TStringOps.arraycopyWithStrideCB(this, mask, TStringUnsafe.charArrayBaseOffset(), maskBytes, TStringUnsafe.byteArrayBaseOffset(), 1, mask.length);
                }
                return new WithMask(a, maskBytes);
            }

            @NeverDefault
            public static CreateUTF16Node create() {
                return TruffleStringFactory.WithMaskFactory.CreateUTF16NodeGen.create();
            }

            public static CreateUTF16Node getUncached() {
                return TruffleStringFactory.WithMaskFactory.CreateUTF16NodeGen.getUncached();
            }
        }

        public static abstract class CreateUTF32Node
        extends AbstractPublicNode {
            CreateUTF32Node() {
            }

            public abstract WithMask execute(AbstractTruffleString var1, int[] var2);

            @Specialization
            WithMask doCreate(AbstractTruffleString a, int[] mask) {
                a.checkEncoding(Encoding.UTF_32);
                WithMask.checkMaskLength(a, mask.length);
                byte[] maskBytes = new byte[a.length() << a.stride()];
                if (a.stride() == 0) {
                    TStringOps.arraycopyWithStrideIB(this, mask, TStringUnsafe.intArrayBaseOffset(), maskBytes, TStringUnsafe.byteArrayBaseOffset(), 0, mask.length);
                } else if (a.stride() == 1) {
                    TStringOps.arraycopyWithStrideIB(this, mask, TStringUnsafe.intArrayBaseOffset(), maskBytes, TStringUnsafe.byteArrayBaseOffset(), 1, mask.length);
                } else {
                    TStringOps.arraycopyWithStrideIB(this, mask, TStringUnsafe.intArrayBaseOffset(), maskBytes, TStringUnsafe.byteArrayBaseOffset(), 2, mask.length);
                }
                return new WithMask(a, maskBytes);
            }

            @NeverDefault
            public static CreateUTF32Node create() {
                return TruffleStringFactory.WithMaskFactory.CreateUTF32NodeGen.create();
            }

            public static CreateUTF32Node getUncached() {
                return TruffleStringFactory.WithMaskFactory.CreateUTF32NodeGen.getUncached();
            }
        }
    }
}

