/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.jdt;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.tools.internal.generator.jdt.ASTProcessor;
import com.ibm.db2.cmx.tools.internal.generator.jdt.NodeProcessor;
import com.ibm.db2.cmx.tools.internal.generator.jdt.TypeHelper;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;

public class NodeProcessorForMDM
extends NodeProcessor {
    public NodeProcessorForMDM(Map<String, IBinding> map, ClassInfo classInfo) {
        super(map, classInfo);
    }

    @Override
    public void processParameter(SingleVariableDeclaration singleVariableDeclaration, TypeInfo typeInfo, MethodInfo methodInfo, int n2) {
        typeInfo.setName(singleVariableDeclaration.getName().getFullyQualifiedName());
        typeInfo.setVarargs(singleVariableDeclaration.isVarargs());
        this.processType(singleVariableDeclaration.getType(), typeInfo, methodInfo, n2, true);
        this.setBaseType(typeInfo, methodInfo);
    }

    @Override
    public void processReturnType(Type type, TypeInfo typeInfo, MethodInfo methodInfo, int n2) {
        this.processType(type, typeInfo, methodInfo, 1, false);
        typeInfo.setTypeString(type.toString());
        methodInfo.setReturnType(typeInfo);
        this.setBaseType(typeInfo, methodInfo);
    }

    @Override
    String getModifierAsString(List<ASTNode> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ASTNode aSTNode : list) {
            if (aSTNode.getClass() != Modifier.class) continue;
            Modifier modifier = (Modifier)aSTNode;
            stringBuffer.append(modifier.getKeyword().toString());
        }
        return stringBuffer.toString();
    }

    @Override
    void processModifierAndAnnotations(List<ASTNode> list, MethodInfo methodInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ASTNode aSTNode : list) {
            switch (aSTNode.getNodeType()) {
                case 83: {
                    stringBuffer.append(((Modifier)aSTNode).getKeyword().toString());
                    break;
                }
                case 77: {
                    NormalAnnotation normalAnnotation = (NormalAnnotation)aSTNode;
                    IAnnotationBinding iAnnotationBinding = normalAnnotation.resolveAnnotationBinding();
                    if (iAnnotationBinding == null) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESOLVE_NODE", normalAnnotation.toString()), null, 10143, null, methodInfo);
                    }
                    IMemberValuePairBinding[] iMemberValuePairBindingArray = iAnnotationBinding.getAnnotationType();
                    Object object = this.getAnnotationType(iAnnotationBinding);
                    Object object2 = iAnnotationBinding.getDeclaredMemberValuePairs();
                    if (!iMemberValuePairBindingArray.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_SELECT_KEY)) && !iMemberValuePairBindingArray.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_UPDATE_KEY)) && !iMemberValuePairBindingArray.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_CALL_KEY))) break;
                    methodInfo.setAnnotationType((Class<?>)object);
                    this.processMemberVauePairForAnnotation((IMemberValuePairBinding[])object2, methodInfo);
                    break;
                }
                case 79: {
                    NormalAnnotation normalAnnotation = (SingleMemberAnnotation)aSTNode;
                    IAnnotationBinding iAnnotationBinding = normalAnnotation.resolveAnnotationBinding();
                    if (iAnnotationBinding == null) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESOLVE_NODE", normalAnnotation.toString()), null, 10144, null, methodInfo);
                    }
                    IMemberValuePairBinding[] iMemberValuePairBindingArray = iAnnotationBinding.getDeclaredMemberValuePairs();
                    Object object = iAnnotationBinding.getAnnotationType();
                    Object object2 = this.getAnnotationType(iAnnotationBinding);
                    if (!object.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_SELECT_KEY)) && !object.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_UPDATE_KEY)) && !object.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_CALL_KEY))) break;
                    methodInfo.setAnnotationType((Class<?>)object2);
                    this.processMemberVauePairForAnnotation(iMemberValuePairBindingArray, methodInfo);
                }
            }
            methodInfo.setModifier(stringBuffer.toString());
        }
    }

    private void processMemberVauePairForAnnotation(IMemberValuePairBinding[] iMemberValuePairBindingArray, MethodInfo methodInfo) {
        for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray) {
            String string;
            String string2 = iMemberValuePairBinding.getName();
            if ("sql".equals(string2) || "value".equals(string2)) {
                string = (String)iMemberValuePairBinding.getValue();
                if (iMemberValuePairBinding.isDefault() && "".equals(string)) continue;
                methodInfo.setSql(string);
                continue;
            }
            if (!"pattern".equals(string2)) continue;
            string = (String)iMemberValuePairBinding.getValue();
            methodInfo.setPatternString(string);
            this.processPattern(methodInfo);
        }
    }

    void processSimpleTypeForOutput(SimpleType simpleType, TypeInfo typeInfo, MethodInfo methodInfo) {
        ITypeBinding iTypeBinding = this.processSimpleType(simpleType, typeInfo, methodInfo);
        if (typeInfo.isBeanType()) {
            this.processBeanInformationForOutput(iTypeBinding.getErasure(), methodInfo, simpleType);
        }
    }

    @Override
    void processSimpleType(SimpleType simpleType, TypeInfo typeInfo, MethodInfo methodInfo, int n2, boolean bl2) {
        ITypeBinding iTypeBinding = this.processSimpleType(simpleType, typeInfo, methodInfo);
        if (typeInfo.isBeanType()) {
            this.processBeanInformation(iTypeBinding.getErasure(), methodInfo, simpleType, n2, bl2);
        }
    }

    public boolean isJavaLangObject(ITypeBinding iTypeBinding, String string) {
        return iTypeBinding.isTopLevel() && string != null && string.startsWith("java.");
    }

    public String getFieldName(String string) {
        if ((string.startsWith("set") || string.startsWith("get")) && string.length() > 3) {
            return string.substring(3, 4).toLowerCase() + string.substring(4);
        }
        return null;
    }

    public String getFieldNameForInput(String string) {
        if ((string.startsWith("set") || string.startsWith("get")) && string.length() > 3) {
            return string.substring(3, 4).toLowerCase() + string.substring(4);
        }
        return null;
    }

    private ITypeBinding getParameterOrReturnTypeBinding(IMethodBinding iMethodBinding, String string) {
        ITypeBinding iTypeBinding = null;
        if (string.startsWith("get")) {
            iTypeBinding = iMethodBinding.getReturnType();
        } else if (string.startsWith("set")) {
            ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
            iTypeBinding = iTypeBindingArray.length > 0 ? iTypeBindingArray[0] : null;
        }
        return iTypeBinding;
    }

    private void addPropertyToBeanInfoMap(Map<String, BeanPropertyInformation> map, BeanInformation beanInformation, String string, TypeInfo typeInfo, String string2, boolean bl2) {
        BeanPropertyInformation beanPropertyInformation = null;
        Map<String, BeanPropertyInformation> map2 = beanInformation.getBeanPropertyMap();
        String string3 = string.toLowerCase();
        if (map2.size() == 0 || (beanPropertyInformation = map2.get(string3)) == null) {
            beanPropertyInformation = new BeanPropertyInformation();
            beanPropertyInformation.setCaseSensitivePropertyName(string);
            map.put(string3, beanPropertyInformation);
        }
        if (bl2) {
            beanPropertyInformation.setCaseSensitivePropertyName(string);
            beanPropertyInformation.setField(string);
            beanPropertyInformation.setPropertyTypeInfo(typeInfo);
        }
        if (string2 != null) {
            map.put(string2.toLowerCase(), beanPropertyInformation);
        } else if (bl2) {
            map.put(string.toLowerCase(), beanPropertyInformation);
        }
    }

    private String getAnnotationValue(Map<String, String> map, Map<String, String> map2, Map<String, String> map3, IVariableBinding iVariableBinding, String string) {
        String string2 = null;
        if (map3.size() > 0) {
            string2 = map3.get(string);
        }
        if (string2 == null && map.size() > 0) {
            string2 = map.get(string);
        }
        if (string2 == null) {
            this.getColumnAnnotationOnField(iVariableBinding, string, map2);
            if (map2.size() > 0) {
                string2 = map2.get(string);
            }
        }
        return string2 == null ? null : string2.toLowerCase();
    }

    private void getColumnOverrideMap(List<ITypeBinding> list, Map<String, String> map, SimpleType simpleType, MethodInfo methodInfo) {
        for (int i10 = 0; i10 < list.size(); ++i10) {
            IAnnotationBinding[] iAnnotationBindingArray;
            boolean bl2 = false;
            boolean bl3 = false;
            ITypeBinding iTypeBinding = list.get(i10);
            for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iTypeBinding.getAnnotations()) {
                ITypeBinding iTypeBinding2 = iAnnotationBinding.getAnnotationType();
                String string = iTypeBinding2.getQualifiedName();
                if ("com.ibm.db2.cmx.annotation.ColumnOverrides".equals(string)) {
                    IMemberValuePairBinding[] iMemberValuePairBindingArray;
                    if (bl3) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_COLOVER", iTypeBinding.getQualifiedName()), null, 10145, (ASTNode)simpleType, methodInfo);
                    }
                    bl2 = true;
                    for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getDeclaredMemberValuePairs()) {
                        Object[] objectArray;
                        for (Object object : objectArray = (Object[])iMemberValuePairBinding.getValue()) {
                            IAnnotationBinding iAnnotationBinding2 = (IAnnotationBinding)object;
                            this.getColumnOverrideAnnotation(map, iAnnotationBinding2);
                        }
                    }
                    continue;
                }
                if (!"com.ibm.db2.cmx.annotation.ColumnOverride".equals(string)) continue;
                if (bl2) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_COLOVER2", iTypeBinding.getQualifiedName()), null, 10146, (ASTNode)simpleType, methodInfo);
                }
                bl3 = true;
                this.getColumnOverrideAnnotation(map, iAnnotationBinding);
            }
            iTypeBinding = iTypeBinding.getSuperclass();
        }
    }

    private void getColumnOverrideAnnotation(Map<String, String> map, IAnnotationBinding iAnnotationBinding) {
        IMemberValuePairBinding[] iMemberValuePairBindingArray;
        String string = null;
        String string2 = null;
        for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getAllMemberValuePairs()) {
            String string3 = iMemberValuePairBinding.getName();
            if ("propertyName".equals(string3)) {
                string2 = (String)iMemberValuePairBinding.getValue();
                if (iMemberValuePairBinding.isDefault() || "".equals(string2)) {
                    string2 = null;
                }
            }
            if (!"column".equals(string3)) continue;
            string = (String)iMemberValuePairBinding.getValue();
            if (!iMemberValuePairBinding.isDefault() && !"".equals(string)) continue;
            string = null;
        }
        if (string != null && string2 != null) {
            map.put(string2, string.toLowerCase());
        }
    }

    void processMethodInformation(String string, String string2, IMethodBinding iMethodBinding, int n2, SimpleType simpleType, BeanInformation beanInformation, IMethodBinding[] iMethodBindingArray, Map<String, String> map) {
        boolean bl2 = false;
        boolean bl3 = false;
        bl2 = string.startsWith("get");
        bl3 = string.startsWith("set");
        String string3 = null;
        ITypeBinding iTypeBinding = this.getParameterOrReturnTypeBinding(iMethodBinding, string);
        if (iTypeBinding != null) {
            TypeInfo typeInfo = this.setTypeInfo(string2, iTypeBinding, simpleType);
            if (bl2) {
                string3 = "set" + string2.substring(0, 1).toUpperCase() + string2.substring(1);
            } else if (bl3) {
                string3 = "get" + string2.substring(0, 1).toUpperCase() + string2.substring(1);
            }
            IMethodBinding iMethodBinding2 = this.findMatchingAccessorMethodAndSetBeanInfo(beanInformation, bl2, iMethodBindingArray, n2, string, string2, string3, iTypeBinding, typeInfo);
            if (iMethodBinding2 != null) {
                this.getColumnAnnotationOnMethod(iMethodBinding, string2, map);
                this.getColumnAnnotationOnMethod(iMethodBinding2, string2, map);
            }
        }
    }

    void processBeanInformationForOutput(ITypeBinding iTypeBinding, MethodInfo methodInfo, SimpleType simpleType) {
        BeanInformation beanInformation = new BeanInformation(iTypeBinding.getQualifiedName());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        LinkedList<String> linkedList = new LinkedList<String>();
        ITypeBinding iTypeBinding2 = iTypeBinding;
        LinkedList<ITypeBinding> linkedList2 = new LinkedList<ITypeBinding>();
        this.getInheritedListForTypeBinding(iTypeBinding2, linkedList2, linkedList);
        beanInformation.setBeanInteritanceList(linkedList);
        this.getColumnOverrideMap(linkedList2, hashMap, simpleType, methodInfo);
        for (int i10 = 0; i10 < linkedList2.size(); ++i10) {
            iTypeBinding2 = linkedList2.get(i10);
            IMethodBinding[] iMethodBindingArray = iTypeBinding2.getDeclaredMethods();
            int n2 = iMethodBindingArray.length;
            for (int i11 = 0; i11 < n2; ++i11) {
                IMethod iMethod;
                IMethodBinding iMethodBinding = iMethodBindingArray[i11];
                if (!this.checkModifiersForVisibility(iMethodBinding.getModifiers()) || (iMethod = (IMethod)iMethodBinding.getJavaElement()) == null) continue;
                String string = iMethod.getElementName();
                String string2 = this.getFieldName(string);
                if (string2 == null) {
                    if (!string.equals("set")) continue;
                    beanInformation.setParameterWrapperForSetMethod("set");
                    continue;
                }
                this.processMethodInformation(string, string2, iMethodBinding, i11, simpleType, beanInformation, iMethodBindingArray, hashMap3);
            }
            IVariableBinding[] iVariableBindingArray = iTypeBinding2.getDeclaredFields();
            this.processFieldInformation(simpleType, beanInformation, hashMap, hashMap2, hashMap3, iVariableBindingArray);
        }
        String string = iTypeBinding.getQualifiedName();
        methodInfo.addOutputBeanInfoMap(string, beanInformation);
    }

    private void processFieldInformation(SimpleType simpleType, BeanInformation beanInformation, Map<String, String> map, Map<String, String> map2, Map<String, String> map3, IVariableBinding[] iVariableBindingArray) {
        LinkedHashMap<String, BeanPropertyInformation> linkedHashMap = new LinkedHashMap<String, BeanPropertyInformation>();
        for (IVariableBinding iVariableBinding : iVariableBindingArray) {
            boolean bl2 = this.checkModifiersForVisibility(iVariableBinding.getModifiers());
            String string = iVariableBinding.getName();
            String string2 = this.getAnnotationValue(map3, map2, map, iVariableBinding, string);
            if (!bl2 && string2 == null) continue;
            ITypeBinding iTypeBinding = iVariableBinding.getType();
            TypeInfo typeInfo = this.setTypeInfo(string, iTypeBinding, simpleType);
            this.addPropertyToBeanInfoMap(linkedHashMap, beanInformation, string, typeInfo, string2, bl2);
        }
        this.transferNoOverwrite(linkedHashMap, beanInformation.getBeanPropertyMap());
        beanInformation.setBeanPropertyMap(linkedHashMap);
    }

    private void transferNoOverwrite(Map<String, BeanPropertyInformation> map, Map<String, BeanPropertyInformation> map2) {
        for (String string : map2.keySet()) {
            if (map.containsKey(string)) continue;
            map.put(string, map2.get(string));
        }
    }

    void processBeanInformation(ITypeBinding iTypeBinding, MethodInfo methodInfo, SimpleType simpleType, int n2, boolean bl2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        BeanInformation beanInformation = new BeanInformation(iTypeBinding.getQualifiedName());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        ITypeBinding iTypeBinding2 = iTypeBinding;
        LinkedList<ITypeBinding> linkedList2 = new LinkedList<ITypeBinding>();
        this.getInheritedListForTypeBinding(iTypeBinding2, linkedList2, linkedList);
        beanInformation.setBeanInteritanceList(linkedList);
        this.getColumnOverrideMap(linkedList2, hashMap3, simpleType, methodInfo);
        for (int i10 = 0; i10 < linkedList2.size(); ++i10) {
            iTypeBinding2 = linkedList2.get(i10);
            IMethodBinding[] iMethodBindingArray = iTypeBinding2.getDeclaredMethods();
            int n3 = iMethodBindingArray.length;
            for (int i11 = 0; i11 < n3; ++i11) {
                IMethod iMethod;
                IMethodBinding iMethodBinding = iMethodBindingArray[i11];
                if (!this.checkModifiersForVisibility(iMethodBinding.getModifiers()) || (iMethod = (IMethod)iMethodBinding.getJavaElement()) == null) continue;
                String string = iMethod.getElementName();
                String string2 = this.getFieldNameForInput(string);
                if (string2 == null) {
                    if (!string.equals("get")) continue;
                    beanInformation.setParameterWrapperForGetMethod("get");
                    continue;
                }
                this.processMethodInformation(string, string2, iMethodBinding, i11, simpleType, beanInformation, iMethodBindingArray, hashMap);
            }
            IVariableBinding[] iVariableBindingArray = iTypeBinding2.getDeclaredFields();
            this.processFieldInformation(simpleType, beanInformation, hashMap3, hashMap2, hashMap, iVariableBindingArray);
            this.getGeneratedKeyInformation(beanInformation, iVariableBindingArray);
        }
        if (bl2) {
            methodInfo.addInputBeanInfo(n2, beanInformation);
        } else {
            methodInfo.addOutputBeanInfoMap(iTypeBinding.getQualifiedName(), beanInformation);
        }
    }

    private IMethodBinding findMatchingAccessorMethodAndSetBeanInfo(BeanInformation beanInformation, boolean bl2, IMethodBinding[] iMethodBindingArray, int n2, String string, String string2, String string3, ITypeBinding iTypeBinding, TypeInfo typeInfo) {
        for (int i10 = n2 + 1; i10 < iMethodBindingArray.length; ++i10) {
            ITypeBinding iTypeBinding2;
            String string4;
            IMethod iMethod;
            IMethodBinding iMethodBinding = iMethodBindingArray[i10];
            if (!this.checkModifiersForVisibility(iMethodBinding.getModifiers()) || (iMethod = (IMethod)iMethodBinding.getJavaElement()) == null || !(string4 = iMethod.getElementName()).equals(string3) || (iTypeBinding2 = this.getParameterOrReturnTypeBinding(iMethodBinding, string4)) == null || !iTypeBinding.getQualifiedName().equals(iTypeBinding2.getQualifiedName())) continue;
            BeanPropertyInformation beanPropertyInformation = new BeanPropertyInformation();
            beanPropertyInformation.setPropertyTypeInfo(typeInfo);
            if (bl2) {
                beanPropertyInformation.setReadMethod(string);
                beanPropertyInformation.setWriteMethod(string3);
            } else {
                beanPropertyInformation.setReadMethod(string3);
                beanPropertyInformation.setWriteMethod(string);
            }
            beanPropertyInformation.setCaseSensitivePropertyName(string2);
            beanInformation.addBeanPropertyMap(string2.toLowerCase(), beanPropertyInformation);
            return iMethodBinding;
        }
        return null;
    }

    private boolean getGeneratedKeyInformation(BeanInformation beanInformation, IVariableBinding[] iVariableBindingArray) {
        boolean bl2 = false;
        for (IVariableBinding iVariableBinding : iVariableBindingArray) {
            IAnnotationBinding[] iAnnotationBindingArray;
            for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iVariableBinding.getAnnotations()) {
                ITypeBinding iTypeBinding = iAnnotationBinding.getAnnotationType();
                String string = iTypeBinding.getQualifiedName();
                if (!"com.ibm.db2.cmx.annotation.GeneratedKey".equals(string)) continue;
                boolean bl3 = false;
                block2: for (IAnnotationBinding iAnnotationBinding2 : iAnnotationBindingArray) {
                    IMemberValuePairBinding[] iMemberValuePairBindingArray;
                    ITypeBinding iTypeBinding2 = iAnnotationBinding2.getAnnotationType();
                    String string2 = iTypeBinding2.getQualifiedName();
                    if (!"com.ibm.db2.cmx.annotation.Column".equals(string2)) continue;
                    for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding2.getDeclaredMemberValuePairs()) {
                        if (!iMemberValuePairBinding.getName().equalsIgnoreCase("name")) continue;
                        beanInformation.addAutoGeneratedKeys((String)iMemberValuePairBinding.getValue());
                        bl3 = true;
                        bl2 = true;
                        continue block2;
                    }
                }
                if (bl3) continue;
                beanInformation.addAutoGeneratedKeys(iVariableBinding.getName());
                bl2 = true;
            }
        }
        return bl2;
    }

    private void getInheritedListForTypeBinding(ITypeBinding iTypeBinding, LinkedList<ITypeBinding> linkedList, LinkedList<String> linkedList2) {
        String string;
        IPackageBinding iPackageBinding = iTypeBinding.getPackage();
        String string2 = string = null == iPackageBinding ? null : iPackageBinding.getName();
        while (!(null == iTypeBinding || iTypeBinding.getName().equals("Object") || null != string && 1 <= string.length() && (string.startsWith("java.") || string.startsWith("javax.")))) {
            linkedList.addFirst(iTypeBinding);
            String string3 = iTypeBinding.getQualifiedName().trim();
            linkedList2.addFirst(string3);
            iTypeBinding = iTypeBinding.getSuperclass();
            iPackageBinding = null == iTypeBinding ? null : iTypeBinding.getPackage();
            string = null == iPackageBinding ? null : iPackageBinding.getName();
        }
    }

    private TypeInfo setTypeInfo(String string, ITypeBinding iTypeBinding, SimpleType simpleType) {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.setTypeName(iTypeBinding.getName());
        typeInfo.setQualifiedName(iTypeBinding.getQualifiedName());
        typeInfo.setName(string);
        String string2 = iTypeBinding.getPackage() == null ? null : iTypeBinding.getPackage().getName();
        typeInfo.setPackageName(string2);
        typeInfo.setSimpleType(true);
        typeInfo.setJavaType(TypeHelper.getJavaType(iTypeBinding.getTypeDeclaration().getQualifiedName(), simpleType.getAST(), iTypeBinding, this.bindingsMap_));
        return typeInfo;
    }

    private boolean checkModifiersForVisibility(int n2) {
        return !Modifier.isPrivate((int)n2) && !Modifier.isProtected((int)n2) && !Modifier.isFinal((int)n2);
    }

    private void getColumnAnnotationOnMethod(IMethodBinding iMethodBinding, String string, Map<String, String> map) {
        IAnnotationBinding[] iAnnotationBindingArray;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iMethodBinding.getAnnotations()) {
            IMemberValuePairBinding[] iMemberValuePairBindingArray;
            String string2 = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Column".equals(string2)) continue;
            for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getAllMemberValuePairs()) {
                String string3 = iMemberValuePairBinding.getName();
                if (!"name".equals(string3)) continue;
                String string4 = (String)iMemberValuePairBinding.getValue();
                if (iMemberValuePairBinding.isDefault() && "".equals(string4)) continue;
                map.put(string, string4.toLowerCase());
            }
        }
    }

    private void getColumnAnnotationOnField(IVariableBinding iVariableBinding, String string, Map<String, String> map) {
        IAnnotationBinding[] iAnnotationBindingArray;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iVariableBinding.getAnnotations()) {
            IMemberValuePairBinding[] iMemberValuePairBindingArray;
            String string2 = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Column".equals(string2)) continue;
            for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getAllMemberValuePairs()) {
                String string3 = iMemberValuePairBinding.getName();
                if (!"name".equals(string3)) continue;
                String string4 = (String)iMemberValuePairBinding.getValue();
                if (iMemberValuePairBinding.isDefault() && "".equals(string4)) continue;
                map.put(string, string4.toLowerCase());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void setBaseType(TypeInfo typeInfo, MethodInfo methodInfo) {
        if ((typeInfo.isParameterizedType() || typeInfo.isArrayType()) && typeInfo.getJavaType() != JavaType.MAP) {
            List<TypeInfo> list = typeInfo.getParameterizedType();
            if (list == null || list.size() <= 0) throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_SETPTYPE", new Object[0]), null, 10147, null, methodInfo);
            typeInfo.setBaseType(list.get(0));
            return;
        } else {
            typeInfo.setBaseType(typeInfo);
        }
    }

    void processTypeForOuput(Type type, TypeInfo typeInfo, MethodInfo methodInfo) {
        if (type.isPrimitiveType()) {
            this.setTypeInfoForPrimitive(type, typeInfo);
        } else if (type.isSimpleType()) {
            this.processSimpleTypeForOutput((SimpleType)type, typeInfo, methodInfo);
        } else if (type.isParameterizedType()) {
            Type type2 = ((ParameterizedType)type).getType();
            typeInfo.setParameterizedType(true);
            if (!type2.isSimpleType()) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_TYPE_NOTSUP", type2.getClass()), null, 10261, (ASTNode)type2, methodInfo);
            }
            this.processSimpleTypeForOutput((SimpleType)type2, typeInfo, methodInfo);
            List list = ((ParameterizedType)type).typeArguments();
            ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
            for (Type type3 : list) {
                TypeInfo typeInfo2 = new TypeInfo();
                arrayList.add(typeInfo2);
                this.processTypeForOuput(type3, typeInfo2, methodInfo);
            }
            typeInfo.setParameterizedType(arrayList);
        } else if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            typeInfo.setArrayType(true);
            typeInfo.setJavaType(JavaType.ARRAY);
            ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
            TypeInfo typeInfo3 = new TypeInfo();
            arrayList.add(typeInfo3);
            this.processTypeForOuput(arrayType.getComponentType(), typeInfo3, methodInfo);
            typeInfo.setParameterizedType(arrayList);
        }
    }
}

