/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import java.io.Serializable;
import java.sql.SQLException;
import org.firebirdsql.jaybird.xca.FBConnectionRequestInfo;
import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jaybird.xca.FBManagedConnectionFactory;
import org.firebirdsql.jaybird.xca.XcaConnectionEvent;
import org.firebirdsql.jaybird.xca.XcaConnectionEventListener;
import org.firebirdsql.jaybird.xca.XcaConnectionManager;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class FBStandAloneConnectionManager
implements XcaConnectionManager,
XcaConnectionEventListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(FBStandAloneConnectionManager.class);

    FBStandAloneConnectionManager() {
    }

    @Override
    public FirebirdConnection allocateConnection(FBManagedConnectionFactory mcf, FBConnectionRequestInfo cxRequestInfo) throws SQLException {
        FBManagedConnection mc = mcf.createManagedConnection(cxRequestInfo);
        mc.setManagedEnvironment(false);
        mc.addConnectionEventListener(this);
        return mc.getConnection();
    }

    @Override
    public void connectionClosed(XcaConnectionEvent ce) {
        try {
            ce.getSource().destroy(ce);
        }
        catch (SQLException e) {
            log.debug("Exception closing unmanaged connection: ", e);
        }
    }

    @Override
    public void connectionErrorOccurred(XcaConnectionEvent ce) {
        log.debug("ConnectionErrorOccurred, ", ce.getException());
        try {
            ce.getSource().destroy(ce);
        }
        catch (SQLException e) {
            log.debug("further problems destroying connection: ", e);
        }
    }
}

