/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.jdbc.field.TypeConversionException;

final class FBBigDecimalField
extends FBField {
    private static final BigInteger MAX_SHORT = BigInteger.valueOf(32767L);
    private static final BigInteger MIN_SHORT = BigInteger.valueOf(-32768L);
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigDecimal BD_MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigDecimal BD_MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal BD_MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal BD_MIN_DOUBLE = new BigDecimal(-1.7976931348623157E308);
    private final FieldDataSize fieldDataSize;

    FBBigDecimalField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        this.fieldDataSize = FieldDataSize.getFieldDataSize(fieldDescriptor);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getBigDecimal();
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.getByte() == 1;
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > 127L || longValue < -128L) {
            throw this.invalidGetConversion("byte", String.format("value %d out of range", longValue));
        }
        return (byte)longValue;
    }

    @Override
    public double getDouble() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    @Override
    public float getFloat() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }

    @Override
    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw this.invalidGetConversion("int", String.format("value %d out of range", longValue));
        }
        return (int)longValue;
    }

    @Override
    public long getLong() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return 0L;
        }
        if (BD_MIN_LONG.compareTo(value) > 0 || value.compareTo(BD_MAX_LONG) > 0) {
            throw this.invalidGetConversion("long", String.format("value %f out of range", value));
        }
        return value.longValue();
    }

    @Override
    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > 32767L || longValue < -32768L) {
            throw this.invalidGetConversion("short", String.format("value %d out of range", longValue));
        }
        return (short)longValue;
    }

    @Override
    public String getString() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.fieldDataSize.decode(this.fieldDescriptor, this.getFieldData());
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return null;
        }
        return value.toBigInteger();
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setLong(value ? 1L : 0L);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setBigDecimal(BigDecimal.valueOf(value));
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setBigDecimal(BigDecimal.valueOf(value));
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setBigDecimal(this.fromString(value, BigDecimal::new));
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.fieldDataSize.encode(this.fieldDescriptor, value));
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setBigDecimal(new BigDecimal(value));
    }

    private static enum FieldDataSize {
        SHORT{

            @Override
            protected BigDecimal decode(FieldDescriptor fieldDescriptor, byte[] fieldData) {
                long value = fieldDescriptor.getDatatypeCoder().decodeShort(fieldData);
                return BigDecimal.valueOf(value, -1 * fieldDescriptor.getScale());
            }

            @Override
            protected byte[] encode(FieldDescriptor fieldDescriptor, BigDecimal value) throws SQLException {
                BigInteger unscaledValue = FieldDataSize.normalize(value, -1 * fieldDescriptor.getScale());
                if (unscaledValue.compareTo(MAX_SHORT) > 0 || unscaledValue.compareTo(MIN_SHORT) < 0) {
                    throw this.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeShort(unscaledValue.shortValue());
            }
        }
        ,
        INTEGER{

            @Override
            protected BigDecimal decode(FieldDescriptor fieldDescriptor, byte[] fieldData) {
                long value = fieldDescriptor.getDatatypeCoder().decodeInt(fieldData);
                return BigDecimal.valueOf(value, -1 * fieldDescriptor.getScale());
            }

            @Override
            protected byte[] encode(FieldDescriptor fieldDescriptor, BigDecimal value) throws SQLException {
                BigInteger unscaledValue = FieldDataSize.normalize(value, -1 * fieldDescriptor.getScale());
                if (unscaledValue.compareTo(MAX_INT) > 0 || unscaledValue.compareTo(MIN_INT) < 0) {
                    throw this.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeInt(unscaledValue.intValue());
            }
        }
        ,
        LONG{

            @Override
            protected BigDecimal decode(FieldDescriptor fieldDescriptor, byte[] fieldData) {
                long value = fieldDescriptor.getDatatypeCoder().decodeLong(fieldData);
                return BigDecimal.valueOf(value, -1 * fieldDescriptor.getScale());
            }

            @Override
            protected byte[] encode(FieldDescriptor fieldDescriptor, BigDecimal value) throws SQLException {
                BigInteger unscaledValue = FieldDataSize.normalize(value, -1 * fieldDescriptor.getScale());
                if (unscaledValue.compareTo(MAX_LONG) > 0 || unscaledValue.compareTo(MIN_LONG) < 0) {
                    throw this.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeLong(unscaledValue.longValue());
            }
        }
        ,
        DOUBLE{

            @Override
            protected BigDecimal decode(FieldDescriptor fieldDescriptor, byte[] fieldData) {
                BigDecimal value = new BigDecimal(fieldDescriptor.getDatatypeCoder().decodeDouble(fieldData));
                return value.setScale(Math.abs(fieldDescriptor.getScale()), RoundingMode.HALF_EVEN);
            }

            @Override
            protected byte[] encode(FieldDescriptor fieldDescriptor, BigDecimal value) throws SQLException {
                if (value.compareTo(BD_MAX_DOUBLE) > 0 || value.compareTo(BD_MIN_DOUBLE) < 0) {
                    throw this.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeDouble(value.doubleValue());
            }
        }
        ,
        INT128{

            @Override
            protected BigDecimal decode(FieldDescriptor fieldDescriptor, byte[] fieldData) {
                BigInteger int128Value = fieldDescriptor.getDatatypeCoder().decodeInt128(fieldData);
                return new BigDecimal(int128Value, -1 * fieldDescriptor.getScale());
            }

            @Override
            protected byte[] encode(FieldDescriptor fieldDescriptor, BigDecimal value) throws SQLException {
                BigInteger unscaledValue = FieldDataSize.normalize(value, -1 * fieldDescriptor.getScale());
                if (unscaledValue.bitLength() > 127) {
                    throw this.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeInt128(unscaledValue);
            }
        };


        protected abstract BigDecimal decode(FieldDescriptor var1, byte[] var2) throws SQLException;

        protected abstract byte[] encode(FieldDescriptor var1, BigDecimal var2) throws SQLException;

        private static BigInteger normalize(BigDecimal value, int scale) {
            BigDecimal valueToScale = value.setScale(scale, RoundingMode.HALF_UP);
            return valueToScale.unscaledValue();
        }

        protected static FieldDataSize getFieldDataSize(FieldDescriptor fieldDescriptor) throws SQLException {
            switch (fieldDescriptor.getType() & 0xFFFFFFFE) {
                case 500: {
                    return SHORT;
                }
                case 496: {
                    return INTEGER;
                }
                case 580: {
                    return LONG;
                }
                case 480: {
                    return DOUBLE;
                }
                case 32752: {
                    return INT128;
                }
            }
            throw FbExceptionBuilder.forException(337248277).messageParameter(fieldDescriptor.getType()).toSQLException();
        }

        SQLException bigDecimalConversionError(FieldDescriptor fieldDescriptor, BigDecimal value) {
            String message = String.format("Unsupported set conversion requested for field %s at index %d (JDBC type %s), source type: java.math.BigDecimal, reason: value %f out of range", fieldDescriptor.getFieldName(), fieldDescriptor.getPosition() + 1, FBField.getJdbcTypeName(JdbcTypeConverter.toJdbcType(fieldDescriptor)), value);
            return new TypeConversionException(message);
        }
    }
}

