/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.props.internal;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.firebirdsql.jaybird.fb.constants.DpbItems;
import org.firebirdsql.jaybird.fb.constants.SpbItems;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.props.spi.ConnectionPropertyDefinerSpi;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class UnregisteredDpbDefiner
implements ConnectionPropertyDefinerSpi {
    private final Logger log = LoggerFactory.getLogger(UnregisteredDpbDefiner.class);
    private final Collection<String> knownPropertyNames;
    private final Set<String> excludedShortNames;

    UnregisteredDpbDefiner(Collection<String> knownPropertyNames) {
        this.knownPropertyNames = knownPropertyNames;
        this.excludedShortNames = new HashSet<String>(Arrays.asList("trusted_auth", "specific_auth_data", "auth_block", "auth_plugin_list", "auth_plugin_name", "password_enc", "utf8_filename", "client_version"));
    }

    @Override
    public Stream<ConnectionProperty> defineProperties() {
        Map<String, Integer> dpbItems = this.findItems(DpbItems.class, "isc_dpb_");
        Map<String, Integer> spbItems = this.findItems(SpbItems.class, "isc_spb_");
        return dpbItems.keySet().stream().map(shortName -> {
            this.log.debugf("Defining unregistered DPB/SPB property %s", shortName);
            ConnectionProperty.Builder builder = ConnectionProperty.builder(shortName);
            if (dpbItems.containsKey(shortName)) {
                builder.aliases(("isc_dpb_" + shortName).intern());
                builder.dpbItem((Integer)dpbItems.get(shortName));
            }
            if (spbItems.containsKey(shortName)) {
                builder.spbItem((Integer)spbItems.get(shortName));
            }
            return builder.build();
        });
    }

    private Map<String, Integer> findItems(Class<?> clazz, String prefix) {
        int prefixLength = prefix.length();
        HashMap<String, Integer> items = new HashMap<String, Integer>();
        for (Field field : clazz.getFields()) {
            int value;
            String name = field.getName();
            if (!name.startsWith(prefix) || field.getType() != Integer.TYPE) continue;
            try {
                value = field.getInt(null);
            }
            catch (IllegalAccessException iaex) {
                continue;
            }
            String shortName = name.substring(prefixLength);
            if (this.knownPropertyNames.contains(shortName) || this.knownPropertyNames.contains(name) || this.excludedShortNames.contains(shortName)) continue;
            items.put(shortName, value);
        }
        return items;
    }

    @Override
    public void notRegistered(ConnectionProperty connectionProperty) {
        this.log.debugf("Property not registered: %s", (Object)connectionProperty);
    }
}

